/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.console.views.table.CvTblAlarmEvent;
import com.sun.symon.base.console.views.table.CvTblAlarmListener;
import com.sun.symon.base.console.views.table.CvTblFilterEvent;
import com.sun.symon.base.console.views.table.CvTblFilterListener;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CvTblAlarmFilter
extends JPanel
implements ActionListener,
CvTblFilterListener {
    static final String ERR = "ERR";
    static final String WRN = "WRN";
    static final String INF = "INF";
    static final String DWN = "DWN";
    String[] buttonKey = new String[]{"OK", "ERR", "WRN", "INF", "DWN"};
    String[] toolTips = new String[5];
    JButton[] buttons = new JButton[5];
    ButtonStatus buttonStat;
    CvTblTable table;
    Vector alarmListeners = new Vector();
    SMRawDataRequest handle;
    String[] iconFiles = new String[]{"stdimages/AllTableRows-16x16.gif", "stdimages/alarmSev2.gif", "stdimages/alarmSev3.gif", "stdimages/alarmSev4.gif", "stdimages/alarmSev5.gif"};

    public CvTblAlarmFilter(CvTblTable cvTblTable, SMRawDataRequest sMRawDataRequest) {
        this(cvTblTable, sMRawDataRequest, "");
    }

    public CvTblAlarmFilter(CvTblTable cvTblTable, SMRawDataRequest sMRawDataRequest, String string) {
        this.setBackground(Color.white);
        this.table = cvTblTable;
        this.handle = sMRawDataRequest;
        this.setLayout(new BoxLayout(this, 0));
        this.buttonStat = new ButtonStatus(string);
        this.createUI();
        this.updateButtonStatus(this.buttonStat.getStatus());
        this.toolTips[0] = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:status.All");
        this.toolTips[1] = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:status.Critical");
        this.toolTips[2] = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:status.Alert");
        this.toolTips[3] = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:status.Caution");
        this.toolTips[4] = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:status.Off");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getButtonIndex(actionEvent.getActionCommand());
        this.buttonStat.pressButton(n);
        this.updateButtonStatus(this.buttonStat.getStatus());
        this.fireAlarmChanged();
    }

    public void addAlarmListener(CvTblAlarmListener cvTblAlarmListener) {
        this.alarmListeners.add(cvTblAlarmListener);
    }

    private void createUI() {
        Font font = new Font("dialog", 0, 8);
        int n = 0;
        while (n < this.buttonKey.length) {
            SMResourceAccess sMResourceAccess = new SMResourceAccess(this.handle);
            Image image = sMResourceAccess.getImage(this.iconFiles[n]);
            ImageIcon imageIcon = new ImageIcon(image);
            JButton jButton = new JButton("0", imageIcon);
            jButton.setModel(new MyButtonModel());
            jButton.setSize(new Dimension(20, 20));
            jButton.setVerticalTextPosition(3);
            Insets insets = new Insets(0, 0, 0, 0);
            jButton.setFont(font);
            jButton.setMargin(insets);
            jButton.setHorizontalTextPosition(0);
            jButton.setActionCommand(this.buttonKey[n]);
            this.buttons[n] = jButton;
            jButton.addActionListener(this);
            this.add(jButton);
            ++n;
        }
        this.buttons[4].setVisible(false);
    }

    public void fireAlarmChanged() {
        int n = 0;
        while (n < this.alarmListeners.size()) {
            String string = this.buttonStat.getAlarmString();
            CvTblAlarmEvent cvTblAlarmEvent = new CvTblAlarmEvent(this.table, string);
            ((CvTblAlarmListener)this.alarmListeners.get(n)).alarmFilterChanged(cvTblAlarmEvent);
            ++n;
        }
    }

    private int getButtonIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < this.buttonKey.length) {
            if (this.buttonKey[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void labelsChanged(CvTblFilterEvent cvTblFilterEvent) {
        String[] stringArray = cvTblFilterEvent.getLabels();
        if (stringArray == null || stringArray.length < this.buttons.length) {
            return;
        }
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].setText(stringArray[n]);
            this.buttons[n].setToolTipText(String.valueOf(this.toolTips[n]) + ": " + stringArray[n]);
            ++n;
        }
    }

    public void removeAlarmListener(CvTblAlarmListener cvTblAlarmListener) {
        this.alarmListeners.remove(cvTblAlarmListener);
    }

    public void setFilter(String string) {
        this.buttonStat.updateMask(string);
        this.updateButtonStatus(this.buttonStat.getStatus());
    }

    private void updateButtonStatus(boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            ((MyButtonModel)this.buttons[n].getModel()).setPressState(blArray[n] ^ true);
            ++n;
        }
    }

    class MyButtonModel
    extends DefaultButtonModel {
        MyButtonModel() {
        }

        public void setPressState(boolean bl) {
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (bl) {
                this.stateMask |= 1;
                this.stateMask |= 4;
            } else {
                this.stateMask &= 0xFFFFFFFE;
                this.stateMask &= 0xFFFFFFFB;
            }
            this.fireStateChanged();
        }
    }

    class ButtonStatus {
        public static final int ALL = 0;
        public static final int ERR = 1;
        public static final int WRN = 2;
        public static final int INF = 4;
        public static final int DWN = 8;
        private int alarmMask = 0;
        private int[] bits;
        String[] severity;

        public ButtonStatus() {
            this("");
        }

        public ButtonStatus(String string) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 4;
            nArray[4] = 8;
            this.bits = nArray;
            this.severity = new String[]{CvTblAlarmFilter.ERR, CvTblAlarmFilter.WRN, CvTblAlarmFilter.INF, CvTblAlarmFilter.DWN};
            this.updateMask(string);
        }

        public int getAlarmMask() {
            return this.alarmMask;
        }

        public String getAlarmString() {
            String string = "";
            if (this.alarmMask == 0) {
                string = "";
            } else {
                int n = 1;
                while (n < this.bits.length) {
                    if ((this.alarmMask & this.bits[n]) != 0) {
                        string = String.valueOf(string) + this.severity[n - 1] + " ";
                    }
                    ++n;
                }
            }
            return string;
        }

        public boolean[] getStatus() {
            boolean[] blArray = new boolean[]{true, true, true, true, true};
            if (this.alarmMask != 0) {
                blArray[0] = false;
                int n = 1;
                while (n < this.bits.length) {
                    blArray[n] = (this.alarmMask & this.bits[n]) != 0;
                    ++n;
                }
            }
            return blArray;
        }

        public void pressButton(int n) {
            this.alarmMask = n == 0 ? 0 : (this.alarmMask |= this.bits[n]);
        }

        public void updateMask(String string) {
            if (string.equals("")) {
                this.alarmMask = 0;
            } else {
                int n = 0;
                while (n < this.severity.length) {
                    if (string.indexOf(this.severity[n]) != -1) {
                        this.alarmMask |= this.bits[n + 1];
                    }
                    ++n;
                }
            }
        }
    }
}

