/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.topology.SMTopologyEntityData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;

class CmTopologyEditRunnable
implements Runnable {
    private SMTopologyRequest RequestHandle;
    private String BaseUrl;
    private String EntityId;
    private AwxServiceProvider SvcProvider;
    private SMModuleRequest moduleHandle;

    CmTopologyEditRunnable(SMTopologyRequest sMTopologyRequest, SMModuleRequest sMModuleRequest, String string, AwxServiceProvider awxServiceProvider) {
        this.RequestHandle = sMTopologyRequest;
        this.moduleHandle = sMModuleRequest;
        this.SvcProvider = awxServiceProvider;
        this.BaseUrl = null;
        this.EntityId = null;
        int n = string.indexOf(35);
        if (n < 0) {
            this.BaseUrl = string;
        } else {
            this.BaseUrl = string.substring(0, n);
            this.EntityId = string.substring(n + 1);
        }
    }

    CmTopologyEditRunnable(SMTopologyRequest sMTopologyRequest, SMModuleRequest sMModuleRequest, String string, String string2, AwxServiceProvider awxServiceProvider) {
        this.RequestHandle = sMTopologyRequest;
        this.moduleHandle = sMModuleRequest;
        this.SvcProvider = awxServiceProvider;
        this.BaseUrl = string;
        this.EntityId = string2;
    }

    public void run() {
        if (this.BaseUrl == null || this.EntityId == null) {
            return;
        }
        String[] stringArray = null;
        try {
            SMTopologyEntityData[] sMTopologyEntityDataArray = this.RequestHandle.getTopologyInfo(this.BaseUrl, new String[]{this.EntityId});
            stringArray = new String[26];
            stringArray[0] = "arch=" + sMTopologyEntityDataArray[0].getArch();
            stringArray[1] = "config=" + sMTopologyEntityDataArray[0].getConfig();
            stringArray[2] = "desc=" + UcInternationalizer.translateKey((String)sMTopologyEntityDataArray[0].getDesc());
            stringArray[3] = "entityId=" + sMTopologyEntityDataArray[0].getEntityId();
            stringArray[4] = "family=" + sMTopologyEntityDataArray[0].getFamily();
            stringArray[5] = "fulldesc=" + sMTopologyEntityDataArray[0].getFullDesc();
            stringArray[6] = "hostname=" + sMTopologyEntityDataArray[0].getHostName();
            stringArray[7] = "ipaddr=" + sMTopologyEntityDataArray[0].getIpAddr();
            stringArray[8] = "ispoll=" + sMTopologyEntityDataArray[0].getIsPoll();
            stringArray[9] = "netmask=" + sMTopologyEntityDataArray[0].getNetmask();
            stringArray[10] = "polltype=" + sMTopologyEntityDataArray[0].getPollType();
            stringArray[11] = "readinfo=" + sMTopologyEntityDataArray[0].getReadInfo();
            stringArray[12] = "targethost=" + sMTopologyEntityDataArray[0].getTargetHost();
            stringArray[13] = "targetip=" + sMTopologyEntityDataArray[0].getTargetIP();
            stringArray[14] = "targeturl=" + sMTopologyEntityDataArray[0].getTargetUrl();
            stringArray[15] = "type=" + sMTopologyEntityDataArray[0].getType();
            stringArray[16] = "writeinfo=" + sMTopologyEntityDataArray[0].getWriteInfo();
            stringArray[17] = "xcoord=" + sMTopologyEntityDataArray[0].getXCoord();
            stringArray[18] = "ycoord=" + sMTopologyEntityDataArray[0].getYCoord();
            stringArray[19] = "baseUrl=" + this.BaseUrl;
            stringArray[20] = "typekey=";
            UcAgentURL ucAgentURL = new UcAgentURL(sMTopologyEntityDataArray[0].getTargetUrl());
            stringArray[21] = "port=" + ucAgentURL.getPort();
            stringArray[22] = "modmodule=";
            stringArray[23] = "modmoduleurl=";
            stringArray[24] = "proxymodule=";
            stringArray[25] = "proxymoduleurl=";
            if (stringArray[15].equals("type=bus")) {
                stringArray[20] = "typekey=bus";
                this.SvcProvider.triggerService("editSegmentObject", stringArray);
                return;
            }
            if (stringArray[15].equals("type=ring")) {
                stringArray[20] = "typekey=ring";
                this.SvcProvider.triggerService("editSegmentObject", stringArray);
                return;
            }
            if (stringArray[15].equals("type=composite")) {
                stringArray[20] = "typekey=objects";
                this.SvcProvider.triggerService("editCompositeViewObject", stringArray);
                return;
            }
            if (ucAgentURL.getModuleId().equals("topology")) {
                stringArray[20] = stringArray[7].equals("ipaddr=") && stringArray[9].equals("netmask=") ? "typekey=general" : "typekey=ipbased";
                this.SvcProvider.triggerService("editChildViewObject", stringArray);
                return;
            }
            if (stringArray[15].equals("type=platform")) {
                stringArray[20] = "typekey=platform";
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
            if (stringArray[10].equals("polltype=ahost")) {
                stringArray[20] = "typekey=host";
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
            if (stringArray[10].equals("polltype=amod")) {
                stringArray[20] = "typekey=module";
                stringArray[22] = "modmodule=" + ucAgentURL.getModuleSpec();
                try {
                    String[][] stringArray2 = this.moduleHandle.getLoadedModuleInfo(sMTopologyEntityDataArray[0].getHostName(), Integer.parseInt(ucAgentURL.getPort()));
                    int n = 0;
                    while (n < stringArray2.length) {
                        UcAgentURL ucAgentURL2 = new UcAgentURL(stringArray2[n][1]);
                        if (ucAgentURL.getModuleSpec().equals(ucAgentURL2.getModuleSpec())) {
                            stringArray[22] = "modmodule=" + stringArray2[n][0];
                        }
                        ++n;
                    }
                }
                catch (SMAPIException sMAPIException) {
                    UcDDL.logErrorMessage((String)("CmTopologyControl --- " + (Object)((Object)sMAPIException)));
                }
                stringArray[23] = "modmoduleurl=" + ucAgentURL.getURL();
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
            if (stringArray[10].equals("polltype=aprox")) {
                stringArray[20] = "typekey=proxy";
                stringArray[24] = "proxymodule=" + ucAgentURL.getModuleSpec();
                stringArray[25] = "proxymoduleurl=" + ucAgentURL.getURL();
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
            if (stringArray[10].equals("polltype=snmp")) {
                stringArray[20] = "typekey=snmp";
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
            if (stringArray[10].equals("polltype=ping")) {
                stringArray[20] = "typekey=icmp";
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
            if (stringArray[10].equals("polltype=dummy")) {
                stringArray[20] = "typekey=none";
                this.SvcProvider.triggerService("editNodeObject", stringArray);
                return;
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)"Error getting topology object info", (Throwable)sMAPIException);
        }
    }
}

