/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.awx;

import com.sun.symon.base.console.awx.AwxComponent;
import com.sun.symon.base.console.awx.AwxContainer;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class AwxSplitPane
extends AwxContainer
implements ComponentListener {
    private boolean FirstInit = false;
    private boolean RetainRatio = false;
    private boolean LeftAdded = false;
    private boolean RightAdded = false;
    private boolean CanSquishLeft = false;
    private boolean CanSquishRight = false;
    private Dimension LastSize = null;

    public void activate() {
        String string;
        String string2;
        super.activate();
        ((Component)this.Bean).addComponentListener(this);
        String string3 = this.lookup("res", "retainRatio", null);
        if (string3 != null && string3.compareTo("true") == 0) {
            this.RetainRatio = true;
        }
        if ((string2 = this.lookup("res", "allowLeftCompact", null)) != null && string2.compareTo("true") == 0) {
            this.CanSquishLeft = true;
        }
        if ((string = this.lookup("res", "allowRightCompact", null)) != null && string.compareTo("true") == 0) {
            this.CanSquishRight = true;
        }
    }

    public boolean addChildComponent(AwxComponent awxComponent) {
        if (!this.LeftAdded) {
            this.setLeftComponent(awxComponent);
            return true;
        }
        if (!this.RightAdded) {
            this.setRightComponent(awxComponent);
            return true;
        }
        UcDDL.logErrorMessage((String)("[" + this.fullName() + "] More than two children being added to " + "split pane"));
        return true;
    }

    public static void allowSquish(JSplitPane jSplitPane, Component component) {
        if (!(component instanceof JComponent)) {
            return;
        }
        Dimension dimension = ((JComponent)component).getMinimumSize();
        if (jSplitPane.getOrientation() == 0) {
            dimension.height = 0;
        } else {
            dimension.width = 0;
        }
        ((JComponent)component).setMinimumSize(dimension);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (!this.FirstInit) {
            this.LastSize = ((Component)this.Bean).getSize();
            this.testInit();
        } else {
            if (this.RetainRatio) {
                double d = 0.0;
                JSplitPane jSplitPane = (JSplitPane)this.Bean;
                d = jSplitPane.getOrientation() == 0 ? (double)jSplitPane.getDividerLocation() / (double)(this.LastSize.height - jSplitPane.getDividerSize()) : (double)jSplitPane.getDividerLocation() / (double)(this.LastSize.width - jSplitPane.getDividerSize());
                if (d < 0.0) {
                    d = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                }
                jSplitPane.setDividerLocation(d);
            }
            this.LastSize = ((Component)this.Bean).getSize();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void removeChildComponent(AwxComponent awxComponent) {
        if (this.Bean == null) {
            return;
        }
        if (((JSplitPane)this.Bean).getLeftComponent() == (Component)awxComponent.getBean()) {
            ((JSplitPane)this.Bean).remove((Component)awxComponent.getBean());
            this.LeftAdded = false;
        }
        if (((JSplitPane)this.Bean).getRightComponent() == (Component)awxComponent.getBean()) {
            ((JSplitPane)this.Bean).remove((Component)awxComponent.getBean());
            this.RightAdded = false;
        }
    }

    public void setLeftComponent(AwxComponent awxComponent) {
        Component component = (Component)awxComponent.getBean();
        ((JSplitPane)this.Bean).setLeftComponent(component);
        if (this.CanSquishLeft) {
            AwxSplitPane.allowSquish((JSplitPane)this.Bean, component);
        }
        this.LeftAdded = true;
        this.testInit();
        ((JSplitPane)this.Bean).validate();
        component.invalidate();
        component.validate();
        component.repaint();
    }

    public void setRightComponent(AwxComponent awxComponent) {
        int n = ((JSplitPane)this.Bean).getDividerLocation();
        Component component = (Component)awxComponent.getBean();
        ((JSplitPane)this.Bean).setRightComponent(component);
        ((JSplitPane)this.Bean).setDividerLocation(n);
        if (this.CanSquishRight) {
            AwxSplitPane.allowSquish((JSplitPane)this.Bean, component);
        }
        this.RightAdded = true;
        this.testInit();
        ((JSplitPane)this.Bean).validate();
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private void testInit() {
        block6: {
            if (this.FirstInit || !this.LeftAdded || !this.RightAdded || this.LastSize == null) {
                return;
            }
            this.FirstInit = true;
            String string = this.lookup("res", "dividerLocation", null);
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    ((JSplitPane)this.Bean).setDividerLocation(n);
                }
                catch (Exception exception) {
                    UcDDL.logErrorMessage((String)("[" + this.fullName() + "] Invalid dividerLocation setting " + string));
                }
            }
            if ((string = this.lookup("res", "relDividerLocation", null)) == null) break block6;
            try {
                Double d = new Double(string);
                ((JSplitPane)this.Bean).setDividerLocation(d);
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("[" + this.fullName() + "] Invalid relDividerLocation setting " + string));
            }
        }
    }
}

