/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.pv.console.presentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SMPvImagePanel
extends JPanel
implements MouseListener {
    public static final int CONDITION_NORMAL = 1;
    public static final int CONDITION_RED = 2;
    public static final int CONDITION_YELLOW = 3;
    public static final int CONDITION_BLUE = 4;
    public static final int DEPTH_NORMAL = 1;
    public static final int DEPTH_DRILL_DOWN = 2;
    public static final int DEPTH_HAS_MENU = 3;
    int condition;
    int depth;
    Image background_image_normal = null;
    Image background_image_red = null;
    Image background_image_yellow = null;
    boolean focus = false;

    public SMPvImagePanel() {
        this.background_image_normal = null;
        this.setSize(this.getParent().getSize());
    }

    public SMPvImagePanel(Image image) {
        this.setLayout(null);
        if (image != null) {
            this.background_image_normal = image;
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.background_image_normal, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
            if (!mediaTracker.isErrorID(0)) {
                this.setSize();
            }
        } else {
            this.background_image_normal = null;
        }
        this.setCondition(1);
        this.setDepth(1);
        this.addMouseListener(this);
    }

    public SMPvImagePanel(String string) {
        this.setLayout(null);
        if (!string.equals("")) {
            MediaTracker mediaTracker = new MediaTracker(this);
            this.background_image_normal = Toolkit.getDefaultToolkit().getImage(string);
            mediaTracker.addImage(this.background_image_normal, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
            if (!mediaTracker.isErrorID(0)) {
                this.setSize();
            } else {
                System.out.println("SMPvImagePanel Button: Error loading background image");
            }
        } else {
            this.background_image_normal = null;
            System.out.println("GIF file name is null ...");
        }
        this.setCondition(1);
        this.setDepth(1);
        this.addMouseListener(this);
    }

    public SMPvImagePanel(String string, int n) {
        if (!string.equals("")) {
            MediaTracker mediaTracker = new MediaTracker(this);
            this.background_image_normal = Toolkit.getDefaultToolkit().getImage(string);
            mediaTracker.addImage(this.background_image_normal, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
            if (!mediaTracker.isErrorID(0)) {
                this.setSize();
            } else {
                System.out.println("SMPvImagePanel Button: Error loading background image");
            }
        } else {
            this.background_image_normal = null;
            System.out.println("GIF file name is null ...");
        }
        this.setCondition(n);
        this.setDepth(1);
        this.addMouseListener(this);
    }

    public SMPvImagePanel(URL uRL) {
        if (uRL != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            this.background_image_normal = Toolkit.getDefaultToolkit().getImage(uRL);
            mediaTracker.addImage(this.background_image_normal, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
            if (!mediaTracker.isErrorID(0)) {
                this.setSize();
            } else {
                System.out.println("SMPvImagePanel Button: Error loading background image");
            }
        } else {
            this.background_image_normal = null;
            System.out.println("GIF file name is null ...");
        }
        this.setCondition(1);
        this.setDepth(1);
        this.addMouseListener(this);
    }

    void drawBorder(Graphics graphics) {
        if (this.getCondition() == 1) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.white);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
        }
    }

    synchronized int getCondition() {
        return this.condition;
    }

    synchronized int getDepth() {
        return this.depth;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.background_image_normal.getWidth(this), this.background_image_normal.getHeight(this));
        return dimension;
    }

    synchronized boolean inFocus() {
        return this.focus;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Container container = this.getParent();
        if (container == null || !(container instanceof SMPvImagePanel)) {
            return;
        }
        this.setFocus(true);
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Container container = this.getParent();
        if (container == null || !(container instanceof SMPvImagePanel)) {
            return;
        }
        this.setFocus(false);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Component[] componentArray;
        if (this.background_image_normal != null) {
            componentArray = this.getSize();
            switch (this.condition) {
                case 2: {
                    graphics.drawImage(this.background_image_normal, 0, 0, this);
                    graphics.setColor(Color.red);
                    graphics.drawRect(0, 0, componentArray.width - 1, componentArray.height - 1);
                    graphics.drawRect(1, 1, componentArray.width - 2, componentArray.height - 2);
                    break;
                }
                case 3: {
                    graphics.drawImage(this.background_image_normal, 0, 0, this);
                    graphics.setColor(Color.yellow);
                    graphics.drawRect(0, 0, componentArray.width - 1, componentArray.height - 1);
                    graphics.drawRect(1, 1, componentArray.width - 2, componentArray.height - 2);
                    break;
                }
                case 4: {
                    graphics.drawImage(this.background_image_normal, 0, 0, this);
                    graphics.setColor(Color.blue);
                    graphics.drawRect(0, 0, componentArray.width - 1, componentArray.height - 1);
                    graphics.drawRect(1, 1, componentArray.width - 2, componentArray.height - 2);
                    break;
                }
                default: {
                    graphics.drawImage(this.background_image_normal, 0, 0, this);
                    break;
                }
            }
        }
        componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].repaint();
            ++n;
        }
        if (this.inFocus()) {
            this.drawBorder(graphics);
        } else if (this.condition == 1) {
            this.paintBorder(graphics);
        }
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, this.background_image_normal.getWidth(this), this.background_image_normal.getHeight(this));
    }

    synchronized void setCondition(int n) {
        this.condition = n;
        this.repaint();
    }

    public synchronized void setDepth(int n) {
        this.depth = n;
        this.setWindowCursor(n);
    }

    synchronized void setFocus(boolean bl) {
        this.focus = bl;
    }

    void setSize() {
        super.setSize(this.background_image_normal.getWidth(this), this.background_image_normal.getHeight(this));
    }

    void setWindowCursor(int n) {
        switch (n) {
            case 2: 
            case 3: {
                Border border = BorderFactory.createBevelBorder(0, Color.gray, Color.darkGray);
                this.setBorder(border);
                this.setCursor(new Cursor(12));
                break;
            }
            default: {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

