# Filename: tools-editors_3_0_00_00-j.x
# Version: 1.8 01/02/14 20:17:13
# Author: J.M. Heisz, Halcyon Inc.
#
# Copyright (c) 1997 Halcyon Inc.
#
# Definitions for the different forms of editors.  Mainly configures
# datasources and managers based on a centralized gui template.
#
# Required into the .templates.tools object.

_editor = { [ use DIALOG-CONSOLE ]
    editbean = { [ use ATTRIBUTE-EDITOR ]
        layout:before = separator
        layout:width = 570
        layout:height = 480
    }

    actions = {
        ok = { [ use BUTTON ]
            res:label = base.console.ConsoleGeneric:standard.ok
            layout:before = cancel

            awx:services = action
            actionService = manager
            actionCommand = editOkPressed
        }

        apply = { [ use BUTTON ]
            res:label = base.console.ConsoleGeneric:standard.apply
            layout:before = cancel

            awx:services = action
            actionService = manager
            actionCommand = editApplyPressed
        }

        reset = { [ use BUTTON ]
            res:label = base.console.ConsoleGeneric:standard.reset
            layout:before = cancel

            awx:services = action
            actionService = manager
            actionCommand = editResetPressed
            res:enabled = false
        }

        cancel = {
            awx:services = action
            actionService = manager
            actionCommand = editCancelPressed
        }
    }
}

#
# Module loader
#
moduleloader = { [ inherit _editor ]
    res:title = base.console.ConsoleGeneric:modules.load.title

    editbean = {
        res:loadAsRequired = false
    }
 
    actions = {
        apply = {
            awx:createOnActivate = false
        }

        defaults = { [ use BUTTON ]
            res:label = base.console.ConsoleGeneric:modules.defaultSettings
            layout:before = reset

            awx:services = action
            actionService = manager
            actionCommand = editDefaultsPressed
        }
    }


    manager = { [ use SERVICE-MANAGER ]
        awx:bean = com.sun.symon.base.console.manager.CmModuleEditor

        awx:services = activate
        activateService = _self
        activateCommand = init

        res:dataSource = .services.client
        resType:dataSource = clientapi
        resMap:dataSource = setDataSource
        res:agentHost = %agentHost
        res:agentPort = %agentPort
        resType:agentPort = int
        res:moduleId = %moduleId

        res:editorBean = editbean
        resType:editorBean = beanobject
        resMap:editorBean = setEditorBean

        editedActions = ok apply reset
        editedService(ok) = actions.ok
        editedCommand(ok) = enable
        editedService(apply) = actions.apply
        editedCommand(apply) = enable
        editedService(reset) = actions.reset
        editedCommand(reset) = enable
        resetService = actions.reset
        resetCommand = disable
    }
}

#
# Module loader for meta data browser
#
taskMoudleLoader = { [ inherit moduleloader ]
    actions = {
        ok = {
            res:label = base.console.ConsoleGeneric:task.addSetting
        }
    }

    manager = {
        res:taskWindow = %taskWindow
        resType:taskWindow = beanobject
        resMap:taskWindow = addTaskOperationListener

        res:fromMDR = true
        resType:fromMDR = boolean
        resMap:fromMDR = setIsFromMDR
   }
}

#
# Module editor - same as above except for a single indicator
#
moduleeditor = { [ inherit moduleloader ]
    res:title = base.console.ConsoleGeneric:modules.edit.title

    manager = {
        res:editModSpec = %moduleSpec

        resetActions = ok apply reset
        resetService(ok) = actions.ok
        resetCommand(ok) = disable
        resetService(apply) = actions.apply
        resetCommand(apply) = disable
        resetService(reset) = actions.reset
        resetCommand(reset) = disable
    }

    actions = {
        ok = {
            res:enabled = false
        }
        apply = {
            res:enabled = false
        }
        defaults = {
            awx:createOnActivate = false
	}
    }

}

#
# Attribute editor
#
attributeeditor = { [ inherit _editor ]
    res:title = base.console.ConsoleGeneric:attedit.title

    row = { [ use LAYOUT-ROW ]
        layout:marginWidth = 10
        layout:marginHeight = 10
        layout:before = editbean
        layout:shrinkability = 0
        layout:stretchability = 0

        lblSrc = { [ use LABELLER ]
            res:label = base.console.ConsoleGeneric:editor.label
            layout:shrinkability = 0
            layout:stretchability = 0

            data = { [ use LABEL ]
                res:label = %objectName
                res:foreground = black
            }
        }

        pathSrc = { [ use LABELLER ]
            res:label = base.console.ConsoleGeneric:editor.location
            res:alignThrough = lblSrc
            layout:shrinkability = 0
            layout:stretchability = 0

            data = { [ use LABEL ]
                res:label = %objectPath
                res:foreground = black
            }
        }
    }

    editbean = {
        res:dataSource = .services.client
        res:editObject = %objectUrl
        res:loadAsRequired = true

        res:forColumn = %forColumn
        resType:forColumn = boolean
        resMap:forColumn = setForColumn
    }

    manager = { [ use SERVICE-MANAGER ]
        awx:bean = com.sun.symon.base.console.manager.CmAttributeEditor

        res:editorBean = editbean
        resType:editorBean = beanobject
        resMap:editorBean = setEditorBean

        editedActions = ok apply reset
        editedService(ok) = actions.ok
        editedCommand(ok) = enable
        editedService(apply) = actions.apply
        editedCommand(apply) = enable
        editedService(reset) = actions.reset
        editedCommand(reset) = enable

        resetActions = ok apply reset
        resetService(ok) = actions.ok
        resetCommand(ok) = disable
        resetService(apply) = actions.apply
        resetCommand(apply) = disable
        resetService(reset) = actions.reset
        resetCommand(reset)= disable

        awx:services = activate
        activateService = _self
        activateCommand = reset
    }

    actions = {
        ok = {
            res:enabled = false
        }

        apply = {
            res:enabled = false
        }

        reset = {
            res:enabled = false
        }

        help = { [ use BUTTON ]
            res:label = base.console.ConsoleGeneric:standard.help

            awx:services = action 
            actionService = .helpmanager
            actionCommand = init attribute-editor-help
        }

    }
}
#
# Alarm Action
#
alarmaction = { [ inherit attributeeditor ]
    res:title = base.console.ConsoleGeneric:alarmaction.title
}

meta-attribute = { [ inherit attributeeditor ]

    editbean = {
	res:lister = %taskWindow
	resType:lister = beanobject
	resMap:lister = setTaskWindow

    }

    actions = {
	ok = {
	    res:label = base.console.ConsoleGeneric:task.addSetting
	    awx:services = action
	    actionService = manager
	    actionCommand = addSettingToTask
	}
	apply = {
	    awx:createOnActivate = false
	    res:visible = false
	}
    }
}

rowadder = { [ inherit _editor ]
    res:title = base.console.ConsoleGeneric:rowadder
 
    editbean = {
        res:loadAsRequired = false
    }
 
    manager = { [ use SERVICE-MANAGER ]
        awx:bean = com.sun.symon.base.console.manager.CmTableRowEditor
 
        awx:services = activate
        activateService = _self
        activateCommand = init

        res:dataSource = .services.client
        resType:dataSource = clientapi
        resMap:dataSource = setDataSource

        res:editObject = %objectUrl
        resMap:editObject = setManagedObjectURL
 
        res:editorBean = editbean
        resType:editorBean = beanobject
        resMap:editorBean = setEditorBean
 
        res:mode = add
        resType:mode = string
        resMap:mode = setMode

        editedActions = ok apply reset
        editedService(ok) = actions.ok
        editedCommand(ok) = enable
        editedService(apply) = actions.apply
        editedCommand(apply) = enable
        editedService(reset) = actions.reset
        editedCommand(reset) = enable
        resetService = actions.reset
        resetCommand = disable
    }
}

roweditor = { [ inherit rowadder ]
    res:title = base.console.ConsoleGeneric:roweditor
 
    manager = { [ use SERVICE-MANAGER ]
        res:mode = edit
    }
}


