#!/bin/sh
#
#  @(#)hwds-setup.sh	1.17 02/09/19
#
#  Copyright (c) 09/19/02 Sun Microsystems, Inc.  All Rights Reserved
#
#  @version 1.17 02/09/19 10:45:32
#

PATH=/usr/bin:/usr/sbin
NEWLINE="\n"
TAB="\t"
OPEN="("
CLOSE=")"
QUOTE="\""



#######################################
## Get IP Address or Nodename Function
#######################################
get_ip_address_or_nodename() {

    node=`uname -n`
    Ping="/usr/sbin/ping"
    if [ -x $Ping ] ; then
    	pout=`$Ping -s ''$node'' 1 1 2>&1|awk '/([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*)/ \
        { m=index($0,"(")+1; n=index($0,")")-m; print substr($0,m,n) }'`
    else
        pout=
    fi
    #
    # If ping fails or does not exist, then use the host name instead of its IP
    # address.
    if [ "x$pout" = "x" ] ; then
        pout=$node
    fi
}

#####################################
## Check Online Help server location
#####################################
check_help_loc() {

    help_cfg_file=${BASEDIR}/SUNWsymon/classes/base/console/cfg/help-server-j.x
    loc=`grep "detail-help" $help_cfg_file | awk -F= '{print $2}' | grep "http://"`

    if [ -n "$loc" ]; then
        # This is a URL for the server.
        help_loc=$loc
    else
        # This must be a local help server.
        help_loc=""
    fi

    return 0
}

#####################################
## Prompt for user response function
#####################################
ask_user() {

    answer=""
    Y=`gettext "Y"`
    y=`gettext "y"`
    N=`gettext "N"`
    n=`gettext "n"`
    Q=`gettext "Q"`
    q=`gettext "q"`
    while [ -z "$answer" ]
    do
    echo " "`gettext "[y/n/q] "`"\c"
    read reply
    case $reply in
        "$y" | "$Y" )
            answer=1
            return
            ;;
        "$n" | "$N" )
            answer=0
            return
            ;;
        "$q" | "$Q" )
            echo ""
            echo `gettext "Exiting at user request."`
            echo ""
            exit 2
            ;;
        *)
            echo ""
            eval echo "\"`gettext 'Error: You must answer ${OPEN}${Y}, ${y}${CLOSE}, '\
'${OPEN}${N}, ${n}${CLOSE} or ${OPEN}${Q}, ${q}${CLOSE}'`\""
            echo ""
            ;;
        esac
    done

}


###########################################################################
#
# Main Entry Point
#
###########################################################################
#
# Set the locale for I18N/L10N
# ----------------------------
TEXTDOMAIN="SUNW_HWDIAG"
TEXTDOMAINDIR="/var/opt/SUNWsymon/locale"
export TEXTDOMAIN TEXTDOMAINDIR
#
# Check for HWDS packages
# -----------------------
BASEDIR=
pkginfo -q SUNWed
if [ $? -eq 0 ]; then
    SERVER=1
    BASEDIR=`pkginfo -r SUNWed`
else
    SERVER=0
fi

pkginfo -q SUNWedag
if [ $? -eq 0 ]; then
    AGENT=1
    if [ -z "$BASEDIR" ]; then
        BASEDIR=`pkginfo -r SUNWedag`
    fi
else
    AGENT=0
fi

pkginfo -q SUNWedh
if [ $? -eq 0 ]; then
    HELP=1
    if [ -z "$BASEDIR" ]; then
        BASEDIR=`pkginfo -r SUNWedh`
    fi
else
    HELP=0
fi

if [ -z "$BASEDIR" ]; then
    # No need for setup.
    exit 0
fi
#
# Define variables
# ----------------
ProductName=`gettext "Advanced System Monitoring"`
SunMC=`gettext "Sun Management Center"`
SOURCE_CFG="${BASEDIR}/SUNWsymon/addons/AdvancedMonitoring/lib/cfg_template/hd-console-host-apps.cfg"
TARGET_CFG="/var/opt/SUNWsymon/cfg/console-host-apps.cfg"
TMPFILE=/tmp/$$hwdiagcfg
symon_sbin_file="$BASEDIR/SUNWsymon/sbin/es-apps"
OS=`uname -r`

#
#
echo ""
eval echo "\"`gettext 'Starting ${ProductName} setup'`\""
#
# Check if the required configd program is installed
# --------------------------------------------------
if [ "$AGENT" -eq 1 ] && [ "$OS" = "5.5.1" -o "$OS" = "5.6" ]; then
    ## Bring in Configd check functions
    . `dirname $0`/configd-check.sh

    configd_check
    if [ $? -ne 0 ]; then
        echo ""
        eval echo "\"`gettext 'IMPORTANT: You MUST HAVE the correct config reader program '\
'installed for ${ProductName}. Some of the ${ProductName} components will not function properly if '\
'you do not install a ${SunMC} config reader for your platform. You can refer to the '\
'INSTALL_README.HWDS file for more detail about the config reader addon for your platform.'`\""
        echo ""
        eval echo "\"`gettext 'Do you want to continue with the setup procedure of ${ProductName}?'`\c\""
        ask_user
        if [ $answer -eq 0 ]; then
            eval echo "\"`gettext 'Exiting the ${ProductName} setup procedure ...'`\""
            echo ""
            exit 1
        else
            echo ""
            eval echo "\"`gettext 'WARNING: You have choosen to continue with the setup '\
'procedure of ${ProductName}. Please, make sure that you install the correct config '\
'reader addon for your platform before using ${ProductName}.'`\""
            echo ""
            echo `gettext "Are you sure you want to continue with the setup procedure?"`"\c"
            ask_user
            if [ $answer -ne 1 ]; then
                eval echo "\"`gettext 'Exiting the ${ProductName} setup procedure ...'`\""
                echo ""
                exit 1
            fi
        fi
    fi

fi

if [ "$SERVER" -eq 1 ]; then
    #
    # Adding HWDS to SunMC configuration
    # ----------------------------------
    if [ -f "$TARGET_CFG" ]; then
    	# Assume that the string 'entdiag' is unique in the file. 
    	# Remove any previous setup/removal leftover in case of error.
    	eval echo "\"`gettext 'Removing previous configuration entries from:${NEWLINE} ${TARGET_CFG} ...'`\""
    	sed '/entdiag/d' $TARGET_CFG > $TMPFILE || exit 1
    	mv $TMPFILE $TARGET_CFG || exit 1
    	#
    	# Now add new HWDS entry
    	eval echo "\"`gettext 'Appending new configuration entries to:${NEWLINE} ${TARGET_CFG} ...'`\""
    	get_ip_address_or_nodename
    	sed s/'ED_SYMON_SERVERNAME'/''$pout''/g $SOURCE_CFG > $TMPFILE || exit 1
    	sed "s|/opt/SUNWsymon/addons/AdvancedMonitoring|$BASEDIR/SUNWsymon/addons/AdvancedMonitoring|" $TMPFILE >> $TARGET_CFG || exit 1
        rm -f $TMPFILE || exit 1
    else
        eval echo "\"`gettext 'Creating ${TARGET_CFG} ...'`\""
        get_ip_address_or_nodename
        sed s/'ED_SYMON_SERVERNAME'/''$pout''/g $SOURCE_CFG > $TMPFILE || exit 1
        sed "s|/opt/SUNWsymon/addons/AdvancedMonitoring|$BASEDIR/SUNWsymon/addons/AdvancedMonitoring|" $TMPFILE > $TARGET_CFG || exit 1
        rm -f $TMPFILE || exit 1
    fi
fi
#
# Setup Help package
# ------------------
if [ "$HELP" -eq 1 ] && [ "$SERVER" -eq 1 ]; then
    install_log_dir=/var/opt/SUNWsymon/install
    install_logfile=$install_log_dir/hwdiag_install.log
    # Check if the hwdiag_install.log file exist. Remove the doc root link 
    # and remove the log.
    if [ -f "$install_logfile" ]; then
        hwdiag_link=`egrep DocRoot $install_logfile | awk -F'=' '{print $2}'`
        if [ -d "$hwdiag_link" ]; then
                # Removing the hwdiag link to SunMC DocRoot
                rm -rf $hwdiag_link
        fi
        # Removing the install log file
        rm -rf $install_logfile
    fi   
    # Checking for SunMC help installation location (local or URL)
    check_help_loc

    if [ -n "$help_loc" ]; then
        default_docroot=$BASEDIR/SUNWsymon/lib/locale
        echo ""
        eval echo "\"`gettext 'Searching for ${SunMC} Help Server ...'`\""
        eval echo "\"`gettext 'The Sun Management Center help documentation '\
'has been installed on the following URL:${QUOTE}${help_loc}${QUOTE}.${NEWLINE}${NEWLINE}'\
'If you want the ${ProductName} Online Help documentation to be configured '\
'with the above http-accessible location, you will need to specify the '\
'Document Root location for this ${SunMC} Help Server. This information is '\
'stored in the ${QUOTE}httpd.conf${QUOTE} file of your web server under '\
'${QUOTE}doc_root${QUOTE} varible for a Sun WebServer and '\
'${QUOTE}DocumentRoot${QUOTE} variable for an Apache Server.${NEWLINE}'`\""

        eval echo "\"`gettext 'Please indicate the Document Root location for '\
'${SunMC} Help Server, or accept the default value [${default_docroot}] :'` \c\""

        read user_answer
		
        if [ -z "$user_answer" ]; then
            eval echo "\"`gettext 'Using the default Document Root location: ${default_docroot}'`\""
            user_answer=${default_docroot}
        fi
        while [ ! -d "$user_answer" ]
        do
            echo ""
            echo `gettext "ERROR: Not valid Document Root location. Please make "\
"sure that you have entered a valid directory path."` "\n"

            eval echo "\"`gettext 'Please indicate the Document Root location '\
'for ${SunMC} Help Server:'` \c\""
			
            read user_answer
        done
				
        hwdiag_help=${BASEDIR}/SUNWsymon/addons/AdvancedMonitoring/help
		
        if [ -d "$user_answer/hwdiag" ]; then
            # Remove the old link
            rm -rf $user_answer/hwdiag
        fi

        # Creating hwdiag link to Document Root directory.
        ln -s $hwdiag_help $user_answer/hwdiag || exit 1

        # Save the location of the DocRoot, so it can be removed at pkgrm time
        if [ ! -d "$install_log_dir" ]; then
            mkdir -p $install_log_dir || exit 1
        fi
        echo "DocRoot=$user_answer/hwdiag" > $install_logfile

        old_string=`grep AdvancedMonitoring $TARGET_CFG | awk -F: '{print $2}'`
        if [ -z "$old_string" ]; then
            eval echo "\"`gettext 'ERROR: Could not configure ${ProductName} Online Help. '\
'You might need to reinstall ${ProductName}.'`\""
        fi

        new_string=$help_loc/hwdiag/hwdshelp.html

        # Modifying console-host-apps.cfg with new URL information
        sed "s|$old_string|$new_string|" $TARGET_CFG > /tmp/$$hwdshelp || exit 1
        mv /tmp/$$hwdshelp $TARGET_CFG || exit 1
        rm -f /tmp/$$hwdshelp		
    fi
fi
  
#
# Executing SunMC es-apps script
# ------------------------------
if [ "$SERVER" -eq 1 ]; then
    if [ -x "$symon_sbin_file" ]; then
    	echo ""
        eval echo "\"`gettext 'Add ${ProductName} as ${SunMC} application ...'`\""
        $symon_sbin_file
        if [ $? -ne 0 ]; then
            echo ""
            eval echo "\"`gettext 'ERROR: The execution of ${SunMC} ${symon_sbin_file} '\
'script was not successful. ${ProductName} will not function correctly '\
'without the execution of this script.'`\""
            echo ""
            exit 1
        fi
    else
        echo ""
        eval echo "\"`gettext 'ERROR: The ${SunMC} ${symon_sbin_file} script was not '\
'found. ${ProductName} will not function correctly without the execution '\
'of this script.'`\""
        echo ""
        exit 1
    fi
fi

#
# Create /var/opt/SUNWhwdiag/logs directory
# ----------------------------------------
if [ ! -d "/var/opt/SUNWhwdiag" ]; then
    mkdir -m 755 /var/opt/SUNWhwdiag
else
    chmod 755 /var/opt/SUNWhwdiag
fi

if [ ! -d "/var/opt/SUNWhwdiag/logs" ]; then
    mkdir -m 755 /var/opt/SUNWhwdiag/logs
else
    chmod 755 /var/opt/SUNWhwdiag/logs
fi

echo ""
eval echo "\"`gettext 'Finished with ${ProductName} setup'`\""
echo ""

exit 0
