/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.deployment.DeploymentDescriptor;
import oracle.aurora.AuroraServices.ActivatableObject;
import oracle.aurora.AuroraServices.ArgsHolder;
import oracle.aurora.AuroraServices.EJBGenerationError;
import oracle.aurora.AuroraServices._DeployEJBImplBase;
import oracle.aurora.AuroraServices.schemaIdsHolder;
import oracle.aurora.ejb.deployment.server.BeanGenerator;
import oracle.aurora.ejb.deployment.server.GenerationErrors;
import oracle.aurora.rdbms.ObjectInputStreamWithResolver;
import oracle.aurora.rdbms.Schema;
import oracle.jdbc.driver.OracleDriver;
import org.omg.CORBA.Object;

public class DeployEjbImpl
extends _DeployEJBImplBase
implements ActivatableObject {
    public Object _initializeAuroraObject() {
        return this;
    }

    private void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    private void close(Statement s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (SQLException sQLException) {}
    }

    private DeploymentDescriptor descriptor(byte[] serializedDescriptor) throws EJBGenerationError {
        ByteArrayInputStream input = new ByteArrayInputStream(serializedDescriptor);
        try {
            return (DeploymentDescriptor)new ObjectInputStreamWithResolver((InputStream)input).readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            GenerationErrors.fail1("IOEXCEPTION_DESERIALIZING", e.getMessage());
        }
        catch (ClassNotFoundException e) {
            GenerationErrors.fail1("CLASS_NOT_FOUND_DESERIALIZING", e.getMessage());
        }
        catch (Exception e) {
            GenerationErrors.fail1("UNEXPECTED_EXCEPTION_DESERIALIZING", e.getMessage());
        }
        return null;
    }

    public void generate(ArgsHolder publish_info, byte[] descriptor) throws EJBGenerationError {
        publish_info.value = new BeanGenerator(this.descriptor(descriptor), Schema.currentSchema()).generate();
    }

    private Connection getConnection() {
        try {
            return new OracleDriver().defaultConnection();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void translateUsers(schemaIdsHolder ownerNumbers, String[] userNames) {
        Connection conn = this.getConnection();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int[] ids = new int[userNames.length];
        try {
            try {
                pstmt = conn.prepareStatement("select id from all_ids where name = :1");
                int i = 0;
                while (i < ids.length) {
                    if (userNames[i].equals("PUBLIC")) {
                        ids[i] = 1;
                    } else {
                        pstmt.setString(1, userNames[i]);
                        pstmt.execute();
                        rs = pstmt.getResultSet();
                        ids[i] = rs.next() ? rs.getInt(1) : -1;
                        this.close(rs);
                    }
                    ++i;
                }
                ownerNumbers.value = ids;
            }
            finally {
                java.lang.Object var8_8 = null;
                this.close(pstmt);
                this.close(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ownerNumbers.value = ids;
    }
}

