/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.lookup;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.mgmtservice.framework.MSRemoteServiceFactory;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.lookup.SlServiceListener;
import com.sun.symon.base.server.lookup.SlServicePinger;
import com.sun.symon.base.server.lookup.SlServiceRegistry;
import com.sun.symon.base.server.receptors.rmi.SrRMISessionService;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SlLookupService {
    private static Hashtable serviceTable;
    private static Hashtable sessionTable;
    private static Hashtable factoryTable;
    private static Hashtable sessionIdMapper;
    private static SlServiceListener listener;
    private static SlServiceRegistry registry;
    private static SlServicePinger pinger;
    private static SlLookupService lookupServer;
    private static int listenPort;
    private static int DEFLISTENPORT;
    private static int DEFPINGINTERVAL;
    private static int pingInterval;
    private static int currentSessionId;

    static {
        listenPort = 0;
        DEFLISTENPORT = 5600;
        DEFPINGINTERVAL = 120;
        pingInterval = 0;
        currentSessionId = 0;
    }

    private SlLookupService(UcBeanIntrospector ucBeanIntrospector) throws SMAPIException {
        serviceTable = new Hashtable();
        sessionTable = new Hashtable();
        factoryTable = new Hashtable();
        sessionIdMapper = new Hashtable();
        currentSessionId = 0;
        listenPort = DEFLISTENPORT;
        pingInterval = DEFPINGINTERVAL;
        try {
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("SlLookupService(): " + exception.getMessage()));
        }
        try {
            registry = new SlRegistry(this);
            listener = new SlServiceListener(listenPort, registry);
            listener.start();
            pinger = new SlServicePinger(this, pingInterval);
            pinger.start();
        }
        catch (Exception exception) {
            listener = null;
            String string = "Error in starting lookup service: " + exception.getMessage();
            UcDDL.logErrorMessage((String)string);
            throw new SMAPIException(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    Vector getFactories() {
        var1_1 = SlLookupService.factoryTable.keys();
        var2_2 = new Vector<K>();
        if (var1_1 != null) ** GOTO lbl6
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var2_2.addElement(var1_1.nextElement());
lbl6:
            // 2 sources

            ** while (var1_1.hasMoreElements())
        }
lbl7:
        // 1 sources

        return var2_2;
    }

    public static void init(String string) throws ExceptionInInitializerError {
        if (lookupServer == null) {
            try {
                UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
                ucBeanIntrospector.readProperties(string);
                lookupServer = new SlLookupService(ucBeanIntrospector);
                UcDDL.logInfoMessage((String)"initiation: LookupService is up");
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    public static Boolean isLicenseAvailable(String string) throws SMAPIException {
        Vector vector = (Vector)serviceTable.get(string);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        return new Boolean(true);
    }

    public static String[] listServices() throws RemoteException {
        UcDDL.logInfoMessage((String)"Lookup Service: list all services");
        if (lookupServer == null) {
            UcDDL.logErrorMessage((String)"Lookup Service is not up");
            throw new RemoteException("Lookup Service is not up");
        }
        String[] stringArray = null;
        int n = serviceTable.size();
        stringArray = new String[n];
        if (n == 0) {
            UcDDL.logInfoMessage((String)"listServices: No Service Available");
            return stringArray;
        }
        Enumeration enumeration = serviceTable.keys();
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public static Object lookup(String string, String[] stringArray, SrRMISessionService srRMISessionService) throws RemoteException, SMNoSuchObjectException {
        UcDDL.logInfoMessage((String)("Lookup Service: for service " + string));
        if (lookupServer == null) {
            UcDDL.logErrorMessage((String)("Lookup Service is not up: service " + string));
            throw new RemoteException("Lookup Service is not up");
        }
        Vector vector = (Vector)serviceTable.get(string);
        if (vector == null || vector.size() == 0) {
            UcDDL.logInfoMessage((String)"Lookup: No Service Available");
            throw new SMNoSuchObjectException("Service not found: " + string);
        }
        MSRemoteServiceFactory mSRemoteServiceFactory = null;
        Remote remote = null;
        boolean bl = false;
        String string2 = null;
        int n = 0;
        while (n < vector.size()) {
            mSRemoteServiceFactory = (MSRemoteServiceFactory)vector.elementAt(n);
            if (mSRemoteServiceFactory != null) {
                ScSecurityCredential scSecurityCredential = srRMISessionService.getUserSecurityInfo();
                String string3 = SlLookupService.mapSession2Id(srRMISessionService);
                if (srRMISessionService.isAlternateHostAvailable()) {
                    string2 = srRMISessionService.getAlternateHost();
                }
                if ((remote = mSRemoteServiceFactory.getHandle(string, scSecurityCredential, string3, string2)) != null) {
                    Vector<MSRemoteServiceFactory> vector2 = (Vector<MSRemoteServiceFactory>)sessionTable.get(string3);
                    if (vector2 == null) {
                        vector2 = new Vector<MSRemoteServiceFactory>();
                        vector2.add(mSRemoteServiceFactory);
                        sessionTable.put(string3, vector2);
                    } else {
                        MSRemoteServiceFactory mSRemoteServiceFactory2 = null;
                        int n2 = 0;
                        n2 = 0;
                        while (n2 < vector2.size()) {
                            mSRemoteServiceFactory2 = (MSRemoteServiceFactory)vector2.elementAt(n2);
                            if (mSRemoteServiceFactory2 != null && mSRemoteServiceFactory2.equals(mSRemoteServiceFactory)) {
                                n2 = vector2.size() + 1;
                            }
                            ++n2;
                        }
                        if (n2 == vector2.size()) {
                            vector2.add(mSRemoteServiceFactory);
                        }
                    }
                    return remote;
                }
            }
            ++n;
        }
        UcDDL.logErrorMessage((String)"lookup: Error :Service not found");
        throw new SMNoSuchObjectException("Service not found: " + string);
    }

    private static synchronized String mapSession2Id(SrRMISessionService srRMISessionService) {
        String string = (String)sessionIdMapper.get(srRMISessionService);
        if (string == null) {
            string = new String(String.valueOf(++currentSessionId));
            sessionIdMapper.put(srRMISessionService, string);
        }
        return string;
    }

    public synchronized void register(String string, MSRemoteServiceFactory mSRemoteServiceFactory) {
        Vector<String> vector = (Vector<String>)serviceTable.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            vector.addElement((String)((Object)mSRemoteServiceFactory));
            serviceTable.put(string, vector);
            UcDDL.logInfoMessage((String)("SlLookupService(): register service " + string));
        } else {
            MSRemoteServiceFactory mSRemoteServiceFactory2 = (MSRemoteServiceFactory)vector.elementAt(0);
            if (mSRemoteServiceFactory2.equals(mSRemoteServiceFactory)) {
                return;
            }
            vector.setElementAt((String)((Object)mSRemoteServiceFactory), 0);
            UcDDL.logInfoMessage((String)("SlLookupService(): re-register service " + string));
        }
        vector = null;
        vector = (Vector<String>)factoryTable.get(mSRemoteServiceFactory);
        if (vector == null) {
            vector = new Vector<String>();
            factoryTable.put(mSRemoteServiceFactory, vector);
        }
        vector.addElement(string);
    }

    public static void removeSession(SrRMISessionService srRMISessionService) {
        String string = (String)sessionIdMapper.remove(srRMISessionService);
        if (string == null) {
            return;
        }
        Vector vector = (Vector)sessionTable.get(string);
        if (vector == null || vector.size() == 0) {
            return;
        }
        MSRemoteServiceFactory mSRemoteServiceFactory = null;
        int n = 0;
        while (n < vector.size()) {
            mSRemoteServiceFactory = (MSRemoteServiceFactory)vector.elementAt(n);
            if (mSRemoteServiceFactory != null) {
                try {
                    mSRemoteServiceFactory.removeSession(string);
                }
                catch (RemoteException remoteException) {}
            }
            ++n;
        }
        UcDDL.logInfoMessage((String)("SlLookupService(): remove session from " + vector.size() + " service factories."));
        sessionTable.remove(string);
    }

    public void setServicePingInterval(int n) {
        pingInterval = n;
    }

    public void setServiceRegistryPort(int n) {
        listenPort = n;
    }

    public synchronized void unregister(MSRemoteServiceFactory mSRemoteServiceFactory) {
        Vector vector = (Vector)factoryTable.remove(mSRemoteServiceFactory);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            this.unregister(string, mSRemoteServiceFactory);
            ++n;
        }
    }

    public synchronized void unregister(String string, MSRemoteServiceFactory mSRemoteServiceFactory) {
        Vector vector = (Vector)serviceTable.get(string);
        if (vector == null) {
            return;
        }
        MSRemoteServiceFactory mSRemoteServiceFactory2 = null;
        int n = 0;
        while (n < vector.size()) {
            mSRemoteServiceFactory2 = (MSRemoteServiceFactory)vector.elementAt(n);
            if (mSRemoteServiceFactory2.equals(mSRemoteServiceFactory)) {
                vector.remove(n);
                if (vector.size() == 0) {
                    serviceTable.remove(string);
                }
                UcDDL.logInfoMessage((String)("SlLookupService(): unregister service " + string));
                break;
            }
            ++n;
        }
        vector = (Vector)factoryTable.get(mSRemoteServiceFactory);
        if (vector == null || vector.size() < 2) {
            return;
        }
        int n2 = 1;
        while (n2 < vector.size()) {
            String string2 = (String)vector.elementAt(n2);
            if (string2.equals(string)) {
                vector.remove(n2);
                if (vector.size() == 0) {
                    factoryTable.remove(mSRemoteServiceFactory);
                }
                return;
            }
            ++n2;
        }
    }

    private class SlRegistry
    extends UnicastRemoteObject
    implements SlServiceRegistry {
        private SlLookupService lookupService;

        public SlRegistry(SlLookupService slLookupService2) throws RemoteException {
            this.lookupService = slLookupService2;
        }

        public void register(String string, MSRemoteServiceFactory mSRemoteServiceFactory) throws RemoteException {
            this.lookupService.register(string, mSRemoteServiceFactory);
        }

        public void register(String[] stringArray, MSRemoteServiceFactory mSRemoteServiceFactory) throws RemoteException {
            int n = 0;
            while (n < stringArray.length) {
                this.lookupService.register(stringArray[n], mSRemoteServiceFactory);
                ++n;
            }
        }

        public void unregister(String string, MSRemoteServiceFactory mSRemoteServiceFactory) throws RemoteException {
            this.lookupService.unregister(string, mSRemoteServiceFactory);
        }
    }
}

