/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.service;

import com.sun.symon.base.client.service.SMDBConcurrencyTimestamp;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMLengthException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;

public class SMDBObject
implements Serializable,
Cloneable {
    public static final int USER_LENGTH = 32;
    private SMDBObjectID id_;
    private SMDBConcurrencyTimestamp timestamp_;
    private String updatedBy_;
    private boolean changed_ = true;
    private Timestamp createdDate_;
    private Object security_;

    protected SMDBObject() {
    }

    public SMDBObject(SMDBObject sMDBObject) {
        if (sMDBObject != null) {
            this.id_ = sMDBObject.getObjectID();
            this.timestamp_ = sMDBObject.getTimestamp();
            this.updatedBy_ = sMDBObject.getUpdatedBy();
            this.createdDate_ = sMDBObject.getCreatedDate();
        }
    }

    public SMDBObject(SMDBObjectID sMDBObjectID) {
        this.id_ = sMDBObjectID;
    }

    public static String arrayToString(Object[] objectArray) {
        return SMDBObject.arrayToStringBuffer(objectArray, new StringBuffer()).toString();
    }

    public static StringBuffer arrayToStringBuffer(Object[] objectArray, StringBuffer stringBuffer) {
        stringBuffer.append("{");
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n]);
                if (n < objectArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer;
    }

    public static final String assertLength(String string, String string2, int n, boolean bl) throws SMLengthException {
        if (bl) {
            if (string2 == null) {
                throw new SMLengthException(String.valueOf(string) + " is null");
            }
            if (string2.length() == 0) {
                throw new SMLengthException(String.valueOf(string) + " is empty");
            }
        }
        if (string2 != null && string2.length() > n) {
            throw new SMLengthException(String.valueOf(string) + " is larger than " + n);
        }
        return string2;
    }

    public static final String[] assertLength(String string, String[] stringArray, int n) throws SMLengthException {
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                SMDBObject.assertLength(string, stringArray[n2], n, true);
                ++n2;
            }
        }
        return stringArray;
    }

    public static final Object assertNotNull(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(string) + " is null");
        }
        return object;
    }

    protected Object clone() {
        try {
            SMDBObject sMDBObject = (SMDBObject)super.clone();
            sMDBObject.id_ = null;
            this.setChanged(true);
            return sMDBObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(String.valueOf(String.valueOf(this.getClass())) + " is not Cloneable");
        }
    }

    public Timestamp getCreatedDate() {
        return this.createdDate_;
    }

    public String getDescription() {
        return "";
    }

    public String getName() {
        return "";
    }

    public SMDBObjectID getObjectID() {
        return this.id_;
    }

    public Object getSecurity() {
        return this.security_;
    }

    public SMDBConcurrencyTimestamp getTimestamp() {
        return this.timestamp_;
    }

    public String getUpdatedBy() {
        return this.updatedBy_;
    }

    public boolean isChanged() {
        return this.changed_;
    }

    public static String readString(ObjectInputStream objectInputStream) throws IOException {
        if (objectInputStream.readBoolean()) {
            return objectInputStream.readUTF();
        }
        return null;
    }

    public void refresh(SMDBObject sMDBObject) {
        try {
            this.setObjectID(sMDBObject.getObjectID());
            this.setUpdatedBy(sMDBObject.getUpdatedBy());
            this.setTimestamp(sMDBObject.getTimestamp());
            this.setCreatedDate(sMDBObject.getCreatedDate());
            this.setChanged(false);
        }
        catch (SMLengthException sMLengthException) {}
    }

    public void setChanged(boolean bl) {
        this.changed_ = bl;
    }

    public void setCreatedDate(Timestamp timestamp) {
        this.createdDate_ = timestamp;
    }

    public void setObjectID(SMDBObjectID sMDBObjectID) {
        this.id_ = sMDBObjectID;
    }

    public void setSecurity(Object object) {
        this.security_ = object;
    }

    public void setTimestamp(SMDBConcurrencyTimestamp sMDBConcurrencyTimestamp) {
        this.timestamp_ = sMDBConcurrencyTimestamp;
    }

    public void setUpdatedBy(String string) throws SMLengthException {
        if (string != null && string.length() > 32) {
            throw new SMLengthException();
        }
        this.updatedBy_ = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ID=").append(this.id_);
        stringBuffer.append(", CHANGED=").append(this.isChanged());
        stringBuffer.append(", UPDATED_BY=").append(this.getUpdatedBy());
        stringBuffer.append(", TIMESTAMP=").append(this.getTimestamp());
        stringBuffer.append(", CREATED_DATE=").append(this.getCreatedDate());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static void writeString(ObjectOutputStream objectOutputStream, String string) throws IOException {
        if (string != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(string);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }
}

