/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.objectgroup;

import com.sun.symon.base.client.config.SMPlatformName;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMIPRangeCriteria;
import com.sun.symon.base.client.group.SMModuleCriteria;
import com.sun.symon.base.client.group.SMNameCriteria;
import com.sun.symon.base.client.group.SMOSCriteria;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.group.SMPlatformCriteria;
import com.sun.symon.base.console.grouping.CgUtil;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class CgOGInfoPane
extends JPanel {
    JLabel fltName;
    JLabel desc;
    JLabel hostName;
    JLabel plat;
    JLabel oper;
    JLabel module;
    JLabel ipFrom;
    JLabel ipTo;
    JLabel groupName;
    JLabel domainName;
    JList selObjLst;
    DefaultListModel selObjsLstModel;
    JLabel[] infoItems;
    boolean bOnlyShowFilter = false;

    public CgOGInfoPane() {
        this(true);
    }

    public CgOGInfoPane(boolean bl) {
        this.bOnlyShowFilter = bl;
        this.createGUI();
    }

    void createGUI() {
        Serializable serializable;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(0, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel[] jLabelArray = new JLabel[]{null, null, null, new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.filterName")), new JLabel(CgUtil.getI18nMsg((String)"ogMgr.descLbl")), new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.hostName")), new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.platForm")), new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.os")), new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.modules")), new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.ipStart")), new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.ipStop"))};
        this.infoItems = jLabelArray;
        this.fltName = new JLabel(" ");
        this.desc = new JLabel(" ");
        this.hostName = new JLabel(" ");
        this.plat = new JLabel(" ");
        this.oper = new JLabel(" ");
        this.module = new JLabel(" ");
        this.ipFrom = new JLabel(" ");
        this.ipTo = new JLabel(" ");
        Component[] componentArray = new Component[]{null, null, null, this.fltName, this.desc, this.hostName, this.plat, this.oper, this.module, this.ipFrom, this.ipTo};
        Font font = this.fltName.getFont();
        font = font.deriveFont(0);
        if (!this.bOnlyShowFilter) {
            this.infoItems[0] = new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.groupName"));
            this.infoItems[1] = new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.domainName"));
            this.infoItems[2] = new JLabel(CgUtil.getI18nMsg((String)"rqstMgr.objects"));
            this.infoItems[4] = null;
            this.groupName = new JLabel(" ");
            this.domainName = new JLabel(" ");
            this.selObjsLstModel = new DefaultListModel();
            this.selObjLst = new JList(this.selObjsLstModel);
            this.selObjLst.setVisibleRowCount(2);
            Color color = this.getBackground();
            this.selObjLst.setSelectionBackground(color);
            this.selObjLst.setBackground(color);
            serializable = new JScrollPane(this.selObjLst);
            componentArray[0] = this.groupName;
            componentArray[1] = this.domainName;
            componentArray[2] = serializable;
            componentArray[4] = null;
        }
        int n = 0;
        if (this.bOnlyShowFilter) {
            n = 3;
        }
        serializable = new Insets(0, 0, 0, 5);
        Insets insets = new Insets(0, 0, 0, 10);
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.infoItems.length) {
            if (this.infoItems[n3] != null) {
                gridBagConstraints.gridy = ++n2;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.anchor = 12;
                gridBagConstraints.insets = serializable;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                this.add((Component)this.infoItems[n3], gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = insets;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                componentArray[n3].setForeground(Color.black);
                componentArray[n3].setFont(font);
                this.add(componentArray[n3], gridBagConstraints);
            }
            ++n3;
        }
    }

    public void fillCriteria(SMFilterData sMFilterData) {
        SMFilterCriteria[] sMFilterCriteriaArray = sMFilterData.getFilterCriteria();
        if (sMFilterCriteriaArray == null) {
            return;
        }
        int n = 0;
        while (n < sMFilterCriteriaArray.length) {
            int n2;
            Object object;
            String string;
            if (sMFilterCriteriaArray[n] instanceof SMNameCriteria) {
                string = ((SMNameCriteria)sMFilterCriteriaArray[n]).getMatchType();
                object = "Exact Match";
                if (string.equals("C")) {
                    object = "Contains";
                } else if (string.equals("S")) {
                    object = "Starts With";
                } else if (string.equals("E")) {
                    object = "Ends With";
                }
                this.hostName.setText(String.valueOf(object) + " " + ((SMNameCriteria)sMFilterCriteriaArray[n]).getPattern());
            } else if (sMFilterCriteriaArray[n] instanceof SMPlatformCriteria) {
                string = "";
                string = ((SMPlatformCriteria)sMFilterCriteriaArray[n]).isInclude() ? "Include" : "Exclude";
                object = ((SMPlatformCriteria)sMFilterCriteriaArray[n]).getList();
                if (object != null) {
                    string = String.valueOf(string) + " ";
                    n2 = 0;
                    while (n2 < ((String[])object).length) {
                        string = String.valueOf(string) + SMPlatformName.makeDisplayName((String)object[n2]);
                        if (n2 != ((String[])object).length - 1) {
                            string = String.valueOf(string) + ",";
                        }
                        ++n2;
                    }
                }
                this.plat.setText(string);
            } else if (sMFilterCriteriaArray[n] instanceof SMOSCriteria) {
                string = "";
                string = ((SMOSCriteria)sMFilterCriteriaArray[n]).isInclude() ? "Include" : "Exclude";
                object = ((SMOSCriteria)sMFilterCriteriaArray[n]).getList();
                if (object != null) {
                    string = String.valueOf(string) + " ";
                    n2 = 0;
                    while (n2 < ((String[])object).length) {
                        string = String.valueOf(string) + object[n2];
                        if (n2 != ((String[])object).length - 1) {
                            string = String.valueOf(string) + ",";
                        }
                        ++n2;
                    }
                }
                this.oper.setText(string);
            } else if (sMFilterCriteriaArray[n] instanceof SMModuleCriteria) {
                string = "";
                string = ((SMModuleCriteria)sMFilterCriteriaArray[n]).isInclude() ? "Include" : "Exclude";
                object = ((SMModuleCriteria)sMFilterCriteriaArray[n]).getList();
                if (object != null) {
                    string = String.valueOf(string) + " ";
                    n2 = 0;
                    while (n2 < ((String[])object).length) {
                        string = String.valueOf(string) + object[n2];
                        if (n2 != ((String[])object).length - 1) {
                            string = String.valueOf(string) + ",";
                        }
                        ++n2;
                    }
                }
                this.module.setText(string);
            } else if (sMFilterCriteriaArray[n] instanceof SMIPRangeCriteria) {
                this.ipFrom.setText(((SMIPRangeCriteria)sMFilterCriteriaArray[n]).getFromAddress());
                this.ipTo.setText(((SMIPRangeCriteria)sMFilterCriteriaArray[n]).getToAddress());
            }
            ++n;
        }
    }

    public void setFilter(SMFilterData sMFilterData) {
        this.fltName.setText("");
        this.desc.setText("");
        this.hostName.setText("");
        this.plat.setText("");
        this.oper.setText("");
        this.module.setText("");
        this.ipFrom.setText("");
        this.ipTo.setText("");
        boolean bl = sMFilterData != null;
        int n = 3;
        while (n < this.infoItems.length) {
            if (this.infoItems[n] != null) {
                this.infoItems[n].setEnabled(bl);
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        this.fltName.setText(sMFilterData.getName());
        this.desc.setText(sMFilterData.getDescription());
        this.fillCriteria(sMFilterData);
    }

    public void setObjectGroupInfo(SMObjectGroupData sMObjectGroupData) {
        if (this.bOnlyShowFilter) {
            return;
        }
        boolean bl = sMObjectGroupData != null;
        int n = 0;
        while (n < 3) {
            this.infoItems[n].setEnabled(bl);
            ++n;
        }
        this.selObjLst.setEnabled(bl);
        if (bl) {
            String string = UcInternationalizer.translateKey((String)sMObjectGroupData.getDomain());
            this.groupName.setText(sMObjectGroupData.getName());
            this.domainName.setText(string);
            this.selObjsLstModel.removeAllElements();
            if (sMObjectGroupData.isAllObjectsInDomain()) {
                String string2 = String.valueOf(CgUtil.getI18nMsg((String)"rqstMgr.allObject")) + " " + string;
                this.selObjsLstModel.addElement(string2);
            } else {
                String[] stringArray = sMObjectGroupData.getObjects();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string3 = stringArray[n2];
                        this.selObjsLstModel.addElement(string3);
                        ++n2;
                    }
                }
            }
        } else {
            this.domainName.setText(" ");
            this.groupName.setText(" ");
            this.selObjsLstModel.removeAllElements();
            this.selObjsLstModel.addElement(" ");
        }
    }
}

