/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.filter;

import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CgFilterSubPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JCheckBox titleCheckBox;
    private JRadioButton include;
    private JRadioButton exclude;
    private JComboBox type;
    private JButton delete;
    private JList list = new JList(new DefaultListModel());
    private String title;

    public CgFilterSubPanel(String string, boolean bl) {
        this.title = string;
        this.include = new JRadioButton(this.translate("include"), true);
        this.exclude = new JRadioButton(this.translate("exclude"), false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.include);
        buttonGroup.add(this.exclude);
        this.delete = new JButton(this.translate("delete"));
        this.titleCheckBox = new JCheckBox(string);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.titleCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.include, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.exclude, gridBagConstraints);
        this.type = new JComboBox();
        this.type.setPreferredSize(new Dimension(220, 25));
        this.type.setMaximumRowCount(4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.type, gridBagConstraints);
        this.list.setBackground(UcCommon.getLightGrayColor());
        this.list.setFixedCellWidth(180);
        this.list.setFixedCellHeight(15);
        this.list.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.list, 22, 30);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.fill = 2;
        this.delete = new JButton(this.translate("delete"));
        jPanel.add((Component)this.delete, gridBagConstraints);
        this.add(jPanel);
        this.titleCheckBox.addActionListener(this);
        this.delete.addActionListener(this);
        this.list.addListSelectionListener(this);
        this.type.addActionListener(this);
        this.setStatus(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.titleCheckBox) {
            this.checkBoxActivated();
        } else if (object == this.delete) {
            this.deleteActivated();
        } else if (object == this.type) {
            this.typeActivated();
        } else if (object == this.list) {
            this.listActivated();
        }
    }

    public void checkBoxActivated() {
        this.setStatus(this.titleCheckBox.isSelected());
    }

    public void deleteActivated() {
        int[] nArray = this.list.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        int n = 0;
        while (n < nArray.length) {
            defaultListModel.removeElementAt(nArray[n]);
            ++n;
        }
        this.delete.setEnabled(false);
    }

    public boolean getCheckBoxSelected() {
        return this.titleCheckBox.isSelected();
    }

    public boolean getExcludeSelected() {
        return this.exclude.isSelected();
    }

    public boolean getIncludeSelected() {
        return this.include.isSelected();
    }

    public JList getList() {
        return this.list;
    }

    public void listActivated() {
        if (this.list.getSelectedIndex() != -1) {
            this.delete.setEnabled(true);
        } else {
            this.delete.setEnabled(false);
        }
    }

    public void setCheckBoxSelected(boolean bl) {
        this.titleCheckBox.setSelected(bl);
    }

    public void setExcludeSelected() {
        this.exclude.doClick();
    }

    public void setIncludeSelected() {
        this.include.doClick();
    }

    public void setList(Object[] objectArray) {
        this.list.setListData(objectArray);
    }

    public void setStatus(boolean bl) {
        this.titleCheckBox.setSelected(bl);
        this.include.setEnabled(bl);
        this.exclude.setEnabled(bl);
        this.type.setEnabled(bl);
        if (!bl) {
            this.delete.setEnabled(bl);
        }
        this.list.setEnabled(bl);
        this.setIncludeSelected();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        defaultListModel.clear();
    }

    public void setTypeList(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.type.addItem(objectArray[n]);
            ++n;
        }
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.grouping.filter.CgFilterBundle:" + string));
    }

    public void typeActivated() {
        Object object = this.type.getSelectedItem();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        if (!defaultListModel.contains(object)) {
            defaultListModel.addElement(object);
            this.list.setModel(defaultListModel);
            if (this.list.isShowing()) {
                this.list.revalidate();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.list) {
            this.listActivated();
        }
    }
}

