/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.process.console;

import com.sun.symon.apps.process.console.Coordinate;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class Graph
extends Canvas {
    final int MARGIN = 20;
    final int MAX_COORDS_SIZE = 86400;
    Vector coords = new Vector();
    int xMax;
    int xMin;
    int yMax;
    int yMin;
    Color color;
    int numCoords = 0;
    double xScale;
    double yScale;
    int graphWidth;
    int graphHeight;
    Rectangle view = new Rectangle(0, 0, 100, 1000);

    public void addCoordinate(Coordinate coordinate) {
        if (this.numCoords >= 86400) {
            Coordinate coordinate2 = (Coordinate)this.coords.firstElement();
            this.xMin = coordinate2.x;
            this.coords.removeElement(coordinate2);
        }
        this.coords.addElement(coordinate);
        if (coordinate.x > this.xMax) {
            this.xMax = coordinate.x;
        }
        if (coordinate.x < this.xMin) {
            this.xMin = coordinate.x;
        }
        if (coordinate.y > this.yMax) {
            this.yMax = coordinate.y;
        }
        if (coordinate.y < this.yMin) {
            this.yMin = coordinate.y;
        }
        ++this.numCoords;
        this.linePlot(this.getGraphics(), coordinate);
    }

    void computeScales() {
        this.graphWidth = this.getSize().width - 40;
        this.graphHeight = this.getSize().height - 40;
        this.xScale = this.xMax - this.xMin != 0 ? (double)this.graphWidth / (double)(this.xMax - this.xMin) : 1.0;
        this.yScale = this.yMax - this.yMin != 0 ? (double)this.graphHeight / (double)(this.yMax - this.yMin) : 1.0;
    }

    void drawXAxis(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(20, this.graphHeight + 20, 20 + this.graphWidth, this.graphHeight + 20);
    }

    void drawYAxis(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(20, this.graphHeight + 20, 20, 20);
    }

    public Color getColor() {
        return this.color;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public int getXMax() {
        return this.xMax;
    }

    public int getXMin() {
        return this.xMin;
    }

    public int getYMax() {
        return this.yMax;
    }

    public int getYMin() {
        return this.yMin;
    }

    public void init() {
        this.setXMin(0);
        this.setXMax(86400);
        this.setYMin(0);
        this.setYMax(86400);
    }

    void linePlot(Graphics graphics, Coordinate coordinate) {
        int n = (int)((double)(coordinate.x - this.xMin) * this.xScale) + 20;
        int n2 = this.graphHeight + 20 - (int)((double)(coordinate.y - this.yMin) * this.yScale);
        graphics.setColor(this.color);
        graphics.setClip(20, 20, this.graphWidth, this.graphHeight);
        graphics.drawLine(n, n2, n, this.graphHeight + 20);
    }

    public void paint(Graphics graphics) {
        this.computeScales();
        graphics.setColor(Color.black);
        graphics.drawRect(20, 20, this.graphWidth, this.graphHeight);
        graphics.setClip(20, 20, this.graphWidth, this.graphHeight);
        graphics.setColor(this.color);
        int n = 0;
        while (n < this.coords.size()) {
            Coordinate coordinate = (Coordinate)this.coords.elementAt(n);
            this.linePlot(graphics, coordinate);
            ++n;
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setXMax(int n) {
        this.xMax = n;
    }

    public void setXMin(int n) {
        this.xMin = n;
    }

    public void setYMax(int n) {
        this.yMax = n;
    }

    public void setYMin(int n) {
        this.yMin = n;
    }
}

