# Copyright 07/09/01 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)a5x00-d.x	1.13 01/07/09 Sun Microsystems"

[ use MANAGED-MODULE ]
[ requires package a5x00 ]
[ requires template a5x00-models-d ]
[ load a5x00-m.x ]

_procedures = { [ use PROC ]
        [ source a5x00-d.prc ]
}

# Define services required by this module
_services = { [ use SERVICE ]
        A5x00Shell = {
                command = "pipe://localhost/oa-shell.sh;transport=shell;args=a5x00-shell.tcl"
                max     = 1
        }
}

_filters = { [ use PROC ]
	[ source a5x00-d.flt ]
}

[ use _procedures ]

adhocCommand(tree) = probeserver -u root -c /usr/bin/cat /var/opt/SUNWsymon/cfg/a5x00.tree
adhocCommand(schema) = probeserver -c a5x00-schema.sh

# This module will be displayed in the PV/LV.
# A new module called hdreg has been added in the SunMC 3.0
# The PV/LV will read the hdreg module and get all rows in it,
# then display them.
# The hdreg module requires the hardware module to registry it when loaded,
# and unregistry it when unloaded.
# We should make sure that even the hdreg module doesn't be loaded,
# this module still can be loaded. At this time, it cannot be displayed
# in the PV/LV, but it can be displayed in the browser.

# registry to hdreg module
activateActions(post) = load
activateService(load) = _self
activateCommand(load) = regHdreg

# unregistry from hdreg module
deactivateActions(pre) = unload
deactivateService(unload) = _self
deactivateCommand(unload) = unregHdreg

# sena information
#a5x00 = { [ use templates.a5x00-models-d.a5x00  ]
#        type            = active
#	refreshService	= _services.A5x00Shell
#        refreshMode     = sync
#        refreshCommand  = sena a5x00 0 timestamp timestamp_raw
#        initInterval    = 5
#	timeoutInterval = 600
#	refreshFilter   = join

#	refreshInterval	= 1500
	
#	status_change = { [ use _filters ]
#		type		= derived
#		refreshService	= _services.A5x00Shell
#		access		= rw

#		refreshMode	= sync
#		refreshCommand	= get_status_change 
#		refreshFilter	= statusChange
#		refreshTrigger	= a5x00.timestamp:refresh
#		initInterval	= 5
#	}
#}

sena = { [ use templates.a5x00-models-d.sena ]
senaTbl = { 
        type            = active
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
#        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena sena 1  box_rev device_count id instance logical_path machine box_name node-wwn physical_path platform slot_count status type vendor_name virtual_node
        initInterval    = 5
	timeoutInterval = 600
	refreshFilter	= join
	refreshInterval	= 1500

	sena-entry = { [ use _procedures ]
		box_name = {
			access = rw

			setActions  = *define 
			setService(define)  = sena-entry
			setCommand(define)  = setSenaName %index %value
		}

		status = {
			access  = rw

			consoleHint:editAccess = rw
                        consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor

                        consoleHint:optionList = OK poweron poweroff 

			setActions  = *define 
			setService(define)  = sena-entry
			setCommand(define)  = setSenaEntry %index %value
		}

		total_config_changes = { [ use _filters ]
			type		= derived
			refreshService	= _services.A5x00Shell
			access		= rw

			refreshCommand	= get_status_change 
			refreshFilter	= statusChange
			refreshTrigger	= sena.senaTbl.sena-entry.status:refresh
			initInterval	= 2
		}
	}
}
}

front = { [ use templates.a5x00-models-d.front  ]
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena front 1 instance
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

rear = { [ use templates.a5x00-models-d.rear   ]
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena rear 1  instance
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

disk_backplane = { [ use templates.a5x00-models-d.disk_backplane ]
disk_backplaneTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
#        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh disk_backplane.disk_backplaneTbl.disk_backplane-entry.status:update
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
 	refreshCommand  = sena disk_backplane 1 box_name byp_a_enabled byp_b_enabled fru status 
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
	disk_backplane-entry = { [ use _procedures ]
		status = {
			access = rw 

			consoleHint:editAccess = rw
			consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
			consoleHint:optionList = bypass:A bypass:B enable:A enable:B

			setActions  = *define
			setService(define)  = disk_backplane-entry
			setCommand(define)  = setDiskBackplaneEntry %index %value
		}
	}
}
}

fan_tray = { [ use templates.a5x00-models-d.fan_tray ]
fan_trayTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena fan_tray 1 box_name fan_fail fru speed status type
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

led = { [ use templates.a5x00-models-d.led ]
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena led 1  led-num state
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

front_slot = { [ use templates.a5x00-models-d.front_slot  ]
front_slotTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
#        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh power_status:update sena.senaTbl.sena-entry.status:update
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena front_slot 1 box_name connect_disk id loop_status power_status slot-num status temperature temperature_status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000

	front_slot-entry = { [ use _procedures ]

		power_status  = {
			access      = rw

			consoleHint:editAccess = rw
                        consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
                        consoleHint:optionList = off on 

			setActions  = *define decrglob
			setService(define) = front_slot-entry
			setCommand(define) = setPowerEntry %index %value
		}

		loop_status = {
			access      = rw

			consoleHint:editAccess = rw
                        consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
                        consoleHint:optionList = bypass:A bypass:B enable:A enable:B

			setActions  = *define 
			setService(define) = front_slot-entry
			setCommand(define) = setBypassEntry %index %value
		}
	}
}
}

rear_slot = { [ use templates.a5x00-models-d.rear_slot ]
rear_slotTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
#        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh power_status:update sena.senaTbl.sena-entry.status:update
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena rear_slot 1 box_name connect_disk id loop_status power_status slot-num status temperature temperature_status
        initInterval    = 5
	refreshFilter	= join
	timeoutInterval = 600
	refreshInterval	= 6000

	rear_slot-entry = { [ use _procedures ]

		power_status  = {
			access      = rw

			consoleHint:editAccess = rw
                        consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
                        consoleHint:optionList = off on 

			setActions  = *define decrglob
			setService(define) = rear_slot-entry
			setCommand(define) = setPowerEntry %index %value
		}

		loop_status = {
			access      = rw

			consoleHint:editAccess = rw
                        consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
                        consoleHint:optionList = bypass:A bypass:B enable:A enable:B

			setActions  = *define 
			setService(define) = rear_slot-entry
			setCommand(define) = setBypassEntry %index %value
		}
	}
}
}


ssd = { [ use templates.a5x00-models-d.ssd  ]
ssdTbl = {
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
#        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh  front_slot.front_slotTbl.front_slot-entry.power_status:update rear_slot.rear_slotTbl.rear_slot-entry.power_status:update sena.senaTbl.sena-entry.status:update
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena ssd 1 box_name capacity device_type firmware_revision fru hard_address instance logical_path mounted_partitions name node-wwn physical_path port-wwn product_name revision serial_number status vendor_name 
        initInterval    = 5
	timeoutInterval = 600
	refreshFilter	= join
	refreshInterval	= 6000
	ssd-entry = { [ use _procedures ]
		adhocCommand(getled) = probeserver -u root -c luxadm led \[ toe_send \[ locate logical_path \] getValue %fragment \]
		adhocCommand(setledblink) = probeserver -u root -c sh -c "luxadm led_blink \[ toe_send \[ locate logical_path \] getValue %fragment \] | echo command has been sent to A5x00 storage to execute correctly."
		adhocCommand(setledon) = probeserver -u root -c luxadm led_on \[ toe_send \[ locate logical_path \] getValue %fragment \]
		adhocCommand(setledoff) = probeserver -u root -c sh -c "luxadm led_off \[ toe_send \[ locate logical_path \] getValue %fragment \] | echo command has been sent to A5x00 storage to execute correctly."

                consoleHint:tableCommands = getled setledblink setledon setledoff

		consoleHint:commandLabel(getled) = com.sun.symon.base.modules.a5x00:getled
		consoleHint:commandLabel(setledblink) = com.sun.symon.base.modules.a5x00:setledblink
		consoleHint:commandLabel(setledon) = com.sun.symon.base.modules.a5x00:setledon
		consoleHint:commandLabel(setledoff) = com.sun.symon.base.modules.a5x00:setledoff

		consoleHint:commandSpec(getled) = probeview %windowID snmp://%targetHost:%targetPort/mod/a5x00/ssd/ssdTbl/ssd-entry?runadhoccommand.getled %targetFragment

		consoleHint:commandSpec(setledblink) = probeview %windowID snmp://%targetHost:%targetPort/mod/a5x00/ssd/ssdTbl/ssd-entry?runadhoccommand.setledblink %targetFragment

		consoleHint:commandSpec(setledon) = probeview %windowID snmp://%targetHost:%targetPort/mod/a5x00/ssd/ssdTbl/ssd-entry?runadhoccommand.setledon %targetFragment

		consoleHint:commandSpec(setledoff) = probeview %windowID snmp://%targetHost:%targetPort/mod/a5x00/ssd/ssdTbl/ssd-entry?runadhoccommand.setledoff %targetFragment
	}
}
}

a5x00_power_supply = { [ use templates.a5x00-models-d.a5x00_power_supply ]
a5x00_power_supplyTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena a5x00_power_supply 1 box_name fru AC_status  DC-current DC-voltage ps-instance status temperature_status type
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

interconnect = { [ use templates.a5x00-models-d.interconnect ]
interconnectTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena interconnect 1 box_name eprom_failure fru status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

interface_board = { [ use templates.a5x00-models-d.interface_board ]
interface_boardTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena interface_board 1 box_name fru interface_board-instance loop loop0_fault loop1_fault status temperature_status 
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

gbic = { [ use templates.a5x00-models-d.gbic ]
gbicTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena gbic 1 box_name fru gbic-instance status xmit_fail
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

loop = { [ use templates.a5x00-models-d.loop ]
loopTbl = { 
        type            = derived
	refreshService	= _services.A5x00Shell
        refreshMode     = sync
        refreshTrigger  = sena.senaTbl.sena-entry.status:refresh
        refreshCommand  = sena loop 1 box_name fru loop-instance status loop_configuration_status
	refreshFilter	= join
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

a5x00-rules = { [ use templates.a5x00-models-d.a5x00-rules ]
#        type            = active
}

