--
-- Copyright (c) 1999 by Oracle Corporation. All Rights Reserved.
--
-- NAME
--   helpus.sql
--
-- DESCRIPTION
--   Inserts SQL*Plus HELP text in English
--
-- NOTES
--   This script is called from helpbld.sql

SET AUTOCOMMIT 100

INSERT INTO HELP VALUES ('@', 1, NULL);
INSERT INTO HELP VALUES ('@', 2, ' @ ("at" sign)');
INSERT INTO HELP VALUES ('@', 3, ' -------------');
INSERT INTO HELP VALUES ('@', 4, NULL);
INSERT INTO HELP VALUES ('@', 5, ' Runs the specified command file.');
INSERT INTO HELP VALUES ('@', 6, NULL);
INSERT INTO HELP VALUES ('@', 7, ' @ file_name[.ext] [arg...]');
INSERT INTO HELP VALUES ('@', 8, NULL);
INSERT INTO HELP VALUES ('@@', 1, NULL);
INSERT INTO HELP VALUES ('@@', 2, ' @@ (double "at" sign)');
INSERT INTO HELP VALUES ('@@', 3, ' ---------------------');
INSERT INTO HELP VALUES ('@@', 4, NULL);
INSERT INTO HELP VALUES ('@@', 5, ' Runs the specified command file. This command is identical to the @');
INSERT INTO HELP VALUES ('@@', 6, ' command except that it looks for the specified command file in the');
INSERT INTO HELP VALUES ('@@', 7, ' same path as the command file from which it was called.');
INSERT INTO HELP VALUES ('@@', 8, NULL);
INSERT INTO HELP VALUES ('@@', 9, ' @@ file_name[.ext]');
INSERT INTO HELP VALUES ('@@', 10, NULL);
INSERT INTO HELP VALUES ('/', 1, NULL);
INSERT INTO HELP VALUES ('/', 2, ' / (slash)');
INSERT INTO HELP VALUES ('/', 3, ' ---------');
INSERT INTO HELP VALUES ('/', 4, NULL);
INSERT INTO HELP VALUES ('/', 5, ' Executes a SQL command or PL/SQL block in the SQL buffer. Use');
INSERT INTO HELP VALUES ('/', 6, ' slash (/) at the command prompt or at a line number prompt.');
INSERT INTO HELP VALUES ('/', 7, NULL);
INSERT INTO HELP VALUES ('/', 8, ' /');
INSERT INTO HELP VALUES ('/', 9, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 1, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 2, ' ACCEPT');
INSERT INTO HELP VALUES ('ACCEPT', 3, ' ------');
INSERT INTO HELP VALUES ('ACCEPT', 4, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 5, ' Reads a line of input and stores it in a given user variable.');
INSERT INTO HELP VALUES ('ACCEPT', 6, NULL);
INSERT INTO HELP VALUES ('ACCEPT', 7, ' ACC[EPT] variable [NUM[BER] | CHAR | DATE] [FOR[MAT] format]');
INSERT INTO HELP VALUES ('ACCEPT', 8, '   [DEF[AULT] default] [PROMPT text | NOPR[OMPT]] [HIDE]');
INSERT INTO HELP VALUES ('ACCEPT', 9, NULL);
INSERT INTO HELP VALUES ('APPEND', 1, NULL);
INSERT INTO HELP VALUES ('APPEND', 2, ' APPEND');
INSERT INTO HELP VALUES ('APPEND', 3, ' ------');
INSERT INTO HELP VALUES ('APPEND', 4, NULL);
INSERT INTO HELP VALUES ('APPEND', 5, ' Adds text to the end of the current line in the SQL');
INSERT INTO HELP VALUES ('APPEND', 6, ' buffer.');
INSERT INTO HELP VALUES ('APPEND', 7, NULL);
INSERT INTO HELP VALUES ('APPEND', 8, ' A[PPEND] text');
INSERT INTO HELP VALUES ('APPEND', 9, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 1, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 2, ' ARCHIVE LOG');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 3, ' -----------');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 4, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 5, ' Starts or stops automatic archiving of online redo log files,');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 6, ' manually (explicitly) archives specified redo log files, or displays');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 7, ' information about redo log files.');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 8, NULL);
INSERT INTO HELP VALUES ('ARCHIVE LOG', 9, ' ARCHIVE LOG {LIST|STOP} | {START|NEXT|ALL|integer} [TO destination]');
INSERT INTO HELP VALUES ('ARCHIVE LOG', 10, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 1, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 2, ' ATTRIBUTE');
INSERT INTO HELP VALUES ('ATTRIBUTE', 3, ' ---------');
INSERT INTO HELP VALUES ('ATTRIBUTE', 4, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 5, ' Specifies display characteristics for a given attribute of');
INSERT INTO HELP VALUES ('ATTRIBUTE', 6, ' an Object Type column, such as format for NUMBER data.');
INSERT INTO HELP VALUES ('ATTRIBUTE', 7, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 8, ' Also lists the current display characteristics for a single');
INSERT INTO HELP VALUES ('ATTRIBUTE', 9, ' attribute or all attributes.');
INSERT INTO HELP VALUES ('ATTRIBUTE', 10, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 11, ' ATTRIBUTE [type_name.attribute_name [option... ]]');
INSERT INTO HELP VALUES ('ATTRIBUTE', 12, NULL);
INSERT INTO HELP VALUES ('ATTRIBUTE', 13, ' where option is one of the following terms or clauses:');
INSERT INTO HELP VALUES ('ATTRIBUTE', 14, '     ALI[AS] alias');
INSERT INTO HELP VALUES ('ATTRIBUTE', 15, '     CLE[AR]');
INSERT INTO HELP VALUES ('ATTRIBUTE', 16, '     FOR[MAT] format');
INSERT INTO HELP VALUES ('ATTRIBUTE', 17, '     LIKE {type_name.attribute_name | alias}');
INSERT INTO HELP VALUES ('ATTRIBUTE', 18, '     ON|OFF');
INSERT INTO HELP VALUES ('ATTRIBUTE', 19, NULL);
INSERT INTO HELP VALUES ('BREAK', 1, NULL);
INSERT INTO HELP VALUES ('BREAK', 2, ' BREAK');
INSERT INTO HELP VALUES ('BREAK', 3, ' -----');
INSERT INTO HELP VALUES ('BREAK', 4, NULL);
INSERT INTO HELP VALUES ('BREAK', 5, ' Specifies where and how to make format changes to a report.');
INSERT INTO HELP VALUES ('BREAK', 6, NULL);
INSERT INTO HELP VALUES ('BREAK', 7, ' BRE[AK] [ON report_element [action [action]]] ...');
INSERT INTO HELP VALUES ('BREAK', 8, NULL);
INSERT INTO HELP VALUES ('BREAK', 9, ' where report_element has the following syntax:');
INSERT INTO HELP VALUES ('BREAK', 10, '     {column | expression | ROW | REPORT}');
INSERT INTO HELP VALUES ('BREAK', 11, NULL);
INSERT INTO HELP VALUES ('BREAK', 12, ' and where action has the following syntax:');
INSERT INTO HELP VALUES ('BREAK', 13, '     [SKI[P] n | [SKI[P]] PAGE] [NODUP[LICATES] | DUP[LICATES]]');
INSERT INTO HELP VALUES ('BREAK', 14, NULL);
INSERT INTO HELP VALUES ('BTITLE', 1, NULL);
INSERT INTO HELP VALUES ('BTITLE', 2, ' BTITLE');
INSERT INTO HELP VALUES ('BTITLE', 3, ' ------');
INSERT INTO HELP VALUES ('BTITLE', 4, NULL);
INSERT INTO HELP VALUES ('BTITLE', 5, ' Places and formats a title at the bottom of each report page,');
INSERT INTO HELP VALUES ('BTITLE', 6, ' or lists the current BTITLE definition.');
INSERT INTO HELP VALUES ('BTITLE', 7, NULL);
INSERT INTO HELP VALUES ('BTITLE', 8, ' BTI[TLE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('BTITLE', 9, NULL);
INSERT INTO HELP VALUES ('CHANGE', 1, NULL);
INSERT INTO HELP VALUES ('CHANGE', 2, ' CHANGE');
INSERT INTO HELP VALUES ('CHANGE', 3, ' ------');
INSERT INTO HELP VALUES ('CHANGE', 4, NULL);
INSERT INTO HELP VALUES ('CHANGE', 5, ' Changes the first occurrence of the specified text on');
INSERT INTO HELP VALUES ('CHANGE', 6, ' the current line of the buffer.');
INSERT INTO HELP VALUES ('CHANGE', 7, NULL);
INSERT INTO HELP VALUES ('CHANGE', 8, ' C[HANGE] sepchar old [sepchar [new[sepchar]]]');
INSERT INTO HELP VALUES ('CHANGE', 9, NULL);
INSERT INTO HELP VALUES ('CLEAR', 1, NULL);
INSERT INTO HELP VALUES ('CLEAR', 2, ' CLEAR');
INSERT INTO HELP VALUES ('CLEAR', 3, ' -----');
INSERT INTO HELP VALUES ('CLEAR', 4, NULL);
INSERT INTO HELP VALUES ('CLEAR', 5, ' Resets or erases the current value or setting for the option,');
INSERT INTO HELP VALUES ('CLEAR', 6, NULL);
INSERT INTO HELP VALUES ('CLEAR', 7, ' CL[EAR] option ...');
INSERT INTO HELP VALUES ('CLEAR', 8, NULL);
INSERT INTO HELP VALUES ('CLEAR', 9, ' where option is one of the following clauses:');
INSERT INTO HELP VALUES ('CLEAR', 10, '     BRE[AKS]');
INSERT INTO HELP VALUES ('CLEAR', 11, '     BUFF[ER]');
INSERT INTO HELP VALUES ('CLEAR', 12, '     COL[UMNS]');
INSERT INTO HELP VALUES ('CLEAR', 13, '     COMP[UTES]');
INSERT INTO HELP VALUES ('CLEAR', 14, '     SCR[EEN]');
INSERT INTO HELP VALUES ('CLEAR', 15, '     SQL');
INSERT INTO HELP VALUES ('CLEAR', 16, '     TIMI[NG]');
INSERT INTO HELP VALUES ('CLEAR', 17, NULL);
INSERT INTO HELP VALUES ('COLUMN', 1, NULL);
INSERT INTO HELP VALUES ('COLUMN', 2, ' COLUMN');
INSERT INTO HELP VALUES ('COLUMN', 3, ' ------');
INSERT INTO HELP VALUES ('COLUMN', 4, NULL);
INSERT INTO HELP VALUES ('COLUMN', 5, ' Specifies display attributes for a given column, such as:');
INSERT INTO HELP VALUES ('COLUMN', 6, '     - column heading text');
INSERT INTO HELP VALUES ('COLUMN', 7, '     - column heading alignment');
INSERT INTO HELP VALUES ('COLUMN', 8, '     - NUMBER data format');
INSERT INTO HELP VALUES ('COLUMN', 9, '     - column data wrapping');
INSERT INTO HELP VALUES ('COLUMN', 10, NULL);
INSERT INTO HELP VALUES ('COLUMN', 11, ' Also lists the current display attributes for a single column');
INSERT INTO HELP VALUES ('COLUMN', 12, ' or all columns.');
INSERT INTO HELP VALUES ('COLUMN', 13, NULL);
INSERT INTO HELP VALUES ('COLUMN', 14, ' COL[UMN] [{column | expr} [option...] ]');
INSERT INTO HELP VALUES ('COLUMN', 15, NULL);
INSERT INTO HELP VALUES ('COLUMN', 16, ' where option is one of the following clauses:');
INSERT INTO HELP VALUES ('COLUMN', 17, '     ALI[AS] alias');
INSERT INTO HELP VALUES ('COLUMN', 18, '     CLE[AR]');
INSERT INTO HELP VALUES ('COLUMN', 19, '     FOLD_A[FTER]');
INSERT INTO HELP VALUES ('COLUMN', 20, '     FOLD_B[EFORE]');
INSERT INTO HELP VALUES ('COLUMN', 21, '     FOR[MAT] format');
INSERT INTO HELP VALUES ('COLUMN', 22, '     HEA[DING] text');
INSERT INTO HELP VALUES ('COLUMN', 23, '     JUS[TIFY] {L[EFT] | C[ENTER] | C[ENTRE] | R[IGHT]}');
INSERT INTO HELP VALUES ('COLUMN', 24, '     LIKE {expr | alias}');
INSERT INTO HELP VALUES ('COLUMN', 25, '     NEWL[INE]');
INSERT INTO HELP VALUES ('COLUMN', 26, '     NEW_V[ALUE] variable');
INSERT INTO HELP VALUES ('COLUMN', 27, '     NOPRI[NT] | PRI[NT]');
INSERT INTO HELP VALUES ('COLUMN', 28, '     NUL[L] text');
INSERT INTO HELP VALUES ('COLUMN', 29, '     OLD_V[ALUE] variable');
INSERT INTO HELP VALUES ('COLUMN', 30, '     ON|OFF');
INSERT INTO HELP VALUES ('COLUMN', 31, '     WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED]');
INSERT INTO HELP VALUES ('COLUMN', 32, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 1, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 2, ' COMPUTE');
INSERT INTO HELP VALUES ('COMPUTE', 3, ' -------');
INSERT INTO HELP VALUES ('COMPUTE', 4, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 5, ' Calculates and prints summary lines, using various standard');
INSERT INTO HELP VALUES ('COMPUTE', 6, ' computations, on subsets of selected rows. It also lists all');
INSERT INTO HELP VALUES ('COMPUTE', 7, ' COMPUTE definitions.');
INSERT INTO HELP VALUES ('COMPUTE', 8, NULL);
INSERT INTO HELP VALUES ('COMPUTE', 9, ' COMP[UTE] [function [LAB[EL] text] ...');
INSERT INTO HELP VALUES ('COMPUTE', 10, '   OF {expr|column|alias} ...');
INSERT INTO HELP VALUES ('COMPUTE', 11, '   ON {expr|column|alias|REPORT|ROW} ...]');
INSERT INTO HELP VALUES ('COMPUTE', 12, NULL);
INSERT INTO HELP VALUES ('CONNECT', 1, NULL);
INSERT INTO HELP VALUES ('CONNECT', 2, ' CONNECT');
INSERT INTO HELP VALUES ('CONNECT', 3, ' -------');
INSERT INTO HELP VALUES ('CONNECT', 4, NULL);
INSERT INTO HELP VALUES ('CONNECT', 5, ' Connects a given username to Oracle.');
INSERT INTO HELP VALUES ('CONNECT', 6, NULL);
INSERT INTO HELP VALUES ('CONNECT', 7, ' CONN[ECT] [logon] [AS [SYSOPER|SYSDBA]] | [INTERNAL]');
INSERT INTO HELP VALUES ('CONNECT', 8, NULL);
INSERT INTO HELP VALUES ('CONNECT', 9, ' where logon has the following syntax:');
INSERT INTO HELP VALUES ('CONNECT', 10, '     username[/password] [@net_service_name]  |  /');
INSERT INTO HELP VALUES ('CONNECT', 11, NULL);
INSERT INTO HELP VALUES ('COPY', 1, NULL);
INSERT INTO HELP VALUES ('COPY', 2, ' COPY');
INSERT INTO HELP VALUES ('COPY', 3, ' ----');
INSERT INTO HELP VALUES ('COPY', 4, NULL);
INSERT INTO HELP VALUES ('COPY', 5, ' COPY copies data from a query to a table in a local or remote');
INSERT INTO HELP VALUES ('COPY', 6, ' database.');
INSERT INTO HELP VALUES ('COPY', 7, NULL);
INSERT INTO HELP VALUES ('COPY', 8, ' COPY {FROM database | TO database | FROM database TO database}');
INSERT INTO HELP VALUES ('COPY', 9, '            {APPEND|CREATE|INSERT|REPLACE} destination_table');
INSERT INTO HELP VALUES ('COPY', 10, '            [(column, column, column, ...)] USING query');
INSERT INTO HELP VALUES ('COPY', 11, NULL);
INSERT INTO HELP VALUES ('COPY', 12, ' where database has the following syntax:');
INSERT INTO HELP VALUES ('COPY', 13, '     username[/password]@net_service_name');
INSERT INTO HELP VALUES ('COPY', 14, NULL);
INSERT INTO HELP VALUES ('DEFINE', 1, NULL);
INSERT INTO HELP VALUES ('DEFINE', 2, ' DEFINE');
INSERT INTO HELP VALUES ('DEFINE', 3, ' ------');
INSERT INTO HELP VALUES ('DEFINE', 4, NULL);
INSERT INTO HELP VALUES ('DEFINE', 5, ' Specifies a user variable and assigns it a CHAR value, or');
INSERT INTO HELP VALUES ('DEFINE', 6, ' lists the value and variable type of a single variable or all');
INSERT INTO HELP VALUES ('DEFINE', 7, ' variables.');
INSERT INTO HELP VALUES ('DEFINE', 8, NULL);
INSERT INTO HELP VALUES ('DEFINE', 9, ' DEF[INE] [variable] | [variable = text]');
INSERT INTO HELP VALUES ('DEFINE', 10, NULL);
INSERT INTO HELP VALUES ('DEL', 1, NULL);
INSERT INTO HELP VALUES ('DEL', 2, ' DEL');
INSERT INTO HELP VALUES ('DEL', 3, ' ---');
INSERT INTO HELP VALUES ('DEL', 4, NULL);
INSERT INTO HELP VALUES ('DEL', 5, ' Deletes one or more lines of the buffer.');
INSERT INTO HELP VALUES ('DEL', 6, NULL);
INSERT INTO HELP VALUES ('DEL', 7, ' DEL [n | n m | n * | n LAST | * | * n | * LAST | LAST]');
INSERT INTO HELP VALUES ('DEL', 8, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 1, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 2, ' DESCRIBE');
INSERT INTO HELP VALUES ('DESCRIBE', 3, ' --------');
INSERT INTO HELP VALUES ('DESCRIBE', 4, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 5, ' Lists the column definitions for a table, view, or synonym,');
INSERT INTO HELP VALUES ('DESCRIBE', 6, ' or the specifications for a function or procedure.');
INSERT INTO HELP VALUES ('DESCRIBE', 7, NULL);
INSERT INTO HELP VALUES ('DESCRIBE', 8, ' DESC[RIBE] {[schema.]object[@database_link_name]}');
INSERT INTO HELP VALUES ('DESCRIBE', 9, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 1, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 2, ' DISCONNECT');
INSERT INTO HELP VALUES ('DISCONNECT', 3, ' ----------');
INSERT INTO HELP VALUES ('DISCONNECT', 4, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 5, ' Commits pending changes to the database and logs the current');
INSERT INTO HELP VALUES ('DISCONNECT', 6, ' username out of Oracle, but does not exit SQL*Plus. Use EXIT or');
INSERT INTO HELP VALUES ('DISCONNECT', 7, ' QUIT to log out of Oracle and return control to your host');
INSERT INTO HELP VALUES ('DISCONNECT', 8, ' computer''s operating system.');
INSERT INTO HELP VALUES ('DISCONNECT', 9, NULL);
INSERT INTO HELP VALUES ('DISCONNECT', 10, ' DISC[ONNECT]');
INSERT INTO HELP VALUES ('DISCONNECT', 11, NULL);
INSERT INTO HELP VALUES ('EDIT', 1, NULL);
INSERT INTO HELP VALUES ('EDIT', 2, ' EDIT');
INSERT INTO HELP VALUES ('EDIT', 3, ' ----');
INSERT INTO HELP VALUES ('EDIT', 4, NULL);
INSERT INTO HELP VALUES ('EDIT', 5, ' Invokes a host operating system text editor on the contents of');
INSERT INTO HELP VALUES ('EDIT', 6, ' the specified file or on the contents of the buffer.');
INSERT INTO HELP VALUES ('EDIT', 7, NULL);
INSERT INTO HELP VALUES ('EDIT', 8, ' ED[IT] [file_name[.ext]]');
INSERT INTO HELP VALUES ('EDIT', 9, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 1, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 2, ' EXECUTE');
INSERT INTO HELP VALUES ('EXECUTE', 3, ' -------');
INSERT INTO HELP VALUES ('EXECUTE', 4, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 5, ' Executes a single PL/SQL statement. The EXECUTE command is');
INSERT INTO HELP VALUES ('EXECUTE', 6, ' often useful when you want to execute a PL/SQL statement that');
INSERT INTO HELP VALUES ('EXECUTE', 7, ' references a stored procedure.');
INSERT INTO HELP VALUES ('EXECUTE', 8, NULL);
INSERT INTO HELP VALUES ('EXECUTE', 9, ' EXEC[UTE] statement');
INSERT INTO HELP VALUES ('EXECUTE', 10, NULL);
INSERT INTO HELP VALUES ('EXIT', 1, NULL);
INSERT INTO HELP VALUES ('EXIT', 2, ' EXIT');
INSERT INTO HELP VALUES ('EXIT', 3, ' ----');
INSERT INTO HELP VALUES ('EXIT', 4, NULL);
INSERT INTO HELP VALUES ('EXIT', 5, ' Terminates SQL*Plus and returns control to the operating');
INSERT INTO HELP VALUES ('EXIT', 6, ' system.');
INSERT INTO HELP VALUES ('EXIT', 7, NULL);
INSERT INTO HELP VALUES ('EXIT', 8, ' {EXIT|QUIT} [SUCCESS|FAILURE|WARNING|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('EXIT', 9, '   [COMMIT|ROLLBACK]');
INSERT INTO HELP VALUES ('EXIT', 10, NULL);
INSERT INTO HELP VALUES ('GET', 1, NULL);
INSERT INTO HELP VALUES ('GET', 2, ' GET');
INSERT INTO HELP VALUES ('GET', 3, ' ---');
INSERT INTO HELP VALUES ('GET', 4, NULL);
INSERT INTO HELP VALUES ('GET', 5, ' Loads a host operating system file into the SQL buffer.');
INSERT INTO HELP VALUES ('GET', 6, NULL);
INSERT INTO HELP VALUES ('GET', 7, ' GET file_name[.ext] [LIS[T] | NOL[IST]]');
INSERT INTO HELP VALUES ('GET', 8, NULL);
INSERT INTO HELP VALUES ('HELP', 1, NULL);
INSERT INTO HELP VALUES ('HELP', 2, ' HELP');
INSERT INTO HELP VALUES ('HELP', 3, ' ----');
INSERT INTO HELP VALUES ('HELP', 4, NULL);
INSERT INTO HELP VALUES ('HELP', 5, ' Accesses the SQL*Plus help system.  Enter HELP INDEX for a list of topics.');
INSERT INTO HELP VALUES ('HELP', 6, NULL);
INSERT INTO HELP VALUES ('HELP', 7, ' HELP [topic]');
INSERT INTO HELP VALUES ('HELP', 8, NULL);
INSERT INTO HELP VALUES ('HOST', 1, NULL);
INSERT INTO HELP VALUES ('HOST', 2, ' HOST');
INSERT INTO HELP VALUES ('HOST', 3, ' ----');
INSERT INTO HELP VALUES ('HOST', 4, NULL);
INSERT INTO HELP VALUES ('HOST', 5, ' Executes a host operating system command without leaving');
INSERT INTO HELP VALUES ('HOST', 6, ' SQL*Plus.');
INSERT INTO HELP VALUES ('HOST', 7, NULL);
INSERT INTO HELP VALUES ('HOST', 8, ' HO[ST] [command]');
INSERT INTO HELP VALUES ('HOST', 9, NULL);
INSERT INTO HELP VALUES ('INDEX', 1, NULL);
INSERT INTO HELP VALUES ('INDEX', 2, ' @             COPY         PAUSE                    SHUTDOWN');
INSERT INTO HELP VALUES ('INDEX', 3, ' @@            DEFINE       PRINT                    SPOOL');
INSERT INTO HELP VALUES ('INDEX', 4, ' /             DEL          PROMPT                   SQLPLUS');
INSERT INTO HELP VALUES ('INDEX', 5, ' ACCEPT        DESCRIBE     QUIT                     START');
INSERT INTO HELP VALUES ('INDEX', 6, ' APPEND        DISCONNECT   RECOVER                  STARTUP');
INSERT INTO HELP VALUES ('INDEX', 7, ' ARCHIVE LOG   EDIT         REMARK                   STORE');
INSERT INTO HELP VALUES ('INDEX', 8, ' ATTRIBUTE     EXECUTE      REPFOOTER                TIMING');
INSERT INTO HELP VALUES ('INDEX', 9, ' BREAK         EXIT         REPHEADER                TTITLE');
INSERT INTO HELP VALUES ('INDEX', 10, ' BTITLE        GET          RESERVED WORDS (SQL)     UNDEFINE');
INSERT INTO HELP VALUES ('INDEX', 11, ' CHANGE        HELP         RESERVED WORDS (PL/SQL)  VARIABLE');
INSERT INTO HELP VALUES ('INDEX', 12, ' CLEAR         HOST         RUN                      WHENEVER OSERROR');
INSERT INTO HELP VALUES ('INDEX', 13, ' COLUMN        INPUT        SAVE                     WHENEVER SQLERROR');
INSERT INTO HELP VALUES ('INDEX', 14, ' COMPUTE       LIST         SET');
INSERT INTO HELP VALUES ('INDEX', 15, ' CONNECT       PASSWORD     SHOW');
INSERT INTO HELP VALUES ('INDEX', 16, NULL);
INSERT INTO HELP VALUES ('INPUT', 1, NULL);
INSERT INTO HELP VALUES ('INPUT', 2, ' INPUT');
INSERT INTO HELP VALUES ('INPUT', 3, ' -----');
INSERT INTO HELP VALUES ('INPUT', 4, NULL);
INSERT INTO HELP VALUES ('INPUT', 5, ' Adds one or more lines of text after the current line in the');
INSERT INTO HELP VALUES ('INPUT', 6, ' buffer.');
INSERT INTO HELP VALUES ('INPUT', 7, NULL);
INSERT INTO HELP VALUES ('INPUT', 8, ' I[NPUT] [text]');
INSERT INTO HELP VALUES ('INPUT', 9, NULL);
INSERT INTO HELP VALUES ('LIST', 1, NULL);
INSERT INTO HELP VALUES ('LIST', 2, ' LIST');
INSERT INTO HELP VALUES ('LIST', 3, ' ----');
INSERT INTO HELP VALUES ('LIST', 4, NULL);
INSERT INTO HELP VALUES ('LIST', 5, ' Lists one or more lines of the SQL buffer. Enter LIST with no');
INSERT INTO HELP VALUES ('LIST', 6, ' clauses to list all lines.');
INSERT INTO HELP VALUES ('LIST', 7, NULL);
INSERT INTO HELP VALUES ('LIST', 8, ' L[IST] [n | n m | n  * | n LAST | * | * n | * LAST | LAST]');
INSERT INTO HELP VALUES ('LIST', 9, NULL);
INSERT INTO HELP VALUES ('MENU', 1, NULL);
INSERT INTO HELP VALUES ('MENU', 2, ' Menu');
INSERT INTO HELP VALUES ('MENU', 3, ' ----');
INSERT INTO HELP VALUES ('MENU', 4, NULL);
INSERT INTO HELP VALUES ('MENU', 5, ' Enter HELP INDEX for a list of help topics.');
INSERT INTO HELP VALUES ('MENU', 6, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 1, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 2, ' PASSWORD');
INSERT INTO HELP VALUES ('PASSWORD', 3, ' --------');
INSERT INTO HELP VALUES ('PASSWORD', 4, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 5, ' Allows you to change a password without echoing the password');
INSERT INTO HELP VALUES ('PASSWORD', 6, ' on an input device.');
INSERT INTO HELP VALUES ('PASSWORD', 7, NULL);
INSERT INTO HELP VALUES ('PASSWORD', 8, ' PASSW[ORD] [username]');
INSERT INTO HELP VALUES ('PASSWORD', 9, NULL);
INSERT INTO HELP VALUES ('PAUSE', 1, NULL);
INSERT INTO HELP VALUES ('PAUSE', 2, ' PAUSE');
INSERT INTO HELP VALUES ('PAUSE', 3, ' -----');
INSERT INTO HELP VALUES ('PAUSE', 4, NULL);
INSERT INTO HELP VALUES ('PAUSE', 5, ' Displays an empty line followed by a line containing text, then');
INSERT INTO HELP VALUES ('PAUSE', 6, ' waits for the user to press RETURN, or displays two empty lines,');
INSERT INTO HELP VALUES ('PAUSE', 7, ' and waits for the user''s response.');
INSERT INTO HELP VALUES ('PAUSE', 8, NULL);
INSERT INTO HELP VALUES ('PAUSE', 9, ' PAU[SE] [text]');
INSERT INTO HELP VALUES ('PAUSE', 10, NULL);
INSERT INTO HELP VALUES ('PRINT', 1, NULL);
INSERT INTO HELP VALUES ('PRINT', 2, ' PRINT');
INSERT INTO HELP VALUES ('PRINT', 3, ' -----');
INSERT INTO HELP VALUES ('PRINT', 4, NULL);
INSERT INTO HELP VALUES ('PRINT', 5, ' Displays the current value of bind variables.');
INSERT INTO HELP VALUES ('PRINT', 6, NULL);
INSERT INTO HELP VALUES ('PRINT', 7, ' PRI[NT] [variable ...]');
INSERT INTO HELP VALUES ('PRINT', 8, NULL);
INSERT INTO HELP VALUES ('PROMPT', 1, NULL);
INSERT INTO HELP VALUES ('PROMPT', 2, ' PROMPT');
INSERT INTO HELP VALUES ('PROMPT', 3, ' ------');
INSERT INTO HELP VALUES ('PROMPT', 4, NULL);
INSERT INTO HELP VALUES ('PROMPT', 5, ' Sends the specified message or a blank line to the user''s');
INSERT INTO HELP VALUES ('PROMPT', 6, ' screen.');
INSERT INTO HELP VALUES ('PROMPT', 7, NULL);
INSERT INTO HELP VALUES ('PROMPT', 8, ' PRO[MPT] [text]');
INSERT INTO HELP VALUES ('PROMPT', 9, NULL);
INSERT INTO HELP VALUES ('QUIT', 1, NULL);
INSERT INTO HELP VALUES ('QUIT', 2, ' QUIT');
INSERT INTO HELP VALUES ('QUIT', 3, ' ----');
INSERT INTO HELP VALUES ('QUIT', 4, NULL);
INSERT INTO HELP VALUES ('QUIT', 5, ' Terminates SQL*Plus and returns control to the operating system.');
INSERT INTO HELP VALUES ('QUIT', 6, NULL);
INSERT INTO HELP VALUES ('QUIT', 7, ' Enter HELP EXIT for QUIT command syntax.');
INSERT INTO HELP VALUES ('QUIT', 8, NULL);
INSERT INTO HELP VALUES ('QUIT', 9, NULL);
INSERT INTO HELP VALUES ('RECOVER', 1, NULL);
INSERT INTO HELP VALUES ('RECOVER', 2, ' RECOVER');
INSERT INTO HELP VALUES ('RECOVER', 3, ' -------');
INSERT INTO HELP VALUES ('RECOVER', 4, NULL);
INSERT INTO HELP VALUES ('RECOVER', 5, ' Performs media recovery on one or more tablespaces, one or more');
INSERT INTO HELP VALUES ('RECOVER', 6, ' datafiles, or the entire database.');
INSERT INTO HELP VALUES ('RECOVER', 7, NULL);
INSERT INTO HELP VALUES ('RECOVER', 8, ' RECOVER {general | managed} [parallel]');
INSERT INTO HELP VALUES ('RECOVER', 9, NULL);
INSERT INTO HELP VALUES ('RECOVER', 10, ' where the general clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 11, '     [AUTOMATIC] [FROM location]');
INSERT INTO HELP VALUES ('RECOVER', 12, '     {[STANDBY] DATABASE [ [UNTIL {CANCEL | CHANGE integer | TIME date}');
INSERT INTO HELP VALUES ('RECOVER', 13, '                           | USING BACKUP CONTROLFILE]...]');
INSERT INTO HELP VALUES ('RECOVER', 14, '      | STANDBY {DATAFILE datafilename [, DATAFILE datafilename...]');
INSERT INTO HELP VALUES ('RECOVER', 15, '                 | TABLESPACE tablespace [, TABLESPACE tablespace ...]}');
INSERT INTO HELP VALUES ('RECOVER', 16, '          UNTIL [CONSISTENT] [WITH] CONTROLFILE');
INSERT INTO HELP VALUES ('RECOVER', 17, '      | TABLESPACE tablespace [, tablespace ...]');
INSERT INTO HELP VALUES ('RECOVER', 18, '      | DATAFILE datafilename [, datafilename ...]');
INSERT INTO HELP VALUES ('RECOVER', 19, '      | LOGFILE filename');
INSERT INTO HELP VALUES ('RECOVER', 20, '      | CONTINUE [DEFAULT]');
INSERT INTO HELP VALUES ('RECOVER', 21, '      | CANCEL}');
INSERT INTO HELP VALUES ('RECOVER', 22, NULL);
INSERT INTO HELP VALUES ('RECOVER', 23, ' and where the managed clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 24, '     MANAGED STANDBY DATABASE {TIMEOUT integer | CANCEL [IMMEDIATE]}');
INSERT INTO HELP VALUES ('RECOVER', 25, NULL);
INSERT INTO HELP VALUES ('RECOVER', 26, ' and where the parallel clause has the following syntax:');
INSERT INTO HELP VALUES ('RECOVER', 27, '     {PARALLEL [integer]} | NOPARALLEL');
INSERT INTO HELP VALUES ('RECOVER', 28, NULL);
INSERT INTO HELP VALUES ('REMARK', 1, NULL);
INSERT INTO HELP VALUES ('REMARK', 2, ' REMARK');
INSERT INTO HELP VALUES ('REMARK', 3, ' ------');
INSERT INTO HELP VALUES ('REMARK', 4, NULL);
INSERT INTO HELP VALUES ('REMARK', 5, ' Begins a comment in a command file.');
INSERT INTO HELP VALUES ('REMARK', 6, NULL);
INSERT INTO HELP VALUES ('REMARK', 7, ' REM[ARK]');
INSERT INTO HELP VALUES ('REMARK', 8, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 1, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 2, ' REPFOOTER');
INSERT INTO HELP VALUES ('REPFOOTER', 3, ' ---------');
INSERT INTO HELP VALUES ('REPFOOTER', 4, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 5, ' Places and formats a footer at the bottom of a report, or lists the');
INSERT INTO HELP VALUES ('REPFOOTER', 6, ' REPFOOTER definition.');
INSERT INTO HELP VALUES ('REPFOOTER', 7, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 8, ' REPF[OOTER] [PAGE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('REPFOOTER', 9, NULL);
INSERT INTO HELP VALUES ('REPFOOTER', 10, ' where printspec is one or more of the following clauses:');
INSERT INTO HELP VALUES ('REPFOOTER', 11, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('REPFOOTER', 12, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('REPFOOTER', 13, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('REPFOOTER', 14, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 1, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 2, ' REPHEADER');
INSERT INTO HELP VALUES ('REPHEADER', 3, ' ---------');
INSERT INTO HELP VALUES ('REPHEADER', 4, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 5, ' Places and formats a header at the top of a report, or lists the');
INSERT INTO HELP VALUES ('REPHEADER', 6, ' REPHEADER definition.');
INSERT INTO HELP VALUES ('REPHEADER', 7, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 8, ' REPH[EADER] [PAGE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('REPHEADER', 9, NULL);
INSERT INTO HELP VALUES ('REPHEADER', 10, ' where printspec is one or more of the following clauses:');
INSERT INTO HELP VALUES ('REPHEADER', 11, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('REPHEADER', 12, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('REPHEADER', 13, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('REPHEADER', 14, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 1, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 2, ' RESERVED WORDS (SQL)');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 3, ' --------------------');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 4, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 5, ' SQL Reserved Words have special meaning in SQL, and may not be used for');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 6, ' identifier names unless enclosed in "quotes".');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 7, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 8, ' An asterisk (*) indicates words are also ANSI Reserved Words.');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 9, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 10, ' Oracle prefixes implicitly generated schema object and subobject names');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 11, ' with "SYS_". To avoid name resolution conflict, Oracle discourages you');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 12, ' from prefixing your schema object and subobject names with "SYS_".');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 13, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 14, ' ACCESS          CHAR*           DEFAULT*         FROM*           INTEGER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 15, ' ADD*            CHECK*          DELETE*          GRANT*          INTERSECT*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 16, ' ALL*            CLUSTER         DESC*            GROUP*          INTO*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 17, ' ALTER*          COLUMN          DISTINCT*        HAVING*         IS*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 18, ' AND*            COMMENT         DROP*            IDENTIFIED      LEVEL*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 19, ' ANY*            COMPRESS        ELSE*            IMMEDIATE*      LIKE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 20, ' AS*             CONNECT*        EXCLUSIVE        IN*             LOCK');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 21, ' ASC*            CREATE*         EXISTS           INCREMENT       LONG');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 22, ' AUDIT           CURRENT*        FILE             INDEX           MAXEXTENTS');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 23, ' BETWEEN*        DATE*           FLOAT*           INITIAL         MINUS');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 24, ' BY*             DECIMAL*        FOR*             INSERT*         MLSLABEL');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 25, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 26, ' MODE            ONLINE          REVOKE*         START           UPDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 27, ' MODIFY          OPTION*         ROW             SUCCESSFUL      USER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 28, ' NOAUDIT         OR*             ROWID           SYNONYM         VALIDATE');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 29, ' NOCOMPRESS      ORDER*          ROWNUM          SYSDATE         VALUES*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 30, ' NOT*            PCTFREE         ROWS*           TABLE*          VARCHAR*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 31, ' NOWAIT          PRIOR*          SELECT*         THEN*           VARCHAR2');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 32, ' NULL*           PRIVILEGES*     SESSION*        TO*             VIEW*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 33, ' NUMBER          PUBLIC*         SET*            TRIGGER         WHENEVER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 34, ' OF*             RAW             SHARE           UID             WHERE');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 35, ' OFFLINE         RENAME          SIZE*           UNION*          WITH*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 36, ' ON*             RESOURCE        SMALLINT*       UNIQUE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (SQL)', 37, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 1, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 2, ' RESERVED WORDS (PL/SQL)');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 3, ' -----------------------');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 4, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 5, ' PL/SQL Reserved Words have special meaning in PL/SQL, and may not be used');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 6, ' for identifier names (unless enclosed in "quotes").');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 7, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 8, ' An asterisk (*) indicates words are also SQL Reserved Words.');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 9, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 10, ' ALL*            BULK            CURRVAL         EXCEPTION       HAVING*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 11, ' ALTER*          BY*             CURSOR          EXCLUSIVE*      HEAP');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 12, ' AND*            CHAR*           DATE*           EXECUTE         HOUR');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 13, ' ANY*            CHAR_BASE       DAY             EXISTS*         IF');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 14, ' ARRAY           CHECK*          DECLARE         EXIT            IMMEDIATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 15, ' AS*             CLOSE           DECIMAL*        EXTENDS         IN*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 16, ' ASC*            CLUSTER*        DEFAULT*        FALSE           INDEX*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 17, ' AT              COLLECT         DELETE*         FETCH           INDICATOR');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 18, ' AUTHID          COMMENT*        DESC*           FLOAT*          INSERT*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 19, ' AVG             COMMIT          DISTINCT*       FOR*            INTEGER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 20, ' BEGIN           COMPRESS*       DO              FORALL          INTERFACE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 21, ' BETWEEN*        CONNECT*        DROP*           FROM*           INTERSECT*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 22, ' BINARY_INTEGER  CONSTANT        ELSE*           FUNCTION        INTERVAL');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 23, ' BODY            CREATE*         ELSIF           GOTO            INTO*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 24, ' BOOLEAN         CURRENT*        END             GROUP*          IS*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 25, NULL);
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 26, ' ISOLATION       NOWAIT*         PRAGMA          SELECT*         TRUE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 27, ' JAVA            NULL*           PRIOR*          SEPERATE        TYPE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 28, ' LEVEL*          NUMBER*         PRIVATE         SET*            UID*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 29, ' LIKE*           NUMBER_BASE     PROCEDURE       SHARE*          UNION*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 30, ' LIMITED         OCIROWID        PUBLIC*         SMALLINT*       UNIQUE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 31, ' LOCK*           OF*             RAISE           SPACE           UPDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 32, ' LONG*           ON*             RANGE           SQL             USE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 33, ' LOOP            OPAQUE          RAW*            SQLCODE         USER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 34, ' MAX             OPEN            REAL            SQLERRM         VALIDATE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 35, ' MIN             OPERATOR        RECORD          START*          VALUES*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 36, ' MINUS*          OPTION*         REF             STDDEV          VARCHAR*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 37, ' MINUTE          OR*             RELEASE         SUBTYPE         VARCHAR2*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 38, ' MLSLABEL*       ORDER*          RETURN          SUCCESSFUL*     VARIANCE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 39, ' MOD             ORGANIZATION    REVERSE         SUM             VIEW*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 40, ' MODE*           OTHERS          ROLLBACK        SYNONYM*        WHEN');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 41, ' MONTH           OUT             ROW*            SYSDATE*        WHENEVER*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 42, ' NATURAL         PACKAGE         ROWID*          TABLE*          WHERE*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 43, ' NATURALN        PARTITION       ROWLABEL        THEN*           WHILE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 44, ' NEW             PCTFREE*        ROWNUM*         TIME            WITH*');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 45, ' NEXTVAL         PLS_INTEGER     ROWTYPE         TIMESTAMP       WORK');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 46, ' NOCOPY          POSITIVE        SAVEPOINT       TO*             WRITE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 47, ' NOT*            POSITIVEN       SECOND          TRIGGER*        YEAR      ZONE');
INSERT INTO HELP VALUES ('RESERVED WORDS (PL/SQL)', 48, NULL);
INSERT INTO HELP VALUES ('RUN', 1, NULL);
INSERT INTO HELP VALUES ('RUN', 2, ' RUN');
INSERT INTO HELP VALUES ('RUN', 3, ' ---');
INSERT INTO HELP VALUES ('RUN', 4, NULL);
INSERT INTO HELP VALUES ('RUN', 5, ' Lists and executes the SQL command or PL/SQL block currently in');
INSERT INTO HELP VALUES ('RUN', 6, ' the SQL buffer.');
INSERT INTO HELP VALUES ('RUN', 7, NULL);
INSERT INTO HELP VALUES ('RUN', 8, ' R[UN]');
INSERT INTO HELP VALUES ('RUN', 9, NULL);
INSERT INTO HELP VALUES ('SAVE', 1, NULL);
INSERT INTO HELP VALUES ('SAVE', 2, ' SAVE');
INSERT INTO HELP VALUES ('SAVE', 3, ' ----');
INSERT INTO HELP VALUES ('SAVE', 4, NULL);
INSERT INTO HELP VALUES ('SAVE', 5, ' Saves the contents of the SQL buffer in a host operating system');
INSERT INTO HELP VALUES ('SAVE', 6, ' command file.');
INSERT INTO HELP VALUES ('SAVE', 7, NULL);
INSERT INTO HELP VALUES ('SAVE', 8, ' SAV[E] file_name[.ext] [CRE[ATE] | REP[LACE] | APP[END]]');
INSERT INTO HELP VALUES ('SAVE', 9, NULL);
INSERT INTO HELP VALUES ('SET', 1, NULL);
INSERT INTO HELP VALUES ('SET', 2, ' SET');
INSERT INTO HELP VALUES ('SET', 3, ' ---');
INSERT INTO HELP VALUES ('SET', 4, NULL);
INSERT INTO HELP VALUES ('SET', 5, ' Sets a system variable to alter the SQL*Plus environment settings');
INSERT INTO HELP VALUES ('SET', 6, ' for your current session, for example:');
INSERT INTO HELP VALUES ('SET', 7, '     -   display width for NUMBER data');
INSERT INTO HELP VALUES ('SET', 8, '     -   display width for LONG data');
INSERT INTO HELP VALUES ('SET', 9, '     -   enabling or disabling printing of column headings');
INSERT INTO HELP VALUES ('SET', 10, '     -   number of lines per page');
INSERT INTO HELP VALUES ('SET', 11, NULL);
INSERT INTO HELP VALUES ('SET', 12, ' SET system_variable value');
INSERT INTO HELP VALUES ('SET', 13, NULL);
INSERT INTO HELP VALUES ('SET', 14, ' where system_variable and value represent one of the following clauses:');
INSERT INTO HELP VALUES ('SET', 15, NULL);
INSERT INTO HELP VALUES ('SET', 16, '   APPI[NFO]{ON|OFF|text}                   NEWP[AGE] {1|n|NONE}');
INSERT INTO HELP VALUES ('SET', 17, '   ARRAY[SIZE] {15|n}                       NULL text');
INSERT INTO HELP VALUES ('SET', 18, '   AUTO[COMMIT] {OFF|ON|IMM[EDIATE]|n}      NUMF[ORMAT] format');
INSERT INTO HELP VALUES ('SET', 19, '   AUTOP[RINT] {OFF|ON}                     NUM[WIDTH] {10|n}');
INSERT INTO HELP VALUES ('SET', 20, '   AUTORECOVERY {ON|OFF}                    PAGES[IZE] {24|n}');
INSERT INTO HELP VALUES ('SET', 21, '   AUTOT[RACE] {OFF|ON|TRACE[ONLY]}         PAU[SE] {OFF|ON|text}');
INSERT INTO HELP VALUES ('SET', 22, '     [EXP[LAIN]] [STAT[ISTICS]]             RECSEP {WR[APPED] |');
INSERT INTO HELP VALUES ('SET', 23, '   BLO[CKTERMINATOR] {.|c}                    EA[CH]|OFF}');
INSERT INTO HELP VALUES ('SET', 24, '   CMDS[EP] {;|c|OFF|ON}                    RECSEPCHAR { |c}');
INSERT INTO HELP VALUES ('SET', 25, '   COLSEP  {_|text}                         SEVEROUT[PUT] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 26, '   COM[PATIBILITY] {V7|V8|NATIVE}             [SIZE n] [FOR[MAT]');
INSERT INTO HELP VALUES ('SET', 27, '   CON[CAT] {.|c|OFF|ON}                      {WRA[PPED] |');
INSERT INTO HELP VALUES ('SET', 28, '   COPYC[OMMIT] {0|n}                         WOR[D_WRAPPED] |');
INSERT INTO HELP VALUES ('SET', 29, '   COPYTYPECHECK {OFF|ON}                     TRU[NCATED]}]');
INSERT INTO HELP VALUES ('SET', 30, '   DEF[INE] {''&''|c|OFF|ON}                  SHIFT[INOUT] {VIS[IBLE] |');
INSERT INTO HELP VALUES ('SET', 31, '   DESCRIBE [DEPTH {1|n|ALL}]                 INV[ISIBLE]}');
INSERT INTO HELP VALUES ('SET', 32, '     [LINENUM {ON|OFF}] [INDENT {ON|OFF}]   SHOW[MODE] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 33, '   ECHO {OFF|ON}                            SQLBL[ANKLINES] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 34, '   EDITF[ILE] file_name[.ext]               SQLC[ASE] {MIX[ED] |');
INSERT INTO HELP VALUES ('SET', 35, '   EMB[EDDED] {OFF|ON}                        LO[WER] | UP[PER]}');
INSERT INTO HELP VALUES ('SET', 36, '   ESC[APE] {\|c|OFF|ON}                    SQLCO[NTINUE] {> | text}');
INSERT INTO HELP VALUES ('SET', 37, '   FEED[BACK] {6|n|OFF|ON}                  SQLN[UMBER] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 38, '   FLAGGER {OFF|ENTRY|INTERMED[IATE]|FULL}  SQLPRE[FIX] {#|c}');
INSERT INTO HELP VALUES ('SET', 39, '   FLU[SH] {OFF|ON}                         SQLP[ROMPT] {SQL>|text}');
INSERT INTO HELP VALUES ('SET', 40, '   HEA[DING] {OFF|ON}                       SQLT[ERMINATOR]');
INSERT INTO HELP VALUES ('SET', 41, '   HEADS[EP] {||c|OFF|ON}                     {;|c|OFF|ON}');
INSERT INTO HELP VALUES ('SET', 42, '   INSTANCE [instance_path|LOCAL]           SUF[FIX] {SQL|text}');
INSERT INTO HELP VALUES ('SET', 43, '   LIN[ESIZE] {80|n}                        TAB {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 44, '   LOBOF[FSET] {n|1}                        TERM[OUT] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 45, '   LOGSOURCE [pathname]                     TI[ME] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 46, '   LONG {80|n}                              TIMI[NG] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 47, '   LONGC[HUNKSIZE] {80|n}                   TRIM[OUT] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 48, '   MARK[UP] HTML [ON|OFF]                   TRIMS[POOL] {ON|OFF}');
INSERT INTO HELP VALUES ('SET', 49, '     [HEAD text] [BODY text]                UND[ERLINE] {-|c|ON|OFF}');
INSERT INTO HELP VALUES ('SET', 50, '     [ENTMAP {ON|OFF}]                      VER[IFY] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 51, '     [SPOOL {ON|OFF}]                       WRA[P] {OFF|ON}');
INSERT INTO HELP VALUES ('SET', 52, '     [PRE[FORMAT] {ON|OFF}]');
INSERT INTO HELP VALUES ('SET', 53, NULL);
INSERT INTO HELP VALUES ('SET', 54, NULL);
INSERT INTO HELP VALUES ('SET', 55, NULL);
INSERT INTO HELP VALUES ('SHOW', 1, NULL);
INSERT INTO HELP VALUES ('SHOW', 2, ' SHOW');
INSERT INTO HELP VALUES ('SHOW', 3, ' ----');
INSERT INTO HELP VALUES ('SHOW', 4, NULL);
INSERT INTO HELP VALUES ('SHOW', 5, ' Shows the value of a SQL*Plus system variable, or the');
INSERT INTO HELP VALUES ('SHOW', 6, ' current SQL*Plus environment.');
INSERT INTO HELP VALUES ('SHOW', 7, NULL);
INSERT INTO HELP VALUES ('SHOW', 8, ' SHO[W] option');
INSERT INTO HELP VALUES ('SHOW', 9, NULL);
INSERT INTO HELP VALUES ('SHOW', 10, ' where option is one of the following terms or clauses:');
INSERT INTO HELP VALUES ('SHOW', 11, '     system_variable');
INSERT INTO HELP VALUES ('SHOW', 12, '     ALL');
INSERT INTO HELP VALUES ('SHOW', 13, '     BTI[TLE]');
INSERT INTO HELP VALUES ('SHOW', 14, '     ERR[ORS] [{FUNCTION | PROCEDURE | PACKAGE | PACKAGE BODY |');
INSERT INTO HELP VALUES ('SHOW', 15, '       TRIGGER | VIEW | TYPE | TYPE BODY} [schema.]name]');
INSERT INTO HELP VALUES ('SHOW', 16, '     LNO');
INSERT INTO HELP VALUES ('SHOW', 17, '     PARAMETERS [parameter_name]');
INSERT INTO HELP VALUES ('SHOW', 18, '     PNO');
INSERT INTO HELP VALUES ('SHOW', 19, '     REL[EASE]');
INSERT INTO HELP VALUES ('SHOW', 20, '     REPF[OOTER]');
INSERT INTO HELP VALUES ('SHOW', 21, '     REPH[EADER]');
INSERT INTO HELP VALUES ('SHOW', 22, '     SGA');
INSERT INTO HELP VALUES ('SHOW', 23, '     SPOO[L]');
INSERT INTO HELP VALUES ('SHOW', 24, '     SQLCODE');
INSERT INTO HELP VALUES ('SHOW', 25, '     TT[ITLE]');
INSERT INTO HELP VALUES ('SHOW', 26, '     USER');
INSERT INTO HELP VALUES ('SHOW', 27, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 1, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 2, ' SHUTDOWN');
INSERT INTO HELP VALUES ('SHUTDOWN', 3, ' --------');
INSERT INTO HELP VALUES ('SHUTDOWN', 4, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 5, ' Shuts down a currently running Oracle instance, optionally closing');
INSERT INTO HELP VALUES ('SHUTDOWN', 6, ' and dismounting a database.');
INSERT INTO HELP VALUES ('SHUTDOWN', 7, NULL);
INSERT INTO HELP VALUES ('SHUTDOWN', 8, ' SHUTDOWN [ABORT|IMMEDIATE|NORMAL]');
INSERT INTO HELP VALUES ('SHUTDOWN', 9, NULL);
INSERT INTO HELP VALUES ('SPOOL', 1, NULL);
INSERT INTO HELP VALUES ('SPOOL', 2, ' SPOOL');
INSERT INTO HELP VALUES ('SPOOL', 3, ' -----');
INSERT INTO HELP VALUES ('SPOOL', 4, NULL);
INSERT INTO HELP VALUES ('SPOOL', 5, ' Stores query results in an operating system file, or sends the');
INSERT INTO HELP VALUES ('SPOOL', 6, ' file to a printer.');
INSERT INTO HELP VALUES ('SPOOL', 7, NULL);
INSERT INTO HELP VALUES ('SPOOL', 8, ' SPO[OL] [file_name[.ext] | OFF | OUT]');
INSERT INTO HELP VALUES ('SPOOL', 9, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 1, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 2, ' SQLPLUS');
INSERT INTO HELP VALUES ('SQLPLUS', 3, ' -------');
INSERT INTO HELP VALUES ('SQLPLUS', 4, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 5, ' Starts SQL*Plus from the operating system prompt.');
INSERT INTO HELP VALUES ('SQLPLUS', 6, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 7, ' SQLPLUS [ [option] [logon] [start] ]');
INSERT INTO HELP VALUES ('SQLPLUS', 8, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 9, ' where option has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 10, '     - | -? | [ [-M[ARKUP] markup_option] [-R[ESTRICT] level] [-S[ILENT]] ]');
INSERT INTO HELP VALUES ('SQLPLUS', 11, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 12, ' and where markup_option has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 13, '     HTML [ON|OFF] [HEAD text] [BODY text] [ENTMAP {ON|OFF}]');
INSERT INTO HELP VALUES ('SQLPLUS', 14, '       [SPOOL {ON|OFF}]  [PRE[FORMAT] {ON|OFF}]');
INSERT INTO HELP VALUES ('SQLPLUS', 15, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 16, ' and where logon has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 17, '     username[/password][@net_service_name] | / | /NOLOG');
INSERT INTO HELP VALUES ('SQLPLUS', 18, NULL);
INSERT INTO HELP VALUES ('SQLPLUS', 19, ' and where start has the following syntax:');
INSERT INTO HELP VALUES ('SQLPLUS', 20, '     @filename[.ext] [parameter ...]');
INSERT INTO HELP VALUES ('SQLPLUS', 21, NULL);
INSERT INTO HELP VALUES ('START', 1, NULL);
INSERT INTO HELP VALUES ('START', 2, ' START');
INSERT INTO HELP VALUES ('START', 3, ' -----');
INSERT INTO HELP VALUES ('START', 4, NULL);
INSERT INTO HELP VALUES ('START', 5, ' Executes the contents of a command file.');
INSERT INTO HELP VALUES ('START', 6, NULL);
INSERT INTO HELP VALUES ('START', 7, ' STA[RT] file_name[.ext] [arg ...]');
INSERT INTO HELP VALUES ('START', 8, NULL);
INSERT INTO HELP VALUES ('STARTUP', 1, NULL);
INSERT INTO HELP VALUES ('STARTUP', 2, ' STARTUP');
INSERT INTO HELP VALUES ('STARTUP', 3, ' -------');
INSERT INTO HELP VALUES ('STARTUP', 4, NULL);
INSERT INTO HELP VALUES ('STARTUP', 5, ' Starts an Oracle instance with several options, including mounting,');
INSERT INTO HELP VALUES ('STARTUP', 6, ' and opening a database.');
INSERT INTO HELP VALUES ('STARTUP', 7, NULL);
INSERT INTO HELP VALUES ('STARTUP', 8, ' STARTUP [FORCE] [RESTRICT] [PFILE=filename] [EXCLUSIVE]');
INSERT INTO HELP VALUES ('STARTUP', 9, '   [PARALLEL [RETRY]] [SHARED [RETRY]]');
INSERT INTO HELP VALUES ('STARTUP', 10, '   [MOUNT [dbname] | OPEN [open_options] [dbname] | NOMOUNT]');
INSERT INTO HELP VALUES ('STARTUP', 11, NULL);
INSERT INTO HELP VALUES ('STARTUP', 12, ' where open_options has the following syntax:');
INSERT INTO HELP VALUES ('STARTUP', 13, '     READ {ONLY|WRITE [RECOVER]} | RECOVER');
INSERT INTO HELP VALUES ('STARTUP', 14, NULL);
INSERT INTO HELP VALUES ('STORE', 1, NULL);
INSERT INTO HELP VALUES ('STORE', 2, ' STORE');
INSERT INTO HELP VALUES ('STORE', 3, ' -----');
INSERT INTO HELP VALUES ('STORE', 4, NULL);
INSERT INTO HELP VALUES ('STORE', 5, ' Saves attributes of the current SQL*Plus environment in a host');
INSERT INTO HELP VALUES ('STORE', 6, ' operating system file (a command file).');
INSERT INTO HELP VALUES ('STORE', 7, NULL);
INSERT INTO HELP VALUES ('STORE', 8, ' STORE {SET} file_name[.ext] [CRE[ATE]|REP[LACE] | APP[END]]');
INSERT INTO HELP VALUES ('STORE', 9, NULL);
INSERT INTO HELP VALUES ('TIMING', 1, NULL);
INSERT INTO HELP VALUES ('TIMING', 2, ' TIMING');
INSERT INTO HELP VALUES ('TIMING', 3, ' ------');
INSERT INTO HELP VALUES ('TIMING', 4, NULL);
INSERT INTO HELP VALUES ('TIMING', 5, ' Records timing data for an elapsed time period, lists the');
INSERT INTO HELP VALUES ('TIMING', 6, ' current timer''s name and timing data, or lists the number of active');
INSERT INTO HELP VALUES ('TIMING', 7, ' timers.');
INSERT INTO HELP VALUES ('TIMING', 8, NULL);
INSERT INTO HELP VALUES ('TIMING', 9, ' TIMI[NG] [START text|SHOW|STOP]');
INSERT INTO HELP VALUES ('TIMING', 10, NULL);
INSERT INTO HELP VALUES ('TTITLE', 1, NULL);
INSERT INTO HELP VALUES ('TTITLE', 2, ' TTITLE');
INSERT INTO HELP VALUES ('TTITLE', 3, ' ------');
INSERT INTO HELP VALUES ('TTITLE', 4, NULL);
INSERT INTO HELP VALUES ('TTITLE', 5, ' Places and formats a title at the top of each report page.');
INSERT INTO HELP VALUES ('TTITLE', 6, ' Enter TTITLE with no clause to list its current definition.');
INSERT INTO HELP VALUES ('TTITLE', 7, NULL);
INSERT INTO HELP VALUES ('TTITLE', 8, ' The old form of TTITLE is used if only a single word or');
INSERT INTO HELP VALUES ('TTITLE', 9, ' a string in quotes follows the TTITLE command.');
INSERT INTO HELP VALUES ('TTITLE', 10, NULL);
INSERT INTO HELP VALUES ('TTITLE', 11, ' TTI[TLE] [printspec [text|variable] ...] | [OFF|ON]');
INSERT INTO HELP VALUES ('TTITLE', 12, NULL);
INSERT INTO HELP VALUES ('TTITLE', 13, ' where printspec is one or more of the following clauses:');
INSERT INTO HELP VALUES ('TTITLE', 14, NULL);
INSERT INTO HELP VALUES ('TTITLE', 15, '     COL n          LE[FT]        BOLD');
INSERT INTO HELP VALUES ('TTITLE', 16, '     S[KIP] [n]     CE[NTER]      FORMAT text');
INSERT INTO HELP VALUES ('TTITLE', 17, '     TAB n          R[IGHT]');
INSERT INTO HELP VALUES ('TTITLE', 18, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 1, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 2, ' UNDEFINE');
INSERT INTO HELP VALUES ('UNDEFINE', 3, ' --------');
INSERT INTO HELP VALUES ('UNDEFINE', 4, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 5, ' Deletes one or more user variables that you defined either');
INSERT INTO HELP VALUES ('UNDEFINE', 6, ' explicitly (with the DEFINE command), or implicitly (with a START');
INSERT INTO HELP VALUES ('UNDEFINE', 7, ' command argument).');
INSERT INTO HELP VALUES ('UNDEFINE', 8, NULL);
INSERT INTO HELP VALUES ('UNDEFINE', 9, ' UNDEF[INE] variable ...');
INSERT INTO HELP VALUES ('UNDEFINE', 10, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 1, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 2, ' VARIABLE');
INSERT INTO HELP VALUES ('VARIABLE', 3, ' --------');
INSERT INTO HELP VALUES ('VARIABLE', 4, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 5, ' Declares a bind variable that can then be referenced in PL/SQL.');
INSERT INTO HELP VALUES ('VARIABLE', 6, ' VARIABLE with no arguments displays a list of all variables declared');
INSERT INTO HELP VALUES ('VARIABLE', 7, ' in the session. VARIABLE followed by a name lists that variable.');
INSERT INTO HELP VALUES ('VARIABLE', 8, NULL);
INSERT INTO HELP VALUES ('VARIABLE', 9, ' VAR[IABLE] [variable [NUMBER | CHAR | CHAR (n) | NCHAR | NCHAR (n) |');
INSERT INTO HELP VALUES ('VARIABLE', 10, '   VARCHAR2 (n) | NVARCHAR2 (n) | CLOB | NCLOB | REFCURSOR]]');
INSERT INTO HELP VALUES ('VARIABLE', 11, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 1, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 2, ' WHENEVER OSERROR');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 3, ' ----------------');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 4, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 5, ' Exits SQL*Plus if an operating system error occurs,');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 6, ' (such as a file I/O error).');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 7, NULL);
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 8, ' WHENEVER OSERROR {EXIT [SUCCESS|FAILURE|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 9, '                   [COMMIT|ROLLBACK] | CONTINUE [COMMIT|ROLLBACK|NONE]}');
INSERT INTO HELP VALUES ('WHENEVER OSERROR', 10, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 1, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 2, ' WHENEVER SQLERROR');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 3, ' -----------------');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 4, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 5, ' Exits SQL*Plus if a SQL command or PL/SQL block generates an error.');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 6, NULL);
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 7, ' WHENEVER SQLERROR {EXIT [SUCCESS|FAILURE|WARNING|n|variable|:BindVariable]');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 8, '                    [COMMIT|ROLLBACK] | CONTINUE [COMMIT|ROLLBACK|NONE]}');
INSERT INTO HELP VALUES ('WHENEVER SQLERROR', 9, NULL);
INSERT INTO HELP VALUES ('TOPICS', 1, NULL);
INSERT INTO HELP VALUES ('TOPICS', 2, 'Help is available on the following topics:');
INSERT INTO HELP VALUES ('TOPICS', 3, NULL);

COMMIT;
