Rem
Rem $Header: catactx.sql 23-sep-98.16:36:13 dmwong Exp $
Rem
Rem catactx.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998, 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      catactx.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dmwong      08/04/99 - make namespace and context 30 char long
Rem    dmwong      09/23/98 - dictionary views for application context         
Rem    dmwong      09/23/98 - Created
Rem

remark
remark  FAMILY "CONTEXT"
remark
remark  Views for showing information about context namespaces:
remark  SESSION_CONTEXT, ALL_CONTEXT and DBA_CONTEXT
remark
 
create or replace view v_$context as
  select SUBSTR(namespace,1,30) "NAMESPACE", 
         SUBSTR(attribute,1,30) "ATTRIBUTE",
         value "VALUE" from v$context;
drop public synonym v$context;
create public synonym v$context for v_$context;
grant select on v_$context to select_catalog_role;
 
create or replace view gv_$context as
  select  SUBSTR(namespace,1,30) "NAMESPACE", 
         SUBSTR(attribute,1,30)  "ATTRIBUTE",          
         value "VALUE" from gv$context;
drop public synonym gv$context;
create public synonym gv$context for gv_$context;
grant select on gv_$context to select_catalog_role;
 
create or replace view SESSION_CONTEXT
        ( NAMESPACE, ATTRIBUTE, VALUE )
as
select namespace, attribute, value from v_$context
/
comment on table SESSION_CONTEXT is
'Description of all context attributes set under the current session'
/
comment on column SESSION_CONTEXT.NAMESPACE is
'Namespace of the attribute'
/
comment on column SESSION_CONTEXT.ATTRIBUTE is
'Name of the attribute'
/
comment on column SESSION_CONTEXT.VALUE is
'Value of the attribute'
/
create public synonym SESSION_CONTEXT for SESSION_CONTEXT
/
grant select on SESSION_CONTEXT to PUBLIC with grant option
/
create or replace view ALL_CONTEXT
       (NAMESPACE, SCHEMA, PACKAGE)
as
select o.name, c.schema, c.package
from  context$ c, obj$ o
where exists ( select null
               from v$context  v
               where v.namespace = o.name
               and o.obj# = c.obj#
               and o.type# = 44
             )
/
comment on table ALL_CONTEXT is
'Description of all active context namespaces under the current session'
/
comment on column ALL_CONTEXT.NAMESPACE is
'Namespace of the active context'
/
comment on column ALL_CONTEXT.SCHEMA is
'Schema of the designated package'
/
comment on column ALL_CONTEXT.PACKAGE is
'Name of the designated package'
/
drop public synonym ALL_CONTEXT
/
create public synonym ALL_CONTEXT for ALL_CONTEXT
/
grant select on ALL_CONTEXT to PUBLIC with grant option
/
create or replace view DBA_CONTEXT
       (NAMESPACE, SCHEMA, PACKAGE)
as
select o.name, c.schema, c.package
from  context$ c, obj$ o
where c.obj# = o.obj#
and o.type# = 44;
/
comment on table DBA_CONTEXT is
'Description of all context namespace information'
/
comment on column DBA_CONTEXT.NAMESPACE is
'Namespace of the context'
/
comment on column DBA_CONTEXT.SCHEMA is
'Schema of the designated package'
/
comment on column DBA_CONTEXT.PACKAGE is
'Name of the designated package'
/
drop public synonym DBA_CONTEXT
/
create public synonym DBA_CONTEXT for DBA_CONTEXT
/
grant select on DBA_CONTEXT to select_catalog_role
/
 

