#!/bin/sh
#
# @(#)mcp-d.x	1.5 01/02/14
# Copyright (c) 02/14/01 Sun Microsystems, Inc. All Rights Reserved.
#
# Module Configuration Propagation Trigger Module
#


[ use MANAGED-MODULE ]
[ load mcp-m.x ]
[ requires template mcp-models-d ]

persistentSlices = modReg:mcp-modules-registry.dat

#userAccess(%generalUsers,read) = noauth
#userAccess(%generalUsers,write) = noauth
groupAccess(%generalGroups,read) = noauth
groupAccess(%generalGroups,write) = noauth

#
# Define services required by this module
#
_services = { [ use SERVICE ]
    #
    # Standard Bourne Shell
    #
    sh = {
        command = ::shell:pipe:/bin/sh
        max = 1
    }
}

_procedures = {
    [ use PROC ]
    [ source mcp-d.prc ]
}

#
# General Operation
#
_operation = { [ use templates.mcp-models-d.operation ]
    trigger = {
        setActions = *trigger
	setService(trigger) = status
        setCommand(trigger) = mcpTriggerCommand %value
    }
    status = { [ use _procedures ]
        setActions = *query
	setService(query) = _internal
        setCommand(query) = mcpQueryResult %value
    }
}

#
# Publish
#
publish = { [ use _operation ]
    status = {
        operationService = _services.sh
        operationCommand = mcp_publish.sh "%params"
    }
}

#
# Propagate
#
propagate = { [ use _operation ]
    status = {
        operationService = _services.sh
        operationCommand = mcp_propagate.sh "%params"
    }
}

moduleRegistryTable = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = List of currently or previously loaded modules

    moduleRegistryEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY _procedures ]
	type = active
	refreshService = _internal
	refreshCommand = showModuleEntries
	mediumDesc = A currently or previously loaded module
	childDimension = vector
	nameColumn = module
	index = module

	module = { [ use STRING MANAGED-PROPERTY ]
	    shortDesc	= module[+instance]
	    mediumDesc	= module[+instance]
	    fullDesc	= A list currently or previously loaded modules
	}

	parameters = { [ use STRING MANAGED-PROPERTY ]
	    shortDesc	= module parameters
	    mediumDesc	= module parameters
	    fullDesc	= A list of currently or previously loaded module parameters
	}
    }
}
