#
#   File:    fscan-d.x
#   Author:  Tom Yuyitung
#   Version: 1.30 98/11/10 09:54:43     
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#
#   OpenAgent File Scanning Module
#

    [ use MANAGED-MODULE ]
    [ load fscan-v2-m.x ]
    [ requires template fscan-models-d ]
    [ requires package fscan ]

    type = passive
    consoleHint:mediumDesc = base.modules.fscan:moduleDetail

    _procedures = {
	[ use PROC ]
	[ source fscan-d.prc ]
    } 

    fscanstats = { [ use templates.fscan-models-d.fscanstats _procedures ]

        type		= active
        refreshService	= _internal
        refreshCommand	= scanfile 
        initInterval	= 10
        refreshInterval	= 600
	checkCommand	= fscanstat
        checkInterval	= 5

        fileid = {

	    stime = { [ use _procedures ]
            	updateFilter          	= fileTimeFilter
	    }
	}

        filestats = {

	    mtime = { [ use _procedures ]
            	updateFilter          	= fileTimeFilter
	    }

            lengthrate = {
            	type                    = derived
            	refreshTrigger          = length:update
            	refreshService          = _internal
            	refreshCommand          = decayingLinearFit scalar [ valueOf length.0 ]
	    }
        }

	scanTable = {
            scanEntry = { [ use _procedures ]
 
                consoleHint:tableCommands = addrow editrow enable disable unload 

                consoleHint:commandLabel(enable) = base.console.ConsoleGeneric:tableRow.enablePopup

                consoleHint:commandSpec(enable) = requestTableRowOperation %windowID snmp://%targetHost:%targetPort/mod/fscan+%targetInstance/fscanstats/scanTable/scanEntry/rowstatus#%targetFragment enable

                consoleHint:commandLabel(disable) = base.console.ConsoleGeneric:tableRow.disablePopup

                consoleHint:commandSpec(disable) = requestTableRowOperation %windowID snmp://%targetHost:%targetPort/mod/fscan+%targetInstance/fscanstats/scanTable/scanEntry/rowstatus#%targetFragment disable

                consoleHint:commandLabel(unload) = base.console.ConsoleGeneric:tableRow.deletePopup

                consoleHint:commandSpec(unload) = requestTableRowOperation %windowID snmp://%targetHost:%targetPort/mod/fscan+%targetInstance/fscanstats/scanTable/scanEntry/rowstatus#%targetFragment unload
 
 		consoleHint:commandLabel(addrow) = base.console.ConsoleGeneric:tableRow.addPopup

   		consoleHint:commandSpec(addrow) = launchUniqueDialog %windowID .templates.tools.rowadder objectUrl=snmp://%targetHost:%targetPort/mod/fscan+%targetInstance/fscanstats/scanTable/scanEntry#%targetFragment

  		consoleHint:commandLabel(editrow) = base.console.ConsoleGeneric:tableRow.editPopup

                consoleHint:commandSpec(editrow) = launchUniqueDialog %windowID .templates.tools.roweditor objectUrl=snmp://%targetHost:%targetPort/mod/fscan+%targetInstance/fscanstats/scanTable/scanEntry#%targetFragment

                consoleHint:tableHeaderCommands = addrow
 
                globActions          = sync refresh
                globService(sync)    = fscanstats
                globCommand(sync)    = syncPatternList
                globService(refresh) = fscanstats
                globCommand(refresh) = refreshValueAndTrap
 
                rowstatus = { [ use _procedures ]
                    setrowService()  = fscanstats
 
                    setrowActions(active)  = on
                    setrowCommand(on)  = activatePattern %index %rowname
 
                    setrowActions(notInService)  = off
                    setrowCommand(off)  = deactivatePattern %index %rowname
 
                    setrowActions(createAndGo)  = add
                    setrowActions(createAndWait)  = add
                    setrowCommand(add)  = addPattern %index %rowname %newvalue
 
                    setrowActions(destroy)  = remove
                    setrowCommand(remove)  = removePattern %index %rowname
                }
 
                name = {
                    setActions          = update
                    setService(update)  = _superior
                    setCommand(update)  = updateInstances
                }
 
                desc = {
                    access = rw
 
                    validateActions(post)     = verify incrglob
                    validateService(verify)   = _internal
                    validateCommand(verify)   = verifyRowStatus %index %value
 
                    setActions                = *define decrglob
                    setService(define)        = fscanstats
                    setCommand(define)        = setPattern pdescs %rowname %value
                }
 
                pattern = {
                    access = rw
 
                    validateActions(post)     = verify incrglob
                    validateService(verify)   = _internal
                    validateCommand(verify)   = verifyRowStatus %index %value
 
                    setActions                = *define decrglob
                    setService(define)        = fscanstats
                    setCommand(define)        = setPattern patterns %rowname %value
                }

                state = {
                    defaultvalue = on
                }
		matches = { [ use _procedures ]
                    defaultvalue = 0

		    type = active
		    refreshCommand 	= list 0
		    refreshInterval	= 0
                }

                total = { [ use _procedures ]
		    refreshService	= _internal
		    updateFilter	= cleanAcks
                    defaultvalue 	= 0
                }
            }
        }
    }
 
    resetter = { [ use templates.fscan-models-d.resetter ]
        access                  = wo
        setActions              = *reset
        setService(reset)       = fscanstats.scanTable.scanEntry.matches
        setCommand(reset)       = resetMatches %value
    }
 
    [ load fscan-d.def ]

