/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.sess_iiop;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.AuroraServices.Credential;
import oracle.aurora.AuroraServices.PublishingContext;
import oracle.aurora.jndi.orb_dep.Orb;
import oracle.aurora.jndi.sess_iiop.BindingEnumeration;
import oracle.aurora.jndi.sess_iiop.ServiceId;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.jndi.sess_iiop.SessionNameParser;
import oracle.aurora.jndi.sess_iiop.sess_iiopContext;
import org.omg.CORBA.ORB;

public class ServiceCtx
implements sess_iiopContext {
    private static ResourceBundle resMessages = ResourceBundle.getBundle("oracle.aurora.jndi.sess_iiop.Messages");
    private ServiceId id;
    protected Hashtable env;
    protected Hashtable bindings = new Hashtable(5, 0.75f);
    final SessionNameParser parser = new SessionNameParser();
    public static final String THIS_SESSION = ":thisSession";
    public static final String DEFAULT_SESSION = ":default";
    public static final String NON_SSL_CREDENTIAL = "Credential";
    public static final String NON_SSL_LOGIN = "Login";
    public static final String SSL_CREDENTIAL = "SecureCredential";
    public static final String SSL_LOGIN = "SecureLogin";
    public static final String SSL_CLIENT_AUTH = "SslClientAuth";
    public static final Integer SESS_IIOP = new Integer(2);
    public static final Integer IIOP = new Integer(1);
    public static final String SSL_UNDETERMINED = "Undetermined";
    public static final String SSL_30 = "30";
    public static final String SSL_20 = "20";
    public static final String SSL_30_WITH_20_HELLO = "30_WITH_20_HELLO";
    public static final String UNSECURE_CREDENTIAL = "Credential";
    public static final String UNSECURE_LOGIN = "Login";
    public static final String SECURE_CREDENTIAL = "SecureCredential";
    public static final String SECURE_LOGIN = "SecureLogin";
    public static final String CREDENTIAL_AUTHENTICATION = "Credential";
    public static Integer _tpType = new Integer(SESS_IIOP);

    ServiceCtx(Hashtable _env, ServiceId _id) {
        this.env = (Hashtable)_env.clone();
        this.id = _id;
    }

    public Object _lookup(String string) throws NamingException {
        return this._lookup(this.parser.parse(string));
    }

    public Object _lookup(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return this;
        }
        if (name.get(0).indexOf(":") < 0) {
            return this.defaultSession()._lookup(name);
        }
        try {
            Object obj = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                obj = this.bindings.get(name.get(0));
            }
            if (obj == null) {
                throw new NameNotFoundException(name.get(0));
            }
            if (name.size() == 1) {
                return obj;
            }
            return ((SessionCtx)obj)._lookup(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this.env.put(key, value);
    }

    public void bind(String key, Object value) throws NamingException {
        this.bind(this.parser.parse(key), value);
    }

    public void bind(Name name, Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            if (object instanceof SessionCtx) {
                throw new NotContextException(resMessages.getString("ONLY_SESSIONS"));
            }
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                this.bindings.put(name.get(0), object);
            }
        }
        try {
            Context enclosingCtx = (Context)this.bindings.get(name.get(0));
            enclosingCtx.bind(name.getSuffix(1), object);
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    void bindInitialContext(PublishingContext ic) throws NamingException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            boolean firstSession = this.bindings.size() == 0;
            SessionCtx ctx = new SessionCtx(ic, this.env);
            this.bindings.put(THIS_SESSION, ctx);
            if (firstSession) {
                this.bindings.put(DEFAULT_SESSION, ctx);
                this.bindings.put(":" + ic.sessionId(), ctx);
            }
        }
    }

    public void close() throws NamingException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            Enumeration sessions = this.bindings.elements();
            while (sessions.hasMoreElements()) {
                ((Context)sessions.nextElement()).close();
            }
        }
        this.env = null;
        this.bindings = null;
    }

    public String composeName(String name1, String name2) throws NamingException {
        if (name2.equals("")) {
            return name1;
        }
        if (name1.equals("")) {
            return name2;
        }
        return String.valueOf(String.valueOf(name2)) + "/" + name1;
    }

    public Name composeName(Name name1, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name1);
        return name3;
    }

    private SessionCtx createSession() throws NamingException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            boolean firstSession = this.bindings.size() == 0;
            SessionCtx ctx = new SessionCtx(this.env, this.id);
            if (firstSession) {
                this.bindings.put(DEFAULT_SESSION, ctx);
                this.bindings.put(":" + ctx.sessionId(), ctx);
            }
            SessionCtx sessionCtx = ctx;
            Object var3_5 = null;
            return sessionCtx;
        }
    }

    private SessionCtx createSession(Name name) throws NamingException {
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            if (this.bindings.get(name.get(0)) != null) {
                throw new NameAlreadyBoundException(resMessages.getString("NAME_ALREADY_BOUND"));
            }
            try {
                SessionCtx ctx = this.createSession();
                this.bindings.put(name.get(0), ctx);
                SessionCtx sessionCtx = ctx;
                Object var4_6 = null;
                return sessionCtx;
            }
            catch (CommunicationException e) {
                CommunicationException c = new CommunicationException(String.valueOf(resMessages.getString("UNKNOWN_SERVICE")) + name);
                c.setRootCause(e);
                throw c;
            }
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.parser.parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException();
        }
        if (name.get(0).indexOf(":") < 0) {
            return this.defaultSession().createSubcontext(name);
        }
        try {
            SessionCtx ctx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                ctx = (SessionCtx)this.bindings.get(name.get(0));
            }
            if (ctx == null) {
                ctx = this.createSession(name);
            }
            if (name.size() == 1) {
                return ctx;
            }
            return ctx.createSubcontext(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    private synchronized SessionCtx defaultSession() throws NamingException {
        SessionCtx ctx = null;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            ctx = (SessionCtx)this.bindings.get(DEFAULT_SESSION);
        }
        if (ctx != null) {
            return ctx;
        }
        return this.login();
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(this.parser.parse(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        Hashtable hashtable;
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            try {
                Context ctx = null;
                hashtable = this.bindings;
                synchronized (hashtable) {
                    ctx = (Context)this.bindings.remove(name.get(0));
                }
                ctx.close();
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException();
            }
        }
        try {
            Context enclosingCtx = null;
            hashtable = this.bindings;
            synchronized (hashtable) {
                enclosingCtx = (Context)this.bindings.get(name.get(0));
            }
            enclosingCtx.destroySubcontext(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    public boolean equals(Object obj) {
        try {
            ServiceCtx that = (ServiceCtx)obj;
            return this.id.equals(that.id);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private Enumeration getBindings() {
        Vector<Binding> b = null;
        Hashtable hashtable = this.bindings;
        synchronized (hashtable) {
            b = new Vector<Binding>(this.bindings.size());
            Enumeration keys = this.bindings.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object obj = this.bindings.get(key);
                b.addElement(new Binding(key, obj));
            }
        }
        return b.elements();
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot retreive full name");
    }

    public NameParser getNameParser(String arg1) throws NamingException {
        return this.parser;
    }

    public NameParser getNameParser(Name arg1) throws NamingException {
        return this.parser;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static ORB init(String un, String pw, String role, boolean ssl, Properties props) {
        return Orb.init(un, pw, role, ssl, props);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(this.parser.parse(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return new BindingEnumeration(this.getBindings());
        }
        try {
            Context ctx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                ctx = (Context)this.bindings.get(name.get(0));
            }
            return ctx.listBindings(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public synchronized SessionCtx login() throws NamingException {
        SessionCtx ctx = null;
        String auth = (String)this.env.get("java.naming.security.authentication");
        if (auth != null && (auth.equals("Credential") || auth.equals("SecureCredential"))) {
            String username = (String)this.env.get("java.naming.security.principal");
            String password = (String)this.env.get("java.naming.security.credentials");
            String role = (String)this.env.get("oracle.aurora.sess_iiop.role");
            Credential.authenticate(username, password, role);
            return this.createSession();
        }
        ctx = this.createSession();
        if (auth != null && (auth.equals("Login") || auth.equals("SecureLogin"))) {
            if (!ctx.login()) {
                throw new NoPermissionException("Invalid username/password");
            }
            return ctx;
        }
        return ctx;
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(this.parser.parse(string));
    }

    public Object lookup(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            return this;
        }
        if (name.get(0).indexOf(":") < 0) {
            return this.defaultSession().activate(name);
        }
        try {
            Object obj = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                obj = this.bindings.get(name.get(0));
            }
            if (obj == null) {
                throw new NameNotFoundException(name.get(0));
            }
            if (name.size() == 1) {
                return obj;
            }
            return ((SessionCtx)obj).activate(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.toString());
        }
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public String password() {
        return (String)this.env.get("java.naming.security.credentials");
    }

    public void rebind(String string, Object obj) throws NamingException {
        this.rebind(this.parser.parse(string), obj);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            if (object instanceof SessionCtx) {
                throw new NotContextException(resMessages.getString("ONLY_SESSIONS"));
            }
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                this.bindings.put(name.get(0), object);
            }
        }
        try {
            Context enclosingCtx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                enclosingCtx = (Context)this.bindings.get(name.get(0));
            }
            enclosingCtx.rebind(name.getSuffix(1), object);
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        return this.env.remove(key);
    }

    public void rename(String from, String to) throws NamingException {
        this.rename(this.parser.parse(from), this.parser.parse(to));
    }

    public void rename(Name from, Name to) throws NamingException {
        from = this.trim(from);
        to = this.trim(to);
        if (from.size() == 0 || to.size() == 0) {
            throw new InvalidNameException(resMessages.getString("ONE_OR_BOTH_NAMES_EMPTY"));
        }
        Object object = this._lookup(from);
        this.bind(to, object);
        this.unbind(from);
    }

    public String toString() {
        return "ServiceCtx<" + this.id.toString() + '>';
    }

    /*
     * Unable to fully structure code
     */
    private Name trim(Name name) throws NamingException {
        if (name.size() != 0) ** GOTO lbl4
        return name;
lbl-1000:
        // 1 sources

        {
            name = name.getSuffix(1);
lbl4:
            // 2 sources

            ** while (name.size() > 0 && name.get((int)0).equals((Object)""))
        }
lbl5:
        // 1 sources

        return name;
    }

    public void unbind(String string) throws NamingException {
        this.unbind(this.parser.parse(string));
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        if (name.size() == 1) {
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                this.bindings.remove(name.get(0));
            }
        }
        try {
            Context enclosingCtx = null;
            Hashtable hashtable = this.bindings;
            synchronized (hashtable) {
                enclosingCtx = (Context)this.bindings.get(name.get(0));
            }
            enclosingCtx.unbind(name.getSuffix(1));
        }
        catch (ClassCastException classCastException) {
            throw new NotContextException(name.get(0));
        }
    }
}

