/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.parser;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.deployment.AccessControlEntry;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import oracle.aurora.ejb.parser.MethodTable;
import oracle.aurora.ejb.parser.ParseError;
import oracle.aurora.ejb.parser.ParsedAttribute;
import oracle.aurora.ejb.parser.ParsedMethod;
import oracle.aurora.ejb.parser.ParsedNamedProperty;
import oracle.aurora.ejb.parser.ParsedObject;
import oracle.aurora.ejb.parser.Util;

public class ParsedBean
extends ParsedObject {
    String beanType;
    String className;
    Vector attributes;
    Vector namedProperties;
    Vector methods;

    public ParsedBean(String beanType, String className, Vector attributes, Vector namedProperties, Vector methods) {
        this.beanType = beanType;
        this.className = className;
        this.attributes = attributes;
        this.namedProperties = namedProperties;
        this.methods = methods;
    }

    public void addBeanAttributes(Vector methodAttributes, Vector beanAttributes) {
        ParsedAttribute attribute;
        Hashtable<String, ParsedAttribute> methodEntries = new Hashtable<String, ParsedAttribute>();
        int i = 0;
        while (i < methodAttributes.size()) {
            attribute = (ParsedAttribute)methodAttributes.elementAt(i);
            methodEntries.put(attribute.name, attribute);
            ++i;
        }
        i = 0;
        while (i < beanAttributes.size()) {
            attribute = (ParsedAttribute)beanAttributes.elementAt(i);
            if (this.methodAttributeP(attribute.name) && methodEntries.get(attribute.name) == null) {
                methodAttributes.addElement(attribute);
            }
            ++i;
        }
    }

    public void dump(PrintWriter out, int indentation) {
        Util.indent(out, indentation);
        Util.dumpString(out, this.beanType);
        out.print(" ");
        Util.dumpString(out, this.className);
        out.println();
        Util.indent(out, indentation);
        out.println("{");
        Util.dumpVector(out, indentation + 1, this.attributes);
        Util.dumpVector(out, indentation + 1, this.namedProperties);
        Util.dumpVector(out, indentation + 1, this.methods);
        Util.indent(out, indentation);
        out.println("}");
    }

    public static Class findClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        try {
            return loader == null ? Class.forName(name) : loader.loadClass(name);
        }
        catch (ClassNotFoundException e1) {
            try {
                name = "java.lang." + name;
                return loader == null ? Class.forName(name) : loader.loadClass(name);
            }
            catch (Throwable throwable) {
                throw e1;
            }
        }
    }

    public DeploymentDescriptor generateDescriptor(ClassLoader loader) throws Exception {
        if (!this.beanType.equals("SessionBean")) {
            ParseError.NO_SUCH_BEAN_TYPE(this.beanType);
            return null;
        }
        SessionDescriptor descriptor = new SessionDescriptor();
        if (this.className == null) {
            ParseError.MISSING_BEAN_CLASS();
            return null;
        }
        try {
            Class clazz = ParsedBean.findClass(loader, this.className);
        }
        catch (ClassNotFoundException e) {
            ParseError.CANNOT_LOAD_CLASS(e.getMessage());
            return null;
        }
        descriptor.setEnterpriseBeanClassName(this.className);
        Vector<AccessControlEntry> accessVector = new Vector<AccessControlEntry>();
        Vector<ControlDescriptor> controlVector = new Vector<ControlDescriptor>();
        AccessControlEntry access = new AccessControlEntry();
        ControlDescriptor control = new ControlDescriptor();
        accessVector.addElement(access);
        controlVector.addElement(control);
        Util.populateDescriptorsForVector(descriptor, control, access, this.attributes);
        int size = this.namedProperties.size();
        int i = 0;
        while (i < size) {
            ParsedNamedProperty namedProperty = (ParsedNamedProperty)this.namedProperties.elementAt(i);
            namedProperty.populateBeanDescriptor(descriptor);
            ++i;
        }
        if (descriptor.getHomeInterfaceClassName() == null) {
            ParseError.MISSING_HOME_INTERFACE();
        }
        if (descriptor.getRemoteInterfaceClassName() == null) {
            ParseError.MISSING_REMOTE_INTERFACE();
        }
        MethodTable methodTable = this.makeMethodTable(loader, this.className, descriptor.getHomeInterfaceClassName(), descriptor.getRemoteInterfaceClassName());
        size = this.methods.size();
        i = 0;
        while (i < size) {
            ParsedMethod parsedMethod = (ParsedMethod)this.methods.elementAt(i);
            Method method = methodTable.findMethod(parsedMethod);
            access = new AccessControlEntry(method);
            control = new ControlDescriptor(method);
            accessVector.addElement(access);
            controlVector.addElement(control);
            this.addBeanAttributes(parsedMethod.attributes, this.attributes);
            Util.populateDescriptorsForVector(descriptor, control, access, parsedMethod.attributes);
            ++i;
        }
        Object[] accesses = new AccessControlEntry[accessVector.size()];
        accessVector.copyInto(accesses);
        descriptor.setAccessControlEntries((AccessControlEntry[])accesses);
        Object[] controls = new ControlDescriptor[controlVector.size()];
        controlVector.copyInto(controls);
        descriptor.setControlDescriptors((ControlDescriptor[])controls);
        return descriptor;
    }

    MethodTable makeMethodTable(ClassLoader loader, String beanClassName, String homeClassName, String remoteClassName) throws Exception {
        MethodTable methodTable = new MethodTable(loader);
        try {
            methodTable.addMethods(ParsedBean.findClass(loader, beanClassName).getMethods());
            return methodTable;
        }
        catch (ClassNotFoundException e) {
            ParseError.CANNOT_LOAD_CLASS(e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            ParseError.CANNOT_ACCESS_CLASS_METHODS(e.getMessage());
            return null;
        }
    }

    public boolean methodAttributeP(String name) {
        return name.equals("TransactionAttribute") || name.equals("RunAsMode") || name.equals("RunAsIdentity") || name.equals("AllowedIdentities");
    }
}

