/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors;

import com.sun.symon.base.server.common.ScRequestConnector;
import com.sun.symon.base.server.common.ScRequestConnectorInterface;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSource;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.events.SvRequestDispatcher;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.receptors.SrSession;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.io.PrintWriter;
import java.util.Date;

public class SrRequest
extends ScRequestSource {
    private SrSession session;
    private SvRequestDispatcher dispatcher;
    private boolean deleted;
    private boolean deleteSuper;
    private boolean autoDelete;
    private SrRequest next;
    private SrRequest prev;
    private SvRequestEvent event;
    private static final int DATA = UcDDL.createChannel((String)"data");
    private static int count = 0;
    private int thecount = 0;
    private int numReplies;
    private Date waitingForClient;
    private Date start;
    private static Object lock = new Object();

    SrRequest(SrSession srSession, SrRequest srRequest, String string, ScSecurityCredential scSecurityCredential, int n, String[] stringArray, StObject[][] stObjectArray) {
        Object object = lock;
        synchronized (object) {
            this.thecount = ++count;
        }
        if (UcDDL.channelIsActive((int)DATA)) {
            object = lock;
            synchronized (object) {
                UcDDL.logMessage((int)DATA, (String)("New request #" + this.thecount));
                UcDDL.logMessage((int)DATA, (String)("    session=" + srSession));
                UcDDL.logMessage((int)DATA, (String)("    period='" + string + "'"));
                String string2 = this.getCmdString(n);
                UcDDL.logMessage((int)DATA, (String)("    command=" + n + " (" + string2 + ")"));
                int n2 = 0;
                while (n2 < stringArray.length) {
                    UcDDL.logMessage((int)DATA, (String)("    url[" + n2 + "]='" + stringArray[n2] + "'"));
                    ++n2;
                }
                this.logData("requestData", stObjectArray);
            }
        }
        this.session = srSession;
        this.dispatcher = srSession.getReceptor().getRequestDispatcher();
        this.deleted = false;
        this.deleteSuper = false;
        this.autoDelete = string == null;
        this.event = new SvRequestEvent((Object)this, n, stringArray, stObjectArray, string, scSecurityCredential, (ScRequestConnectorInterface)new ScRequestConnector(this));
        this.prev = null;
        this.next = srRequest;
        if (srRequest != null) {
            srRequest.prev = this;
        }
        this.numReplies = 0;
        this.waitingForClient = null;
        this.start = new Date();
    }

    private boolean containsBinary(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by < 32 || by > 126) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void delete() {
        boolean bl;
        UcDDL.logMessage((int)DATA, (String)("Request #" + this.thecount + " deleted"));
        SrSession srSession = this.session;
        synchronized (srSession) {
            bl = this.deleted;
            if (!bl) {
                this.deleteMark();
            }
        }
        if (!bl) {
            this.deleteDirect();
            srSession = this.session;
            synchronized (srSession) {
                if (this.prev != null) {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.session.requestDone(this);
            }
        }
    }

    void deleteDirect() {
        UcDDL.logMessage((int)DATA, (String)("Request #" + this.thecount + " deleteDirect"));
        if (this.deleteSuper) {
            super.delete();
        }
    }

    void deleteMark() {
        this.deleted = true;
        this.deleteSuper = this.isConnected();
    }

    void dispatch() {
        try {
            if (ScRequestConnector.dispatch(this.dispatcher, this.event) == null) {
                this.respond(null, new ScResponseException("URL not processed by server", 2));
                this.delete();
            }
        }
        catch (ScRequestDispatchException scRequestDispatchException) {
            ScResponseException scResponseException = null;
            scResponseException = scRequestDispatchException.getStatus() > 0 ? new ScResponseException(scRequestDispatchException.getMessage(), scRequestDispatchException.getStatus()) : new ScResponseException(scRequestDispatchException.getMessage(), 3);
            this.respond(scRequestDispatchException.getUrl(), scResponseException);
            this.delete();
        }
    }

    void dump(PrintWriter printWriter) {
        printWriter.println("    ---------------------------------------");
        int n = this.event.getCommand();
        String string = this.getCmdString(n);
        printWriter.println("    cmd=" + n + " (" + string + ")");
        long l = (new Date().getTime() - this.start.getTime()) / 1000L;
        printWriter.println("    birth=" + this.start + " (" + l + " seconds ago)");
        printWriter.println("    period=" + this.event.getPeriod());
        printWriter.println("    scheme=" + this.event.getScheme());
        String[] stringArray = this.event.getURL();
        int n2 = 0;
        while (n2 < stringArray.length) {
            printWriter.println("    url[" + n2 + "]='" + stringArray[n2] + "'");
            ++n2;
        }
        printWriter.println("    numReplies=" + this.numReplies);
        long l2 = this.waitingForClient == null ? 0L : (new Date().getTime() - this.waitingForClient.getTime()) / 1000L;
        printWriter.println("    waitingForClient=" + this.waitingForClient + (this.waitingForClient == null ? "" : " (" + l2 + " seconds ago)"));
    }

    public void emit() {
        if (this.isConnected()) {
            boolean bl;
            SrSession srSession = this.session;
            synchronized (srSession) {
                bl = this.deleted;
            }
            if (bl) {
                if (!this.deleteSuper) {
                    super.delete();
                }
            } else {
                super.emit();
            }
        }
    }

    private String getCmdString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "SET";
                break;
            }
            case 1: {
                string = "GET";
                break;
            }
            case 2: {
                string = "GET_NEXT";
                break;
            }
            case 6: {
                string = "GET_BULK";
                break;
            }
            default: {
                string = "???";
            }
        }
        return string;
    }

    final SrRequest getNext() {
        return this.next;
    }

    private void logData(String string, StObject[][] stObjectArray) {
        if (stObjectArray == null) {
            UcDDL.logMessage((int)DATA, (String)("    " + string + "=null"));
        } else {
            int n = 0;
            while (n < stObjectArray.length) {
                if (stObjectArray[n] == null) {
                    UcDDL.logMessage((int)DATA, (String)("    " + string + "[" + n + "]=null"));
                } else {
                    int n2 = 0;
                    while (n2 < stObjectArray[n].length) {
                        StObject stObject = stObjectArray[n][n2];
                        String string2 = "'" + stObject.toString() + "'";
                        int n3 = string2.length() - 2;
                        if (n3 > 50 || this.containsBinary(string2)) {
                            string2 = "... (" + n3 + " bytes)";
                        }
                        UcDDL.logMessage((int)DATA, (String)("    " + string + "[" + n + "][" + n2 + "]=" + string2));
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public void respond(String string, ScResponseException scResponseException) {
        if (UcDDL.channelIsActive((int)DATA)) {
            Object object = lock;
            synchronized (object) {
                UcDDL.logMessage((int)DATA, (String)("Request #" + this.thecount + " exception"));
                UcDDL.logMessage((int)DATA, (String)("    url='" + string + "'"));
                UcDDL.logMessage((int)DATA, (String)("    responseException='" + scResponseException + "'"));
            }
        }
        UcDDL.logWarningMessage((String)("Sent to client: " + scResponseException.toString() + " (for " + string + ")"));
        ++this.numReplies;
        this.waitingForClient = new Date();
        this.session.requestResponse(this, string, scResponseException);
        this.waitingForClient = null;
        if (this.autoDelete) {
            this.delete();
        }
    }

    public void respond(StObject[][] stObjectArray) {
        if (UcDDL.channelIsActive((int)DATA)) {
            Object object = lock;
            synchronized (object) {
                UcDDL.logMessage((int)DATA, (String)("Request #" + this.thecount + " response"));
                this.logData("responseData", stObjectArray);
            }
        }
        ++this.numReplies;
        this.waitingForClient = new Date();
        this.session.requestResponse(this, stObjectArray);
        this.waitingForClient = null;
        if (this.autoDelete) {
            this.delete();
        }
    }
}

