/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.task.MtExecPool;
import com.sun.symon.base.mgmtservice.task.MtTaskRequest;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestController;
import com.sun.symon.base.mgmtservice.task.MtTaskRunner;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

public class MtTaskRequestQueue {
    public static final int MAX_DELAY = 10000;
    public static final int MIN_DELAY = 400;
    public static final MtTaskRequestQueue theTimerQueue = new MtTaskRequestQueue();
    static MSLogPrintWriter logWriter = MtTaskRequestController.getInstance().getRequestLogWriter();
    MtExecPool pool;
    LinkedList timerQueue = new LinkedList();
    ExecThread execThread = new ExecThread();
    Hashtable executed;

    private MtTaskRequestQueue() {
        this.pool = MtExecPool.getExecPool();
        this.executed = new Hashtable();
    }

    public void add(MtTaskRequest mtTaskRequest) {
        long l = new Date().getTime();
        boolean bl = false;
        boolean bl2 = false;
        if (!mtTaskRequest.reschedule()) {
            return;
        }
        long l2 = mtTaskRequest.getExecTime();
        LinkedList linkedList = this.timerQueue;
        synchronized (linkedList) {
            if (mtTaskRequest.isScheduled() && !mtTaskRequest.isSuspended()) {
                if (this.timerQueue.size() == 0) {
                    this.timerQueue.addFirst(mtTaskRequest);
                    bl = true;
                    bl2 = true;
                } else {
                    ListIterator listIterator = this.timerQueue.listIterator(0);
                    while (listIterator.hasNext()) {
                        MtTaskRequest mtTaskRequest2 = (MtTaskRequest)((Object)listIterator.next());
                        if (mtTaskRequest2.getExecTime() <= l2) continue;
                        int n = listIterator.previousIndex();
                        if (n < 0) {
                            bl = true;
                            bl2 = true;
                            this.timerQueue.addFirst(mtTaskRequest);
                            break;
                        }
                        this.timerQueue.add(n, mtTaskRequest);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.timerQueue.addLast(mtTaskRequest);
                    }
                }
            }
        }
    }

    public synchronized void delete(SMDBObjectID sMDBObjectID) {
        if (this.remove(sMDBObjectID)) {
            return;
        }
        Hashtable hashtable = this.executed;
        synchronized (hashtable) {
            Object v = this.executed.get(sMDBObjectID);
            if (v != null) {
                MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)v);
                mtTaskRequest.setMarkForDeletion();
            }
        }
    }

    public static MtTaskRequestQueue getTimerQueue() {
        return theTimerQueue;
    }

    public synchronized boolean remove(SMDBObjectID sMDBObjectID) {
        int n = 0;
        ListIterator listIterator = this.timerQueue.listIterator(0);
        while (listIterator.hasNext()) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            if (mtTaskRequest.equals(sMDBObjectID)) {
                this.timerQueue.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public void requestDone(SMDBObjectID sMDBObjectID) {
        this.executed.remove(sMDBObjectID);
    }

    public synchronized boolean resume(SMDBObjectID sMDBObjectID) {
        MtTaskRequest mtTaskRequest;
        MtTaskRequest mtTaskRequest2 = null;
        ListIterator listIterator = this.timerQueue.listIterator(0);
        int n = 0;
        while (listIterator.hasNext()) {
            mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            if (mtTaskRequest.equals(sMDBObjectID)) {
                mtTaskRequest2 = mtTaskRequest;
                return true;
            }
            ++n;
        }
        mtTaskRequest = this.executed.get(sMDBObjectID);
        if (mtTaskRequest != null) {
            mtTaskRequest2 = mtTaskRequest;
            if (mtTaskRequest2.isSuspended()) {
                mtTaskRequest2.resetSuspended();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean suspend(SMDBObjectID sMDBObjectID) {
        MtTaskRequest mtTaskRequest;
        MtTaskRequest mtTaskRequest2 = null;
        ListIterator listIterator = this.timerQueue.listIterator(0);
        int n = 0;
        while (listIterator.hasNext()) {
            mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            if (mtTaskRequest.equals(sMDBObjectID)) {
                mtTaskRequest2 = mtTaskRequest;
                this.timerQueue.remove(n);
                break;
            }
            ++n;
        }
        if (mtTaskRequest2 == null && (mtTaskRequest = this.executed.get(sMDBObjectID)) != null) {
            mtTaskRequest2 = mtTaskRequest;
        }
        if (mtTaskRequest2 != null) {
            mtTaskRequest2.setSuspended();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Timer Queue");
        ListIterator listIterator = this.timerQueue.listIterator(0);
        while (listIterator.hasNext()) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            stringBuffer.append(mtTaskRequest.toString());
        }
        return stringBuffer.toString();
    }

    class ExecThread
    extends Thread {
        ExecThread() {
            super("RequestThread");
            this.start();
        }

        public void run() {
            while (true) {
                MtTaskRequest mtTaskRequest;
                int n = 10000;
                long l = new Date().getTime();
                boolean bl = true;
                if (MtTaskRequestQueue.this.timerQueue.size() > 0 && (mtTaskRequest = (MtTaskRequest)((Object)MtTaskRequestQueue.this.timerQueue.getFirst())).getExecTime() - l <= 0L) {
                    MtTaskRunner mtTaskRunner = MtTaskRequestQueue.this.pool.getTaskRunner();
                    if (mtTaskRunner != null) {
                        MtTaskRequestQueue.this.timerQueue.removeFirst();
                        MtTaskRequestQueue.this.executed.put(mtTaskRequest.getObjectID(), mtTaskRequest);
                        mtTaskRunner.delegate(mtTaskRequest);
                    } else {
                        bl = false;
                        logWriter.println("There is no available execution thread");
                    }
                }
                if (MtTaskRequestQueue.this.timerQueue.size() > 0) {
                    mtTaskRequest = (MtTaskRequest)((Object)MtTaskRequestQueue.this.timerQueue.getFirst());
                    long l2 = mtTaskRequest.getExecTime() - l;
                    if (l2 > 10000L) {
                        n = 10000;
                    } else if (l2 <= 0L) {
                        n = 0;
                        if (!bl) {
                            n = 400;
                        }
                    } else {
                        n = (int)l2;
                    }
                }
                try {
                    if (n <= 0) continue;
                    Thread.sleep(n);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

