/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.mcp;

import com.sun.symon.base.mgmtservice.mcp.MmMultipartRequest;
import com.sun.symon.base.mgmtservice.mcp.MmServletConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MmMCPServlet
extends HttpServlet {
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block9: {
            block10: {
                if (httpServletRequest.getContentType() != null && !"application/x-www-form-urlencoded".equals(httpServletRequest.getContentType())) break block10;
                String string = this.getParam(httpServletRequest, "id");
                if (string.equals("")) {
                    String string2 = "access denied";
                    this.log(string2);
                    httpServletResponse.sendError(403, string2);
                    return;
                }
                String string3 = this.getParam(httpServletRequest, "path");
                if (string3.equals("")) {
                    String string4 = "no file specified";
                    this.log(string4);
                    httpServletResponse.sendError(400, string4);
                    return;
                }
                boolean bl = this.isAllowed(string, string3, httpServletRequest);
                if (!bl) {
                    String string5 = "access denied " + string + " " + string3 + " " + httpServletRequest.getRemoteAddr();
                    this.log(string5);
                    httpServletResponse.sendError(403, string5);
                    return;
                }
                String string6 = String.valueOf(MmServletConfig.getParcelDir()) + "/" + string3;
                String string7 = this.getServletContext().getMimeType(string6);
                httpServletResponse.setContentType(string7);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                try {
                    this.returnFile(string6, (OutputStream)servletOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    httpServletResponse.setContentType("text/html");
                    String string8 = "File not found: " + string6;
                    this.log(string8);
                    httpServletResponse.sendError(404, string8);
                }
                catch (IOException iOException) {
                    httpServletResponse.setContentType("text/html");
                    this.log("Problem sending file", iOException);
                    httpServletResponse.sendError(500, iOException.getMessage());
                }
                break block9;
            }
            if (!httpServletRequest.getContentType().startsWith("multipart/form-data")) break block9;
            try {
                String string = MmServletConfig.getParcelDir();
                MmMultipartRequest mmMultipartRequest = new MmMultipartRequest(httpServletRequest, string, 0x500000, this);
                httpServletResponse.setContentType("text/plain");
                PrintWriter printWriter = httpServletResponse.getWriter();
                Enumeration enumeration = mmMultipartRequest.getFileNames();
                while (enumeration.hasMoreElements()) {
                    String string9 = (String)enumeration.nextElement();
                    String string10 = mmMultipartRequest.getContentType(string9);
                    File file = mmMultipartRequest.getFile(string9);
                    printWriter.println("key: " + string9);
                    printWriter.println("type: " + string10);
                    if (file == null) continue;
                    printWriter.println("filename: " + file.getAbsolutePath());
                    printWriter.println("length: " + file.length());
                    printWriter.println();
                    this.log(String.valueOf(httpServletRequest.getRemoteAddr()) + ": uploaded " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
                }
            }
            catch (Exception exception) {
                httpServletResponse.sendError(403, exception.getMessage());
            }
        }
    }

    private void dumpParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            if (stringArray.length > 0) {
                printWriter.println(String.valueOf(string) + ": " + stringArray[0]);
                continue;
            }
            printWriter.println(String.valueOf(string) + ": ");
        }
    }

    private String getParam(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray == null) {
            return "";
        }
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    private String getParcelNameFromPath(String string) {
        int n;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(47)) > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    boolean isAllowed(String string, String string2, HttpServletRequest httpServletRequest) {
        String string3 = this.getParcelNameFromPath(string2);
        return MmServletConfig.isAllowed(string, string3, httpServletRequest.getRemoteAddr());
    }

    private void returnFile(String string, OutputStream outputStream) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            Object var5_6 = null;
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }
}

