/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CvTblNumberField
extends JTextField {
    protected Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter;
    private boolean isFloat;
    private WholeNumberDocument numberDoc;

    public CvTblNumberField(int n) {
        super(n);
    }

    public CvTblNumberField(int n, boolean bl) {
        super(n);
        this.integerFormatter = NumberFormat.getNumberInstance(Locale.US);
        this.isFloat = bl;
        this.numberDoc.setIsFloat(bl);
        if (!bl) {
            this.integerFormatter.setParseIntegerOnly(true);
        }
    }

    protected Document createDefaultModel() {
        this.numberDoc = new WholeNumberDocument();
        return this.numberDoc;
    }

    public Number getValue() {
        Number number = null;
        try {
            number = this.integerFormatter.parse(this.getText());
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return number;
    }

    public void setValue(Float f) {
        if (!this.isFloat) {
            return;
        }
        if (f != null) {
            this.setText(this.integerFormatter.format(f.floatValue()));
        }
    }

    public void setValue(Integer n) {
        if (n != null) {
            this.setText(this.integerFormatter.format(n.intValue()));
        }
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        boolean isFloat = false;

        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (Character.isDigit(cArray[n3])) {
                    cArray2[n2++] = cArray[n3];
                } else if (this.isFloat && cArray[n3] == '.') {
                    cArray2[n2++] = cArray[n3];
                } else if (cArray[n3] == '-') {
                    cArray2[n2++] = cArray[n3];
                } else {
                    CvTblNumberField.this.toolkit.beep();
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }

        public void setIsFloat(boolean bl) {
            this.isFloat = bl;
        }
    }
}

