/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.console.views.graph.CvGraphYAxisFormat;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;

public class CvGraphXAxisFormat
extends CvGraphYAxisFormat {
    protected static final int DEFAULT_MINUTES_TO_DISPLAY = 60;
    private int minutesToDisplay = 60;

    public CvGraphXAxisFormat() {
        this.setupXAxis();
    }

    public String getConfiguration() {
        return "XAxis^" + this.getAutoScale() + "^" + this.getMinutesToDisplay() + "^" + this.getTickSpacing() + "^" + this.getGridSpacing();
    }

    public int getMinutesToDisplay() {
        return this.minutesToDisplay;
    }

    public void setConfiguration(String string) throws CvGraphInvalidInputException {
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 5) {
            UcDDL.logDebugMessage((String)("CvGraphXAxisFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("XAxis")) {
            UcDDL.logDebugMessage((String)("CvGraphXAxisFormat::setConfiguration - invalid format keyword '" + stringArray[0] + "'"));
            return;
        }
        this.setAutoScale(Boolean.valueOf(stringArray[1]));
        if (this.autoScale) {
            return;
        }
        try {
            this.setMinutesToDisplay(Integer.valueOf(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphXAxisFormat::setConfiguration -- invalid minutes , replaced by default");
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidMinutes");
            throw new CvGraphInvalidInputException(string2);
        }
        try {
            this.setTickSpacing(Double.valueOf(stringArray[3]));
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid Max , replaced by default");
            String string3 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidTickSpacing");
            throw new CvGraphInvalidInputException(string3);
        }
        try {
            double d = Double.valueOf(stringArray[4]);
            if (d <= 0.0) {
                String string4 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:non-positiveGrid");
                throw new CvGraphInvalidInputException(string4);
            }
            this.setGridSpacing(d);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)"CvGraphYAxisFormat::setConfiguration -- invalid grid spacing, replaced by default");
            String string5 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidGridSpacing");
            throw new CvGraphInvalidInputException(string5);
        }
    }

    public void setMinutesToDisplay(int n) {
        this.minutesToDisplay = n > 0 ? n : 60;
    }

    private void setupXAxis() {
        this.setGridSpacing(10.0);
        this.setMinutesToDisplay(60);
        this.setTickSpacing(10.0);
        this.setAutoScale(true);
    }
}

