/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.console.tools.editor.CtActionBoolean;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.console.tools.editor.CtResetListener;
import com.sun.symon.base.console.tools.editor.CtSaveEvent;
import com.sun.symon.base.console.tools.editor.CtSaveListener;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CtActionField
extends JTextField
implements FocusListener,
CtFocusTraversable,
CtResetListener,
CtSaveListener,
DocumentListener {
    private CtAttributeEditor theEditor;
    private String key;
    private boolean access;
    private String newValue = "";
    private String currentGroupKey = "";
    private boolean lastEditable = false;
    private boolean changed = false;
    private boolean hasFocus = false;
    private Vector focusListener = new Vector();
    private Vector textListener = new Vector();
    private JButton actionButton;
    private CtActionBoolean actionBoolean;
    private SMRawDataRequest rawReq = null;
    private UcURL url = null;
    private String initialActionValue = "";
    private boolean initialManualValue = true;
    private String action;
    private String hostPort;
    private String agentHost;
    private int agentPort;

    public CtActionField(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor, boolean bl) {
        this.theEditor = ctAttributeEditor;
        this.initialManualValue = false;
        this.action = sMAttributeEntryData.getValue();
        this.getActionType(this.action);
        this.url = new UcURL(this.theEditor.getEditObject());
        this.rawReq = this.theEditor.getDataSource();
        this.agentHost = this.url.getHost();
        this.agentPort = Integer.parseInt(this.url.getPort());
        this.currentGroupKey = string;
        this.key = sMAttributeEntryData.getKey();
        this.access = sMAttributeEntryData.getAccess();
        this.setText(this.initialActionValue);
        this.setEditable(false);
        if (!this.access) {
            this.getCaret().setVisible(false);
        }
        if (this.access) {
            this.addFocusListener(this);
            this.getDocument().addDocumentListener(this);
            this.theEditor.addCtResetListener(this);
            this.theEditor.addCtSaveListener(this);
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CtActionField.this.transferFocus();
            }
        });
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void attributeReset(CtResetEvent ctResetEvent) {
        this.newValue = this.initialActionValue;
        this.setText(this.newValue);
        this.resetColors();
        this.changed = false;
    }

    public void attributeSaved(CtSaveEvent ctSaveEvent) {
        this.newValue = this.getText();
        this.initialActionValue = this.getText();
        this.resetColors();
        this.changed = false;
        this.validate();
        this.repaint();
        super.repaint();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateSaveData(false);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.hasFocus) {
            this.selectAll();
            this.requestFocus();
            this.getCaret().setVisible(true);
            this.notifyFocusChange();
            this.hasFocus = true;
            this.setScrollOffset(0);
            this.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.getCaret().setVisible(false);
            this.hasFocus = false;
            this.setScrollOffset(0);
            this.repaint();
        }
    }

    public String getActionCommand() {
        return this.action;
    }

    public void getActionType(String string) {
        if (string != null && string.compareTo("") != 0) {
            string.replace('\t', ' ');
            this.initialManualValue = string.startsWith("A");
            this.action = string.substring(2);
            this.initialActionValue = this.action.replace(':', ' ');
        }
    }

    public String getHost() {
        return this.agentHost;
    }

    public boolean getInitialManualValue() {
        return this.initialManualValue;
    }

    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public int getPort() {
        return this.agentPort;
    }

    public SMRawDataRequest getRawReqest() {
        return this.rawReq;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateSaveData(false);
    }

    public boolean isFocusTraversable() {
        return this.access;
    }

    public boolean isRequestFocusEnabled() {
        return this.access;
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtActionField ctActionField = this;
        synchronized (ctActionField) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.theEditor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateSaveData(false);
    }

    private void resetColors() {
        this.setForeground(this.theEditor.getAttValueForeground());
        this.setBackground(this.theEditor.getAttValueBackground());
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setComps(JButton jButton, CtActionBoolean ctActionBoolean) {
        this.actionButton = jButton;
        this.actionBoolean = ctActionBoolean;
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("base.console.tools.editor.ActionLabels:" + string));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateSaveData(boolean bl) {
        if (!bl) {
            this.changed = true;
            this.setForeground(this.theEditor.getEditedForeground());
            this.theEditor.notifyEdited();
            this.setScrollOffset(0);
            this.invalidate();
            this.validate();
            this.repaint();
        }
        String string = this.actionBoolean.isSelected() ? "A" : "M";
        this.newValue = new String(String.valueOf(string) + ":" + this.action);
        SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.currentGroupKey, this.key, this.newValue);
        this.theEditor.updateSaveData(sMAttributeUpdateData);
    }
}

