/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.console.main.ConsoleLoginPanel;
import com.sun.symon.base.console.main.TNGConsoleLoginRunner;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;

public class TNGConsoleLoginPanel
extends ConsoleLoginPanel {
    String detailHost;
    String remoteHost;
    String remotePort;

    public TNGConsoleLoginPanel(JFrame jFrame, String string, String string2, String string3, String string4) {
        super(jFrame, false, string3, true);
        this.detailHost = string4;
        this.remoteHost = string;
        this.remotePort = string2;
        try {
            this.hostPort = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:badport", (boolean)true);
            this.showInvalidInfoDialog(string5);
            System.exit(0);
        }
    }

    public void build() {
        super.createStatusBox();
        super.setTitle();
        super.layoutMainPanel();
        super.layoutButtons();
        super.addExitButton();
        this.loginIDTextfield.requestFocus();
    }

    protected void enableButtons(boolean bl) {
        this.loginButt.setEnabled(bl);
        this.exitButt.setEnabled(bl);
    }

    protected void handleBootException(BsRMIBootstrapException bsRMIBootstrapException) {
        String string = null;
        switch (bsRMIBootstrapException.getReason()) {
            case 1: {
                string = "remoteex";
                break;
            }
            case 2: {
                string = "registryex";
                break;
            }
            case 3: {
                string = "unboundex";
                break;
            }
            case 4: {
                string = "invalidurlex";
                break;
            }
            case 5: {
                string = "unexpectedex(" + bsRMIBootstrapException.getMessage() + ")";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 17: {
                string = "sessionlimitex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 6: {
                string = "rejectex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 7: {
                string = "unknownex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 8: {
                string = "logerrorex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 12: {
                string = "nosecurityex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 13: {
                string = "logtimeoutex";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 14: {
                string = "loginvaliduser";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 16: {
                string = "loginvalidpassword";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 15: {
                string = "logunknownuser";
                this.loginIDTextfield.requestFocus();
                break;
            }
            case 9: {
                string = "classex";
                break;
            }
            case 10: {
                string = "initex";
                break;
            }
            case 11: {
                string = "bootex";
                break;
            }
        }
        String string2 = bsRMIBootstrapException.getReason() == 2 ? String.valueOf(UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:" + string), (boolean)true)) + " " + this.hostPort : UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:" + string), (boolean)true);
        this.showInvalidInfoDialog(string2);
        this.statusMesg.setText("");
        this.frame.repaint();
    }

    protected void handleButtonPress(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.exitButt) {
            System.exit(0);
        }
        if (object == this.loginIDTextfield) {
            this.loginIDTextfield.transferFocus();
            return;
        }
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.frame.getToolkit().sync();
        if (this.loginIDTextfield.getText().trim().length() == 0) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needid", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.loginIDTextfield.requestFocus();
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        if (this.passwordField.getText().length() == 0) {
            String string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:needpw", (boolean)true);
            this.showInvalidInfoDialog(string);
            this.passwordField.requestFocus();
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getToolkit().sync();
            return;
        }
        this.loginButt.setEnabled(false);
        this.exitButt.setEnabled(false);
        TNGConsoleLoginRunner tNGConsoleLoginRunner = new TNGConsoleLoginRunner(this);
        tNGConsoleLoginRunner.start();
    }
}

