/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.didgets;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CdModuleSelect
extends JList
implements ListSelectionListener,
AwxServiceManager {
    private String AgentHost = null;
    private int AgentPort = 161;
    private SMModuleRequest ModuleHandle = null;
    private AwxServiceProvider SvcProvider = null;
    private String[][] ModuleInfo = null;

    public CdModuleSelect() {
        this.addListSelectionListener(this);
        this.setSelectionMode(0);
    }

    public void init() {
        try {
            this.ModuleInfo = this.ModuleHandle.getLoadedModuleInfo(this.AgentHost, this.AgentPort);
        }
        catch (SMAPIException sMAPIException) {
            String[] stringArray = new String[]{"base.console.ConsoleMessages:modlist.fail"};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        String[] stringArray = new String[this.ModuleInfo.length];
        int n = 0;
        while (n < this.ModuleInfo.length) {
            stringArray[n] = this.ModuleInfo[n][0];
            ++n;
        }
        this.setListData(stringArray);
        this.revalidate();
        this.repaint();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() > 1 && this.getSelectedIndex() >= 0) {
            this.SvcProvider.triggerService("doubleSelect");
        }
        super.processMouseEvent(mouseEvent);
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void setAgentHost(String string) {
        this.AgentHost = string;
    }

    public void setAgentPort(int n) {
        this.AgentPort = n;
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.ModuleHandle = new SMModuleRequest(sMRawDataRequest);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n < 0) {
            this.SvcProvider.triggerService("deselect");
        } else {
            this.SvcProvider.triggerService("select");
            String[] stringArray = new String[]{this.ModuleInfo[n][0]};
            this.SvcProvider.triggerService("selectName", stringArray);
            stringArray = new String[]{this.ModuleInfo[n][1]};
            this.SvcProvider.triggerService("selectUrl", stringArray);
        }
    }
}

