/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import com.sun.symon.tools.migration.TmDuplicateObjectException;
import com.sun.symon.tools.migration.TmNoSuchObjectException;
import com.sun.symon.tools.migration.datasource.MdAttribute;
import com.sun.symon.tools.migration.datasource.MdDataSourceProperties;
import com.sun.symon.tools.migration.datasource.MdTable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MdTableSpace
implements Serializable {
    private static final Hashtable tableSpaces = new Hashtable();
    private String name;
    private MdDataSourceProperties dataSourceProperties;
    private final Vector tables = new Vector();

    private MdTableSpace(String string, String string2, MdDataSourceProperties mdDataSourceProperties) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = string;
        this.dataSourceProperties = mdDataSourceProperties == null ? new MdDataSourceProperties(string2) : new MdDataSourceProperties(mdDataSourceProperties);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MdTableSpace && ((MdTableSpace)object).getQualifiedName().equals(this.getQualifiedName());
    }

    public static MdTableSpace getInstance(String string) throws TmNoSuchObjectException {
        MdTableSpace mdTableSpace = (MdTableSpace)tableSpaces.get(string);
        if (mdTableSpace == null) {
            throw new TmNoSuchObjectException(string, "table space doesn't exist");
        }
        return mdTableSpace;
    }

    public static MdAttribute getMdAttribute(String string) throws TmNoSuchObjectException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                throw new TmNoSuchObjectException(string, "invalid format, expected: tablespace.table.attribute");
            }
            MdAttribute mdAttribute = MdTableSpace.getInstance(string2).getMdTable(string3).getMdAttribute(string4);
            if (mdAttribute == null) {
                throw new TmNoSuchObjectException(string, "attribute doesn't exist");
            }
            return mdAttribute;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new TmNoSuchObjectException(string, "invalid format, expected: tablespace.table.attribute");
        }
        catch (NullPointerException nullPointerException) {
            throw new TmNoSuchObjectException(string, "attribute doesn't exist");
        }
    }

    public MdDataSourceProperties getMdDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public MdTable getMdTable(int n) {
        return (MdTable)this.tables.elementAt(n);
    }

    public MdTable getMdTable(String string) {
        int n = this.indexOfMdTable(string);
        if (n >= 0) {
            return this.getMdTable(n);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.name;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public int indexOfMdTable(String string) {
        int n = 0;
        while (n < this.tables.size()) {
            MdTable mdTable = (MdTable)this.tables.elementAt(n);
            if (mdTable.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static MdTableSpace newInstance(String string, String string2, MdDataSourceProperties mdDataSourceProperties) throws TmDuplicateObjectException {
        MdTableSpace mdTableSpace = (MdTableSpace)tableSpaces.get(string);
        if (mdTableSpace != null) {
            throw new TmDuplicateObjectException(string, "tablespace already exists");
        }
        mdTableSpace = new MdTableSpace(string, string2, mdDataSourceProperties);
        tableSpaces.put(string, mdTableSpace);
        return mdTableSpace;
    }

    public MdTable newMdTable(String string) throws TmDuplicateObjectException {
        MdTable mdTable = this.getMdTable(string);
        if (mdTable != null) {
            throw new TmDuplicateObjectException(String.valueOf(this.getQualifiedName()) + "." + string, "table already exists");
        }
        mdTable = new MdTable(this, string);
        this.tables.addElement(mdTable);
        return mdTable;
    }

    public static void removeInstance(String string) {
        tableSpaces.remove(string);
    }

    public void removeMdTable(int n) {
        this.tables.removeElementAt(n);
    }

    public int tables() {
        return this.tables.size();
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

