/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import com.sun.symon.tools.migration.datasource.MdAttribute;
import com.sun.symon.tools.migration.datasource.MdTable;
import com.sun.symon.tools.migration.datasource.MdValue;
import java.io.Serializable;
import java.util.Vector;

public class MdRecord
implements Serializable {
    private MdTable table;
    private final Vector values = new Vector();

    public MdValue addMdValue(MdValue mdValue) {
        this.values.addElement(mdValue);
        mdValue.setMdRecord(this);
        return mdValue;
    }

    public boolean equals(Object object) {
        MdRecord mdRecord;
        if (object != null && object instanceof MdRecord && (mdRecord = (MdRecord)object).values() == this.values()) {
            int n = 0;
            while (n < this.values.size()) {
                if (!this.getMdValue(n).equals(mdRecord.getMdValue(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public MdTable getMdTable() {
        return this.table;
    }

    public MdValue getMdValue(int n) {
        return (MdValue)this.values.elementAt(n);
    }

    public MdValue getMdValue(MdAttribute mdAttribute) {
        MdValue mdValue = this.getMdValue(mdAttribute.getName());
        if (mdValue != null && mdValue.getMdAttribute() == mdAttribute) {
            return mdValue;
        }
        return null;
    }

    public MdValue getMdValue(String string) {
        int n = this.indexOfMdValue(string);
        if (n >= 0) {
            return this.getMdValue(n);
        }
        return null;
    }

    public int indexOfMdValue(String string) {
        return this.table.indexOfMdAttribute(string);
    }

    public void newMdValues() {
        this.values.clear();
        int n = 0;
        while (n < this.table.attributes()) {
            this.addMdValue(new MdValue(this.table.getMdAttribute(n)));
            ++n;
        }
    }

    public void removeMdValue(int n) {
        this.values.removeElementAt(n);
    }

    public void setMdTable(MdTable mdTable) {
        this.table = mdTable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.values.size()) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.values.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public int values() {
        return this.values.size();
    }
}

