/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.migration.datasource;

import com.sun.symon.tools.migration.datasource.MdTable;
import java.io.Serializable;

public class MdAttribute
implements Serializable {
    public static final int TYPE_INT = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_TIMESTAMP = 5;
    public static final int TYPE_DATE = 6;
    public static final int TYPE_STRING = 7;
    private MdTable table;
    private int index;
    private String name;
    private int type;
    private String source;
    private String references;

    protected MdAttribute(MdTable mdTable, int n, String string, int n2, String string2, String string3) {
        if (mdTable == null) {
            throw new IllegalArgumentException("table is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.table = mdTable;
        this.index = n;
        this.name = string;
        this.type = n2;
        this.source = string2;
        this.references = string3;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof MdAttribute && ((MdAttribute)object).getQualifiedName().equals(this.getQualifiedName());
    }

    public int getIndex() {
        return this.index;
    }

    public MdTable getMdTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        if (this.table == null) {
            return this.name;
        }
        return String.valueOf(this.table.getQualifiedName()) + "." + this.name;
    }

    public String getReferences() {
        return this.references;
    }

    public String getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return MdAttribute.getTypeString(this.type);
    }

    public static String getTypeString(int n) {
        switch (n) {
            case 1: {
                return "TYPE_INT";
            }
            case 2: {
                return "TYPE_LONG";
            }
            case 3: {
                return "TYPE_DOUBLE";
            }
            case 4: {
                return "TYPE_BOOLEAN";
            }
            case 5: {
                return "TYPE_TIMESTAMP";
            }
            case 6: {
                return "TYPE_DATE";
            }
            case 7: {
                return "TYPE_STRING";
            }
        }
        return "unknown type: " + n;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    protected void setIndex(int n) {
        this.index = n;
    }

    protected void setMdTable(MdTable mdTable) {
        this.table = mdTable;
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected void setReferences(String string) {
        this.references = string;
    }

    protected void setSource(String string) {
        this.source = string;
    }

    protected void setType(int n) {
        this.type = n;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public static int toType(String string) {
        if (string == null) {
            throw new NullPointerException("type is null");
        }
        if ((string = string.trim().toLowerCase()).equals("int")) {
            return 1;
        }
        if (string.equals("long")) {
            return 2;
        }
        if (string.equals("double")) {
            return 3;
        }
        if (string.equals("boolean")) {
            return 4;
        }
        if (string.equals("timestamp")) {
            return 5;
        }
        if (string.equals("date")) {
            return 6;
        }
        if (string.equals("string")) {
            return 7;
        }
        throw new IllegalArgumentException(String.valueOf(string) + " is not a valid type");
    }
}

