/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.aurora.ssl.AuroraSSLConnection;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLSession;
import oracle.security.ssl.OracleSSLSocketFactory;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.UNKNOWN;

class AuroraSSLConnectionImpl
implements AuroraSSLConnection {
    private static OracleSSLSocketFactory _factory;
    private SSLSocket _jsock = null;
    private OracleSSLCredential _credentials;
    private OracleSSLSession _session = null;
    private Object _readLock = new Object();
    private boolean connectionAlive = true;
    private InputStream _in = null;
    private OutputStream _out = null;
    private boolean _need = false;
    private boolean _client = true;
    private static boolean _Debug;

    static {
        _Debug = false;
        try {
            ((Hashtable)System.getProperties()).put("SSLSocketFactoryImplClass", "oracle.security.ssl.OracleSSLSocketFactoryImpl");
            _factory = (OracleSSLSocketFactory)SSLSocketFactory.getDefault();
            _factory.setSSLProtocolVersion(0);
            String debug = System.getProperty("AuroraSSLDebug");
            if (debug != null && debug.equalsIgnoreCase("true")) {
                _Debug = true;
            }
        }
        catch (Exception e) {
            System.out.println("Exception initializing the SSL Connection" + e);
            throw new INITIALIZE("SSL Conn initialization failed");
        }
    }

    AuroraSSLConnectionImpl() {
        this._credentials = new OracleSSLCredential();
    }

    public synchronized void addCertificate(byte[] derCert) {
        if (_Debug) {
            System.out.println("Setting the certificate(part of chain) : " + derCert);
        }
        this._credentials.addCertChain(derCert);
    }

    public synchronized void addTrustedCertificate(byte[] derCert) {
        if (_Debug) {
            System.out.println("Setting the trust point: " + derCert);
            int j = 0;
            while (j < derCert.length) {
                System.out.print(String.valueOf(derCert[j]) + " ");
                ++j;
            }
            System.out.println("");
            System.out.println("_credentials: " + this._credentials);
        }
        this._credentials.addTrustedCert(derCert);
    }

    public void close() throws IOException {
        if (_Debug) {
            System.out.println("In close");
        }
        if (this._jsock == null) {
            throw new BAD_OPERATION("socket not yet set");
        }
        try {
            this._jsock.close();
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("close() on jsock failed");
                e.printStackTrace();
            }
            throw new IOException();
        }
    }

    OracleSSLCredential getCredentials() {
        if (_Debug) {
            System.out.println("Getting credentials from connection");
        }
        return this._credentials;
    }

    public InputStream getInputStream() {
        if (_Debug) {
            System.out.println("In Get inputstream");
        }
        if (this._in != null) {
            return this._in;
        }
        throw new BAD_OPERATION("Socket not set yet");
    }

    public synchronized String getNegotiatedCipherSuite() {
        return this._session.getCipherSuite();
    }

    public synchronized String getNegotiatedProtocolVersion() {
        if (this._session == null) {
            throw new BAD_OPERATION("handshake is not done yet");
        }
        return this._session.getNegotiatedProtocolVersion();
    }

    public OutputStream getOutputStream() {
        if (_Debug) {
            System.out.println("In Get outputstream");
        }
        if (this._out != null) {
            return this._out;
        }
        throw new BAD_OPERATION("Socket not set yet");
    }

    public synchronized byte[][] getPeerDERCertificateChain() {
        if (this._session == null) {
            throw new BAD_OPERATION("handshake is not done yet");
        }
        try {
            return this._session.getPeerRawCertificateChain();
        }
        catch (Exception exception) {
            throw new UNKNOWN("getpeerDERCertificateChain failed");
        }
    }

    public synchronized void handshake() throws IOException {
        if (this._jsock == null) {
            throw new BAD_OPERATION("socket not yet set");
        }
        try {
            if (_Debug) {
                System.out.println("Starting handShake");
                System.out.println("Credentials = " + this._credentials);
            }
            _factory.setSSLCredentials(this._credentials);
            if (_Debug) {
                System.out.println("About to call handshake");
            }
            this._jsock.startHandshake();
            if (_Debug) {
                System.out.println("handshake returned");
            }
            this._session = (OracleSSLSession)this._jsock.getSession();
            if (_Debug) {
                System.out.println(this._session.getNegotiatedProtocolVersion());
                System.out.println(this._session.getCipherSuite());
                byte[][] certChain = this._session.getPeerRawCertificateChain();
                System.out.println("Peer cert chain length : " + certChain.length);
            }
            this._in = this._jsock.getInputStream();
            this._out = this._jsock.getOutputStream();
        }
        catch (Throwable e) {
            if (_Debug) {
                System.out.println("handshake failed");
                e.printStackTrace();
            }
            throw new COMM_FAILURE("handshake failed");
        }
    }

    public void read(byte[] bytes, int offset, int length) throws IOException {
        if (this._in == null) {
            throw new BAD_OPERATION("socket not yet set");
        }
        try {
            Object object = this._readLock;
            synchronized (object) {
                while (length > 0) {
                    int bytesRead = this._in.read(bytes, offset, length);
                    if (bytesRead == -1) {
                        throw new COMM_FAILURE("Connection closed");
                    }
                    offset += bytesRead;
                    length -= bytesRead;
                }
            }
        }
        catch (Exception exception) {
            this.connectionAlive = true;
            System.out.println("got IOException");
            throw new IOException();
        }
    }

    public synchronized void setB64PrivateKey(String b64Key, String password) {
        if (_Debug) {
            System.out.println("Setting the private key : " + b64Key + ", password = " + password);
        }
        this._credentials.setPrivateKey(b64Key, password);
    }

    public void setClientAuth(boolean need) {
        if (_Debug) {
            System.out.println("Setting the client side authentication to : " + need);
        }
        if (this._jsock != null) {
            this._jsock.setNeedClientAuth(need);
        } else {
            this._need = need;
        }
    }

    public void setClientSide(boolean client) {
        this._client = client;
    }

    public void setCredentials(OracleSSLCredential creds) {
        if (_Debug) {
            System.out.println("Setting credentials to the connection");
        }
        this._credentials = creds;
    }

    public synchronized void setPrivateKey(byte[] pvtKey, String password) {
        if (_Debug) {
            System.out.println("Setting the private (byte array)key : " + pvtKey + ", password = " + password);
        }
        this._credentials.setPrivateKey(pvtKey, password);
    }

    public synchronized void setProtocolVersion(int version) {
        try {
            if (_Debug) {
                System.out.println("Setting the SSL protocol version : " + version);
            }
            _factory.setSSLProtocolVersion(version);
        }
        catch (Exception exception) {
            throw new INITIALIZE("set protocol version failed");
        }
    }

    public void setSocket(Socket socket) {
        if (_Debug) {
            System.out.println("Setting the socket : " + socket + ", this = " + this);
        }
        if (this._jsock != null) {
            throw new BAD_OPERATION("socket already set");
        }
        try {
            this._jsock = (SSLSocket)_factory.createSocket(socket);
            this._jsock.setNeedClientAuth(this._need);
        }
        catch (Exception e) {
            if (_Debug) {
                e.printStackTrace();
            }
            throw new INITIALIZE("createSocket failed");
        }
    }

    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        if (this._out == null) {
            throw new BAD_OPERATION("socket not yet set");
        }
        if (!this.connectionAlive) {
            throw new IOException("Connection closed.");
        }
        try {
            this._out.write(bytes, offset, length);
        }
        catch (Exception exception) {
            this.connectionAlive = false;
            throw new IOException();
        }
    }
}

