/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.sess_iiop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.CannotProceedException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import oracle.aurora.AuroraServices.Credential;
import oracle.aurora.AuroraServices.LoginServer;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.AuroraServices.PublishedObjectHelper;
import oracle.aurora.AuroraServices.PublishingContext;
import oracle.aurora.AuroraServices.PublishingContextHelper;
import oracle.aurora.AuroraServices.ctxAttribs;
import oracle.aurora.AuroraServices.ctxAttribsHolder;
import oracle.aurora.client.Login;
import oracle.aurora.jndi.sess_iiop.ActivationException;
import oracle.aurora.jndi.sess_iiop.DoPrivilegedAction;
import oracle.aurora.jndi.sess_iiop.ExceptionMapper;
import oracle.aurora.jndi.sess_iiop.InitialReferencesFinder;
import oracle.aurora.jndi.sess_iiop.ServiceId;
import oracle.aurora.jndi.sess_iiop.SessionBindingEnumeration;
import oracle.aurora.jndi.sess_iiop.SessionFullBindingEnumeration;
import oracle.aurora.jndi.sess_iiop.SessionNameParser;
import oracle.aurora.jndi.sess_iiop.sess_iiopContext;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.server.publishing.PublishingContextImpl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.InitialReferences;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class SessionCtx
implements sess_iiopContext,
DirContext {
    private static ResourceBundle resMessages = ResourceBundle.getBundle("oracle.aurora.jndi.sess_iiop.Messages");
    private Hashtable environment = new Hashtable(7, 0.75f);
    PublishingContext namingContext;
    private static final SessionNameParser parser = new SessionNameParser();
    public static String InitialReferencesFinderClass = "oracle.aurora.jndi.orb_dep.IRFinder";
    public static String SslInitialReferencesFinderClass = "oracle.aurora.jndi.orb_dep.SslIRFinder";
    private static final String LOGIN_NAME = "etc/login";
    private boolean __auth_done = false;
    private static boolean inServer;
    private static boolean initialized;

    static {
        initialized = false;
    }

    SessionCtx(Hashtable env, ServiceId id) throws NamingException {
        this.environment = (Hashtable)env.clone();
        this.namingContext = this.initialContext(id);
    }

    protected SessionCtx(PublishingContext nc, Hashtable env) throws NamingException {
        if (nc == null) {
            throw new ConfigurationException(resMessages.getString("CONTEXT_REQUIRED"));
        }
        this.namingContext = nc;
        this.environment = env;
    }

    protected synchronized java.lang.Object _activate(NameComponent[] components) throws NamingException {
        try {
            PublishingContext nc;
            Object obj = this.namingContext.resolve(components);
            try {
                nc = PublishingContextHelper.narrow(obj);
            }
            catch (SystemException systemException) {
                nc = null;
            }
            if (nc != null) {
                return new SessionCtx(nc, this.environment);
            }
            StringHolder helperClassName = new StringHolder();
            obj = PublishedObjectHelper.narrow(obj).activate(helperClassName);
            if (SessionCtx.inServer()) {
                Class cl = Handle.lookupClass((String)helperClassName.value, (Resolver)Resolver.defaultResolver()).loadClass();
                return this._narrow(cl, obj);
            }
            return this._narrow(Class.forName(helperClassName.value), obj);
        }
        catch (oracle.aurora.AuroraServices.ActivationException e) {
            ActivationException ae = new ActivationException(e.errorMsg);
            ae.setRootCause((Throwable)((java.lang.Object)e));
            throw ae;
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (Exception e) {
            NamingException ne = new NamingException(resMessages.getString("UNKNOWN"));
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected synchronized void _bind(NameComponent[] components, java.lang.Object object, boolean rebind) throws NamingException {
        this.checkContext();
        try {
            if (!(object instanceof SessionCtx)) {
                if (object instanceof NamingContext) {
                    NamingContext context = NamingContextHelper.narrow((Object)object);
                    if (rebind) {
                        this.namingContext.rebind_context(components, context);
                    } else {
                        this.namingContext.bind_context(components, context);
                    }
                    return;
                }
                if (object instanceof PublishedObject) {
                    try {
                        PublishedObject obj = PublishedObjectHelper.narrow((Object)object);
                        if (obj == null) {
                            throw new OperationNotSupportedException();
                        }
                        if (rebind) {
                            this.namingContext.rebind(components, (Object)obj);
                        } else {
                            this.namingContext.bind(components, (Object)obj);
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw new OperationNotSupportedException();
                    }
                    return;
                }
                throw new OperationNotSupportedException();
            }
            object = ((SessionCtx)object).namingContext;
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (AlreadyBound e) {
            throw ExceptionMapper.mapAlreadyBoundExc(e);
        }
        catch (BAD_PARAM e) {
            NotContextException nc = new NotContextException(SessionNameParser.cosNameToString(components));
            nc.setRootCause(e);
            throw nc;
        }
        catch (Exception e) {
            NamingException ne = new NamingException(resMessages.getString("UNKNOWN"));
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected synchronized Context _bindNewContext(NameComponent[] components) throws NamingException {
        this.checkContext();
        try {
            PublishingContext naming2 = PublishingContextHelper.narrow(this.namingContext.bind_new_context(components));
            return new SessionCtx(naming2, this.environment);
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (AlreadyBound e) {
            throw ExceptionMapper.mapAlreadyBoundExc(e);
        }
        catch (Exception e) {
            NamingException except = new NamingException(resMessages.getString("UNKNOWN"));
            except.setRootCause(e);
            throw except;
        }
    }

    protected synchronized PublishedObject _createObject(NameComponent[] components, String className, String helper) throws NamingException {
        this.checkContext();
        try {
            return PublishedObjectHelper.narrow((Object)this.namingContext.create_object(components, className, helper));
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (AlreadyBound e) {
            throw ExceptionMapper.mapAlreadyBoundExc(e);
        }
        catch (Exception e) {
            NamingException except = new NamingException(resMessages.getString("UNKNOWN"));
            except.setRootCause(e);
            throw except;
        }
    }

    protected synchronized PublishedObject _createObject(NameComponent[] components, String className, String schema, String helper) throws NamingException {
        this.checkContext();
        try {
            return PublishedObjectHelper.narrow((Object)this.namingContext.create_object_in(components, className, schema, helper));
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (AlreadyBound e) {
            throw ExceptionMapper.mapAlreadyBoundExc(e);
        }
        catch (Exception e) {
            NamingException except = new NamingException(resMessages.getString("UNKNOWN"));
            except.setRootCause(e);
            throw except;
        }
    }

    protected synchronized void _destroy(NamingContext components) throws NamingException {
        this.checkContext();
        try {
            components.destroy();
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotEmpty e) {
            throw ExceptionMapper.mapNotEmptyExc(e);
        }
    }

    public java.lang.Object _lookup(String name) throws NamingException {
        this.checkContext();
        if (name.length() == 0) {
            return this.namingContext;
        }
        return this._resolve(this.createNamePath(name));
    }

    public synchronized java.lang.Object _lookup(Name name) throws NamingException {
        this.checkContext();
        if (name.size() == 0) {
            return this.namingContext;
        }
        return this._resolve(this.createNamePath(name));
    }

    protected java.lang.Object _narrow(Class helper, Object obj) throws NamingException {
        if (helper == null) {
            return obj;
        }
        Method narrowMethod = null;
        try {
            narrowMethod = DoPrivilegedAction.getDeclaredMethod(helper, "narrow");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CannotProceedException(String.valueOf(resMessages.getString("CANNOT_FIND_NARROW")) + helper);
        }
        try {
            return narrowMethod.invoke((java.lang.Object)helper, (java.lang.Object[])new Object[]{obj});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotProceedException(String.valueOf(resMessages.getString("ILLEGAL_ARGUMENT_IN_NARROW")) + helper);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CannotProceedException(resMessages.getString("INITIALIZATION_ERROR"));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CannotProceedException(String.valueOf(resMessages.getString("ILLEGAL_ACCESS_IN_NARROW")) + helper);
        }
    }

    protected synchronized java.lang.Object _resolve(NameComponent[] components) throws NamingException {
        try {
            Object obj = this.namingContext.resolve(components);
            PublishingContext nc = PublishingContextHelper.narrow(obj);
            if (nc != null) {
                return new SessionCtx(nc, this.environment);
            }
            PublishedObject o = PublishedObjectHelper.narrow(obj);
            return o;
        }
        catch (NO_PERMISSION e) {
            throw ExceptionMapper.mapNoPermExec(e);
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (Exception e) {
            NamingException ne = new NamingException(resMessages.getString("UNKNOWN"));
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected synchronized void _unbind(NameComponent[] components) throws NamingException {
        this.checkContext();
        try {
            this.namingContext.unbind(components);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new SecurityException();
        }
        catch (NotFound e) {
            throw ExceptionMapper.mapNotFoundExc(e);
        }
        catch (CannotProceed e) {
            throw ExceptionMapper.mapCannotProceedExc(e);
        }
        catch (InvalidName e) {
            throw ExceptionMapper.mapInvalidNameExc(e);
        }
        catch (Exception e) {
            NamingException ne = new NamingException(resMessages.getString("UNKNOWN"));
            ne.setRootCause(e);
            throw ne;
        }
    }

    public java.lang.Object activate(String name) throws NamingException {
        return this.activate(parser.parse(name));
    }

    public synchronized java.lang.Object activate(Name name) throws NamingException {
        name = this.trim(name);
        this.checkContext();
        if (name.size() == 0) {
            return this.namingContext;
        }
        return this._activate(this.createNamePath(name));
    }

    public java.lang.Object addToEnvironment(String key, java.lang.Object value) throws NamingException {
        this.environment.put(key, value);
        return value;
    }

    public void bind(String name, java.lang.Object object) throws NamingException {
        this.bind(parser.parse(name), object);
    }

    public void bind(String arg1, java.lang.Object arg2, Attributes arg3) throws NamingException {
    }

    public void bind(Name name, java.lang.Object object) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        NameComponent[] components = this.createNamePath(name);
        this._bind(components, object, false);
    }

    public void bind(Name arg1, java.lang.Object arg2, Attributes arg3) throws NamingException {
    }

    private void checkContext() throws NamingException {
        if (this.namingContext == null) {
            throw new ConfigurationException(resMessages.getString("NO_ORB"));
        }
    }

    public void close() throws NamingException {
    }

    public String composeName(String arg1, String arg2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name arg1, Name arg2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected NameComponent[] createNamePath(String name) throws NamingException {
        if (name == null) {
            throw new IllegalArgumentException(resMessages.getString("NULL_INVALID"));
        }
        return parser.stringToCosName(name);
    }

    protected NameComponent[] createNamePath(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(resMessages.getString("NULL_INVALID"));
        }
        return SessionNameParser.stringToCosName(name);
    }

    public PublishedObject createObject(String name, String className, String helper) throws NamingException {
        return this.createObject(parser.parse(name), className, helper);
    }

    public PublishedObject createObject(String name, String className, String schema, String helper) throws NamingException {
        return this.createObject(parser.parse(name), className, schema, helper);
    }

    public PublishedObject createObject(Name name, String className, String helper) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        NameComponent[] component = this.createNamePath(name);
        return this._createObject(component, className, helper);
    }

    public PublishedObject createObject(Name name, String className, String schema, String helper) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        NameComponent[] component = this.createNamePath(name);
        return this._createObject(component, className, schema, helper);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(parser.parse(name));
    }

    public DirContext createSubcontext(String arg1, Attributes arg2) throws NamingException {
        return null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        NameComponent[] component = this.createNamePath(name);
        return this._bindNewContext(component);
    }

    public DirContext createSubcontext(Name arg1, Attributes arg2) throws NamingException {
        return null;
    }

    private void credential_login() {
        String type = (String)this.environment.get("java.naming.security.authentication");
        if (type != null && (type.equals("Credential") || type.equals("SecureCredential"))) {
            String un = (String)this.environment.get("java.naming.security.principal");
            String pwd = (String)this.environment.get("java.naming.security.credentials");
            String role = (String)this.environment.get("oracle.aurora.sess_iiop.role");
            Credential.authenticate(un, pwd, role);
            this.__auth_done = true;
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(parser.parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        name = this.trim(name);
        this.checkContext();
        NameComponent[] components = this.createNamePath(name);
        NamingContext nc = this.namingContext;
        if (name.size() > 0) {
            try {
                nc = ((SessionCtx)this._resolve(components)).getNamingContext();
            }
            catch (ClassCastException classCastException) {
                throw new NotContextException(name.toString());
            }
        }
        this._destroy(nc);
        this._unbind(components);
    }

    private InitialReferencesFinder finder() {
        try {
            return (InitialReferencesFinder)Class.forName(InitialReferencesFinderClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.valueOf(resMessages.getString("CANNOT_FIND_CLASS")) + InitialReferencesFinderClass);
            System.out.println(e.getMessage());
        }
        catch (InstantiationException e) {
            System.out.println(String.valueOf(resMessages.getString("CANNOT_INSTANTIATE_CLASS")) + InitialReferencesFinderClass);
            System.out.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.out.println(String.valueOf(resMessages.getString("CANNOT_ACCESS_CLASS")) + InitialReferencesFinderClass);
            System.out.println(e.getMessage());
        }
        return null;
    }

    public ctxAttribs getAttributes() {
        ctxAttribsHolder holder = new ctxAttribsHolder();
        this.namingContext.get_attributes(holder);
        return holder.value;
    }

    public Attributes getAttributes(String arg1) throws NamingException {
        return null;
    }

    public Attributes getAttributes(String arg1, String[] arg2) throws NamingException {
        return null;
    }

    public Attributes getAttributes(Name arg1) throws NamingException {
        return null;
    }

    public Attributes getAttributes(Name arg1, String[] arg2) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Cannot retreive full name");
    }

    public NameParser getNameParser(String arg1) throws NamingException {
        return parser;
    }

    public NameParser getNameParser(Name arg1) throws NamingException {
        return parser;
    }

    NamingContext getNamingContext() {
        return this.namingContext;
    }

    public DirContext getSchema(String arg1) throws NamingException {
        return null;
    }

    public DirContext getSchema(Name arg1) throws NamingException {
        return null;
    }

    public DirContext getSchemaClassDefinition(String arg1) throws NamingException {
        return null;
    }

    public DirContext getSchemaClassDefinition(Name arg1) throws NamingException {
        return null;
    }

    public ctxAttribs get_attributes() {
        ctxAttribsHolder attribs = new ctxAttribsHolder();
        this.namingContext.get_attributes(attribs);
        return attribs.value;
    }

    public static boolean inServer() {
        if (initialized) {
            return inServer;
        }
        initialized = true;
        if (System.getProperty("oracle.server.version") != null) {
            inServer = true;
        }
        return inServer;
    }

    private PublishingContext initialContext(ServiceId id) throws NamingException {
        String auth = (String)this.environment.get("java.naming.security.authentication");
        this.credential_login();
        try {
            InitialReferences ir = auth != null && (auth.equals("SecureCredential") || auth.equals("SecureLogin") || auth.equals("SslClientAuth")) ? this.sslFinder().initialReferences(id.host, id.port, id.id, this.environment) : this.finder().initialReferences(id.host, id.port, id.id, this.environment);
            return PublishingContextHelper.narrow(ir.get("NameService"));
        }
        catch (UnknownHostException unknownHostException) {
            throw new CommunicationException(String.valueOf(resMessages.getString("UNKNOWN_HOST")) + id.host);
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            throw new CommunicationException(String.valueOf(resMessages.getString("UNKNOWN_SERVICE")) + id);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new NoPermissionException(resMessages.getString("NO_PERMISSION"));
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(parser.parse(name));
    }

    public synchronized NamingEnumeration list(Name name) throws NamingException {
        this.checkContext();
        if (name.size() == 0) {
            try {
                return new SessionBindingEnumeration(this);
            }
            catch (NO_PERMISSION e) {
                throw ExceptionMapper.mapNoPermExec(e);
            }
        }
        try {
            java.lang.Object obj = this.lookup(name);
            if (!(obj instanceof SessionCtx)) {
                throw new NotContextException(name.toString());
            }
            return new SessionBindingEnumeration((SessionCtx)obj);
        }
        catch (BAD_PARAM e) {
            NotContextException nc = new NotContextException(name.toString());
            nc.setRootCause(e);
            throw nc;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(parser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        name = this.trim(name);
        this.checkContext();
        if (name.size() == 0) {
            return new SessionBindingEnumeration(this);
        }
        try {
            java.lang.Object obj = this.lookup(name);
            if (!(obj instanceof SessionCtx)) {
                throw new NotContextException(name.toString());
            }
            return new SessionFullBindingEnumeration((SessionCtx)obj);
        }
        catch (BAD_PARAM e) {
            NotContextException nc = new NotContextException(name.toString());
            nc.setRootCause(e);
            throw nc;
        }
    }

    public synchronized boolean login() throws NamingException {
        if (this.__auth_done) {
            return true;
        }
        String username = (String)this.environment.get("java.naming.security.principal");
        String password = (String)this.environment.get("java.naming.security.credentials");
        String role = (String)this.environment.get("oracle.aurora.sess_iiop.role");
        return this.login(username, password, role);
    }

    public synchronized boolean login(String username, String password, String role) throws NamingException {
        try {
            Login login = new Login((LoginServer)this.activate(LOGIN_NAME));
            return login.authenticate(username, password, role);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            throw new NoPermissionException(resMessages.getString("NO_PERMISSION"));
        }
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(parser.parse(name));
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        name = this.trim(name);
        this.checkContext();
        if (name.size() == 0) {
            return this;
        }
        return this._resolve(this.createNamePath(name));
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void modifyAttributes(String arg1, int arg2, Attributes arg3) throws NamingException {
    }

    public void modifyAttributes(String arg1, ModificationItem[] arg2) throws NamingException {
    }

    public void modifyAttributes(Name arg1, int arg2, Attributes arg3) throws NamingException {
    }

    public void modifyAttributes(Name arg1, ModificationItem[] arg2) throws NamingException {
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        this.rebind(parser.parse(name), obj);
    }

    public void rebind(String arg1, java.lang.Object arg2, Attributes arg3) throws NamingException {
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        this._bind(this.createNamePath(name), obj, true);
    }

    public void rebind(Name arg1, java.lang.Object arg2, Attributes arg3) throws NamingException {
    }

    public java.lang.Object removeFromEnvironment(String key) throws NamingException {
        return this.environment.remove(key);
    }

    public void rename(String from, String to) throws NamingException {
        this.rename(parser.parse(from), parser.parse(to));
    }

    public synchronized void rename(Name from, Name to) throws NamingException {
        from = this.trim(from);
        to = this.trim(to);
        this.checkContext();
        if (from.size() == 0 || to.size() == 0) {
            throw new InvalidNameException(resMessages.getString("ONE_OR_BOTH_NAMES_EMPTY"));
        }
        java.lang.Object object3 = this.lookup(from);
        this.bind(to, object3);
        this.unbind(from);
    }

    public NamingEnumeration search(String arg1, String arg2, SearchControls arg3) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String arg1, String arg2, java.lang.Object[] arg3, SearchControls arg4) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String arg1, Attributes arg2) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String arg1, Attributes arg2, String[] arg3) throws NamingException {
        return null;
    }

    public NamingEnumeration search(Name arg1, String arg2, SearchControls arg3) throws NamingException {
        return null;
    }

    public NamingEnumeration search(Name arg1, String arg2, java.lang.Object[] arg3, SearchControls arg4) throws NamingException {
        return null;
    }

    public NamingEnumeration search(Name arg1, Attributes arg2) throws NamingException {
        return null;
    }

    public NamingEnumeration search(Name arg1, Attributes arg2, String[] arg3) throws NamingException {
        return null;
    }

    public int sessionId() throws NamingException {
        this.checkContext();
        return this.namingContext.sessionId();
    }

    public void set_attributes(String owner, String[] read, String[] write, String[] execute) {
        this.namingContext.set_attributes(owner, read, write, execute);
    }

    public synchronized void set_owner(String owner) {
        String[] nullArray = new String[]{};
        this.namingContext.set_attributes(owner, nullArray, nullArray, nullArray);
    }

    private InitialReferencesFinder sslFinder() {
        try {
            return (InitialReferencesFinder)Class.forName(SslInitialReferencesFinderClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.valueOf(resMessages.getString("CANNOT_FIND_CLASS")) + SslInitialReferencesFinderClass);
            System.out.println(e.getMessage());
        }
        catch (InstantiationException e) {
            System.out.println(String.valueOf(resMessages.getString("CANNOT_INSTANTIATE_CLASS")) + SslInitialReferencesFinderClass);
            System.out.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.out.println(String.valueOf(resMessages.getString("CANNOT_ACCESS_CLASS")) + SslInitialReferencesFinderClass);
            System.out.println(e.getMessage());
        }
        return null;
    }

    static PublishingContext thisContext() {
        return PublishingContextImpl.singletonContext();
    }

    /*
     * Unable to fully structure code
     */
    private Name trim(Name name) throws NamingException {
        if (name.size() != 0) ** GOTO lbl4
        return name;
lbl-1000:
        // 1 sources

        {
            name = name.getSuffix(1);
lbl4:
            // 2 sources

            ** while (name.size() > 0 && name.get((int)0).equals((java.lang.Object)""))
        }
lbl5:
        // 1 sources

        return name;
    }

    public void unbind(String name) throws NamingException {
        this.unbind(parser.parse(name));
    }

    public void unbind(Name name) throws NamingException {
        if ((name = this.trim(name)).size() == 0) {
            throw new InvalidNameException(resMessages.getString("NAME_IS_EMPTY"));
        }
        this._unbind(this.createNamePath(name));
    }
}

