/*
 * Decompiled with CFR 0.152.
 */
package com.sun.entdiag.ui;

import com.sun.entdiag.ui.CommEvent;
import com.sun.entdiag.ui.CommListener;
import com.sun.entdiag.ui.Communicator;
import com.sun.entdiag.ui.ControlPanel;
import com.sun.entdiag.ui.DiagPanel;
import com.sun.entdiag.ui.ErrorPanel;
import com.sun.entdiag.ui.MsgTranslator;
import com.sun.entdiag.ui.NavTree;
import com.sun.entdiag.ui.PopUpWindow;
import com.sun.entdiag.ui.SchedWiz;
import com.sun.entdiag.ui.ScheduleEvent;
import com.sun.entdiag.ui.ScheduleListener;
import com.sun.entdiag.ui.TestDevice;
import com.sun.entdiag.ui.TestingEvent;
import com.sun.entdiag.ui.TestingListener;
import com.sun.entdiag.ui.VisitEvent;
import com.sun.entdiag.ui.VisitListener;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class EDPanel
extends JPanel {
    private String showStart = null;
    private String servhost = null;
    private String diagHost;
    private JSplitPane splitPane;
    private NavTree navigator;
    private ControlPanel control;
    private DiagPanel diag;
    private Communicator comm;
    private ErrorPanel errorPanel;
    private String currentNode = null;
    Font boldFont = new Font("Dialog", 1, 14);
    private Hashtable testDevs;
    private Hashtable errorVectors;
    private boolean gettingError = true;
    private Vector currentError = new Vector();
    private boolean serverOK = true;
    private Waiting waitMsg;
    private String logImagesFrom = null;
    private static EDPanel app = null;
    private boolean inSyMON = false;
    private boolean testingNow = false;
    private Vector treeIcons = new Vector(3);
    private Vector nodeIcons = new Vector(5);
    private int udpport = 0;
    private int syAgentPort;
    private String agentName;
    private SMRawDataRequest syRawReq = null;
    private MsgTranslator rb = null;
    private boolean debug = false;
    static String treeDev;
    static int treeStat;

    public EDPanel() {
        super(true);
        if (this.debug) {
            System.err.println("EDPanel instantiated");
        }
    }

    static /* synthetic */ String access$10(EDPanel eDPanel) {
        return eDPanel.currentNode;
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        String string = String.valueOf(this.rb.getString("Enterprise")) + "{ " + this.rb.getString("Probing") + "=}";
        this.navigator = new NavTree(string, this.treeIcons, this.nodeIcons, this.rb);
        VisitListener visitListener = new VisitListener(){

            public void visitNode(VisitEvent visitEvent) {
                String string = visitEvent.getNode();
                if (EDPanel.this.debug) {
                    System.out.println("visit node " + string);
                }
                EDPanel.this.currentNode = new String(string);
                TestDevice testDevice = (TestDevice)EDPanel.this.testDevs.get(string);
                if (testDevice == null) {
                    if (EDPanel.this.debug) {
                        System.out.println("get(" + string + ") returns null");
                    }
                    return;
                }
                EDPanel.this.diag.setInfo(string, testDevice.getInfo(), testDevice.getStatus());
                ((EDPanel)EDPanel.this).diag.panel.validate();
                if (visitEvent.getType() == 0 && EDPanel.this.errorVectors.containsKey(string)) {
                    PopUpWindow popUpWindow = new PopUpWindow(string, EDPanel.this.getEDFrame(), EDPanel.this.rb);
                    popUpWindow.setErrorMessage((Vector)EDPanel.this.errorVectors.get(string));
                    int n = ((Vector)EDPanel.this.errorVectors.get(string)).size() * 40 + 100;
                    if (EDPanel.this.debug) {
                        System.out.println("Error length " + n);
                    }
                    ((Component)popUpWindow).setSize(500, n);
                    popUpWindow.show();
                }
            }
        };
        this.navigator.addVisitListener(visitListener);
        this.errorVectors = new Hashtable();
        this.control = new ControlPanel(this.rb);
        this.diag = new DiagPanel(this.rb);
        TestingListener testingListener = new TestingListener(){

            public void testingAction(TestingEvent testingEvent) {
                switch (testingEvent.getType()) {
                    case 0: {
                        EDPanel.this.startTesting();
                        break;
                    }
                    case 1: {
                        EDPanel.this.comm.stopTesting(EDPanel.this.diagHost);
                        EDPanel.this.stopTesting();
                        break;
                    }
                    case 2: {
                        EDPanel.this.scheduleTesting();
                        EDPanel.this.loadSchedules();
                        break;
                    }
                    case 3: {
                        EDPanel.this.connectionCheck();
                        break;
                    }
                    case 4: {
                        EDPanel.this.updateNode(testingEvent.getDevice(), testingEvent.getStatus(), testingEvent.getError());
                        break;
                    }
                    case 5: {
                        EDPanel.this.visitNode(testingEvent.getDevice());
                        break;
                    }
                    case 6: {
                        EDPanel.this.diagHost();
                        break;
                    }
                    case 10: {
                        EDPanel.this.resetTesting();
                        break;
                    }
                    case 11: {
                        EDPanel.this.suspendTesting();
                        break;
                    }
                    case 12: {
                        EDPanel.this.resumeTesting();
                        break;
                    }
                    case 13: {
                        EDPanel.this.getFile(EDPanel.this.diagHost, "logs/hwdiag.info", true);
                        break;
                    }
                    case 14: {
                        EDPanel.this.getFile(EDPanel.this.diagHost, "logs/hwdiag.err", false);
                        break;
                    }
                    case 15: {
                        EDPanel.this.reprobeDevices();
                        break;
                    }
                    case 16: {
                        int n = EDPanel.this.comm.getStatus(EDPanel.this.diagHost, testingEvent.getDevice());
                        n = (n + 1) % 3;
                        EDPanel.this.updateNode(testingEvent.getDevice(), n, testingEvent.getError());
                        break;
                    }
                }
            }
        };
        this.control.addTestingListener(testingListener);
        this.diag.addTestingListener(testingListener);
    }

    private void connectionCheck() {
        this.navigator.showSelected();
        Vector vector = this.navigator.getTestList();
        if (vector.size() < 1) {
            PopUpWindow popUpWindow = new PopUpWindow(this.rb.getString("Warning"), this.getEDFrame(), this.rb);
            popUpWindow.setMessage(this.rb.getString("Popup2"), true);
            ((Component)popUpWindow).setSize(300, 200);
            popUpWindow.show();
            this.control.resetButtons();
            return;
        }
        this.diag.setTests(vector);
        this.comm.connectCheck(this.diagHost, vector);
    }

    private void createEnterpriseInfo() {
        Vector vector = this.navigator.getAllNames();
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = this.comm.getBasicInfo(string);
            if (string2 == null) {
                string2 = new String("No Diagnostics Avalable");
            } else if (!string.equals("Enterprise")) {
                this.diag.hasDiag.addElement(string);
                int n2 = this.comm.getStatus(string, null);
                n2 = (n2 + 1) % 3;
                this.updateNode(string, n2, null);
            }
            vector2.addElement(string2);
            ++n;
        }
    }

    private void createInfo(String string) {
        Vector vector = this.navigator.getAllNames();
        Vector vector2 = new Vector(vector.size());
        Vector vector3 = this.navigator.getLeaves();
        int n = 0;
        while (n < vector.size()) {
            String string2;
            String string3 = (String)vector.elementAt(n);
            if (vector3.contains(string3)) {
                string2 = this.comm.getDetailedInfo(string, string3);
                if (this.debug) {
                    System.out.println("dev info " + string3);
                }
            } else if (string3.equals(string) || string3.equals(this.agentName)) {
                string2 = this.comm.getBasicInfo(string);
                if (this.debug) {
                    System.out.println("host info " + string3);
                }
            } else {
                string2 = this.comm.getGenericInfo(string3);
                if (this.debug) {
                    System.out.println("generic info " + string3);
                }
            }
            if (string2 == null) {
                string2 = this.comm.getGenericInfo(string3);
            }
            if (this.debug) {
                System.out.println("info " + string2);
            }
            String string4 = this.comm.filter.getFRU(string3);
            TestDevice testDevice = new TestDevice(string3, string4, string2);
            this.testDevs.put(string3, testDevice);
            ++n;
        }
    }

    public void destructService() {
        if (this.debug) {
            System.out.println("exiting ED console");
        }
        if (this.comm != null) {
            this.comm.stopMessages();
        }
    }

    private void diagHost() {
        if (this.currentNode != null) {
            this.showHost(this.currentNode);
        }
    }

    private void errorExit(boolean bl, String string) {
        if (this.debug) {
            System.err.println(string);
        }
        ErrorPanel errorPanel = new ErrorPanel(string);
        if (bl) {
            this.remove(this.control.panel);
            this.remove(this.splitPane);
            this.repaint();
            this.validate();
        }
        this.add("Center", errorPanel);
        this.validate();
    }

    private void fillUI() {
        if (this.showStart.equals("Enterprise") || this.showStart.equals("!!!!")) {
            this.showEnterprise();
        } else {
            this.showHost(this.showStart);
        }
    }

    Frame getEDFrame() {
        Container container = this;
        Frame frame = null;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof Frame)) continue;
            frame = (Frame)container;
            break;
        }
        return frame;
    }

    public void getFile(String string, String string2, boolean bl) {
        this.comm.getFile(string, string2);
        PopUpWindow popUpWindow = new PopUpWindow(this.rb.getString("Logpop"), this.getEDFrame(), this.rb);
        if (this.comm.fileData != null) {
            popUpWindow.createText(this.comm.fileData, bl);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.addElement("EDPanel:getFile: ERROR in getting data");
            popUpWindow.createText(vector, bl);
        }
        ((Component)popUpWindow).setSize(560, 550);
        popUpWindow.show();
        if (this.comm.fileData != null) {
            this.comm.fileData.removeAllElements();
            this.comm.fileData = null;
        }
        popUpWindow = null;
        System.gc();
        Runtime.getRuntime().gc();
        if (this.debug) {
            System.out.println("gc done, mem=" + Runtime.getRuntime().totalMemory());
        }
    }

    public void init(MsgTranslator msgTranslator) {
        File file = new File("/tmp/eddebug");
        if (file.exists()) {
            this.debug = true;
        }
        if (this.debug) {
            System.out.println("called init");
        }
        if (this.debug) {
            System.err.println("server " + this.servhost + ", start " + this.showStart);
        }
        this.rb = msgTranslator;
        this.testDevs = new Hashtable();
        try {
            this.comm = this.inSyMON ? new Communicator(this.syRawReq, this.udpport, this.servhost) : new Communicator(this.servhost, this.udpport);
        }
        catch (Exception exception) {
            String string = exception.toString();
            int n = string.indexOf("_Stub");
            System.err.println("Please check if the file /opt/SUNWsymon/app/classes/hdsrvrmi.jar is present on this machine. " + exception);
            this.errorExit(false, this.rb.getString("error1"));
            if (n > 0) {
                this.errorExit(false, this.rb.getString("error14"));
            }
            return;
        }
        CommListener commListener = new CommListener(){

            public void commAction(CommEvent commEvent) {
                String string = commEvent.getMessage();
                switch (commEvent.getType()) {
                    case 0: {
                        EDPanel.this.progressMsg(string);
                        break;
                    }
                    case 1: {
                        if (!EDPanel.this.debug) break;
                        System.out.println("info");
                        break;
                    }
                    case 2: {
                        int n = string.indexOf("Testing completed");
                        if (n > 0) {
                            EDPanel.this.stopTesting();
                            break;
                        }
                        EDPanel.this.storeError(string);
                        break;
                    }
                    case 3: {
                        EDPanel.this.storeConnect(string);
                        break;
                    }
                    case 4: {
                        EDPanel.this.errorExit(true, EDPanel.this.rb.getString("error2"));
                        break;
                    }
                    case 5: {
                        EDPanel.this.reprobeWait();
                        break;
                    }
                    case 6: {
                        EDPanel.this.reprobeGo();
                        break;
                    }
                    case 7: {
                        EDPanel.this.reprobeError();
                        break;
                    }
                }
            }
        };
        this.comm.addCommListener(commListener);
        this.buildUI();
        this.showUI();
        this.fillUI();
    }

    private void loadSchedules() {
        Vector vector = this.comm.getSchedule(this.diagHost);
        if (this.debug) {
            if (vector != null) {
                System.out.println("schedules " + vector.toString());
            } else {
                System.out.println("schedules is null");
            }
        }
        SchedWiz schedWiz = new SchedWiz(this.comm, this.diagHost, this.rb);
        schedWiz.setSchedules(vector);
        schedWiz.setNavigator(this.navigator);
        ScheduleListener scheduleListener = new ScheduleListener(){

            public void scheduleAction(ScheduleEvent scheduleEvent) {
                switch (scheduleEvent.getType()) {
                    case 0: {
                        EDPanel.this.splitPane.remove(EDPanel.this.splitPane.getRightComponent());
                        EDPanel.this.splitPane.setRightComponent(((EDPanel)EDPanel.this).diag.panel);
                        EDPanel.this.navigator.unlockTree();
                        EDPanel.this.control.resetButtons();
                        EDPanel.this.repaint();
                        EDPanel.this.validate();
                        break;
                    }
                    case 1: {
                        EDPanel.this.setSchedule();
                        break;
                    }
                    case 2: {
                        EDPanel.this.navigator.unlockTree();
                        break;
                    }
                    case 3: {
                        EDPanel.this.navigator.lockTree();
                        break;
                    }
                }
            }
        };
        schedWiz.addScheduleListener(scheduleListener);
        schedWiz.pop();
        this.splitPane.remove(this.diag.panel);
        Dimension dimension = new Dimension(200, 520);
        schedWiz.wizard.setMinimumSize(dimension);
        dimension = new Dimension(400, 520);
        schedWiz.wizard.setPreferredSize(dimension);
        this.splitPane.setRightComponent(schedWiz.wizard);
        this.repaint();
        this.validate();
    }

    private void lostServer(boolean bl, boolean bl2, String string) {
        JLabel jLabel;
        JLabel jLabel2 = new JLabel(String.valueOf(string) + "  ");
        if (this.debug) {
            System.err.println(string);
        }
        if (bl) {
            this.remove(this.control.panel);
            this.remove(this.splitPane);
            this.repaint();
            this.validate();
            jLabel = bl2 ? new JLabel("Please install the proper SyMON cofigd package.") : new JLabel("Please ensure ED agent is running and try to reconnect by reopening host window.");
        } else {
            jLabel = new JLabel("Please ensure the ED server is running.");
        }
        this.add("North", jLabel2);
        this.add("Center", jLabel);
        this.validate();
    }

    public Object[] messageArgs(String string) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf("||");
        if (n > 0) {
            objectArray = string.substring(n + 2);
            StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = new String(stringTokenizer.nextToken());
                if (this.debug) {
                    System.out.println("token " + string2);
                }
                vector.addElement(string2);
            }
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void progressMsg(String string) {
        Integer n = new Integer(0);
        if (this.debug) {
            System.out.println("progress msg=" + string);
        }
        int n2 = string.indexOf("==") + 2;
        int n3 = string.indexOf("=", n2);
        if (n2 < 0 || n3 < 0) {
            return;
        }
        String string2 = string.substring(n2, n3);
        int n4 = string.indexOf("VERBOSE", n2) - 1;
        int n5 = string.indexOf("WARNING", n2) - 1;
        if (n5 > 0) {
            string2 = new String("0");
            n4 = n5;
        } else if (n4 < 0) {
            return;
        }
        if (!this.testingNow) {
            this.control.startButtons();
            this.navigator.showAll();
            this.testingNow = true;
        }
        int n6 = 0;
        String string3 = string.substring(n3, n4).trim();
        String string4 = string.substring(n4 + 8);
        n2 = string3.lastIndexOf(" ") + 1;
        int n7 = string3.indexOf("(", n2);
        n6 = n7 > n2 ? n7 : string3.length();
        String string5 = string3.substring(n2, n6);
        if (this.debug) {
            System.err.println("fru=" + string5);
        }
        n2 = string3.indexOf("Diagnostic.") + 11;
        int n8 = string3.indexOf(".", n2);
        int n9 = string3.indexOf(" ", n3);
        String string6 = string3.substring(n2, n8);
        String string7 = new String(String.valueOf(string5) + "(" + string6 + ")");
        String string8 = this.rb.processMsg(string);
        String string9 = this.comm.filter.getDevice(string7);
        if (string9 == null) {
            return;
        }
        try {
            n = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Couldn't convert number:" + numberFormatException);
        }
        this.diag.updateProgress(n, string9, string8, string4);
    }

    private void reprobeDevices() {
        this.comm.reprobeDevices(this.diagHost);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            System.err.println("sleep error:" + exception);
        }
        this.reprobeGo();
    }

    private void reprobeError() {
        this.errorExit(true, this.rb.getString("error10"));
    }

    private void reprobeGo() {
        String string;
        int n;
        if (this.errorPanel != null) {
            this.remove(this.errorPanel);
            this.repaint();
            this.validate();
            this.showUI();
        }
        if ((n = (string = this.comm.getConfig(this.diagHost, this.agentName)).indexOf("ERROR")) >= 0) {
            System.err.println(string);
            int n2 = string.indexOf("rpc error");
            if (n2 >= 0) {
                this.errorExit(true, this.rb.getString("error3"));
            } else {
                this.errorExit(true, this.rb.getString("error4"));
            }
            return;
        }
        this.errorVectors.clear();
        this.navigator.setTree(string);
        this.createInfo(this.diagHost);
        this.diag.setHost(this.diagHost);
        TestDevice testDevice = (TestDevice)this.testDevs.get(this.agentName);
        this.diag.setInfo(this.agentName, testDevice.getInfo(), testDevice.getStatus());
        this.validate();
    }

    private void reprobeWait() {
        this.errorPanel = new ErrorPanel(this.rb.getString("drMsg"));
        this.remove(this.control.panel);
        this.remove(this.splitPane);
        this.repaint();
        this.validate();
        this.add("Center", this.errorPanel);
        this.validate();
    }

    private void resetNode(String string, int n) {
        if (string == null) {
            return;
        }
        TestDevice testDevice = (TestDevice)this.testDevs.get(string);
        if (testDevice == null) {
            return;
        }
        testDevice.setStatus(n);
        this.testDevs.remove(string);
        this.testDevs.put(string, testDevice);
    }

    private void resetTesting() {
        this.comm.stopTesting(this.diagHost);
        this.testingNow = false;
        this.control.resetButtons();
        this.diag.resetPanel(1);
        this.comm.resetTesting(this.diagHost);
        this.resetTests();
        this.errorVectors.clear();
        String string = this.navigator.getVisitedNode();
        if (string != null) {
            TestDevice testDevice = (TestDevice)this.testDevs.get(string);
            this.diag.setInfo(string, testDevice.getInfo(), testDevice.getStatus());
            this.diag.panel.validate();
        }
    }

    private void resetTests() {
        Object object;
        Vector vector = this.navigator.getAllNames();
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            this.resetNode((String)object, 0);
            ++n;
        }
        object = new Runnable(){

            public void run() {
                EDPanel.this.navigator.resetTree();
                if (EDPanel.this.debug) {
                    System.out.println("back from tree reset");
                }
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
    }

    private void resumeTesting() {
        this.comm.resumeTesting(this.diagHost);
    }

    private void scheduleTesting() {
        this.navigator.lockTree();
        this.validate();
    }

    public void setAgentName(String string) {
        this.agentName = new String(string);
        if (this.debug) {
            System.out.println("agent name " + this.agentName);
        }
    }

    public void setAgentPort(int n) {
        this.syAgentPort = n;
    }

    public void setArgs(String string, String string2) {
        this.servhost = new String(string);
        this.showStart = new String(string2);
    }

    public void setEDport(int n) {
        this.udpport = n;
    }

    public void setHDhandle(SMRawDataRequest sMRawDataRequest) {
        this.syRawReq = sMRawDataRequest;
    }

    public void setIcons(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            this.treeIcons.addElement((Image)vector.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            this.nodeIcons.addElement((Image)vector2.elementAt(n2));
            ++n2;
        }
    }

    private void setSchedule() {
        Vector vector = this.navigator.getTestList();
        this.comm.schedTesting(this.diagHost, vector);
    }

    public void setSymon(int n) {
        if (n == 1) {
            this.inSyMON = true;
        }
    }

    public void showEnterprise() {
        this.comm.stopMessages();
        String string = this.comm.getConfig(this.showStart, this.showStart);
        int n = string.indexOf("ERROR");
        if (n >= 0) {
            System.err.println(string);
            this.serverOK = false;
            return;
        }
        this.navigator.setTree(string);
        this.createEnterpriseInfo();
        this.diag.setProgress(false);
        Vector<String> vector = new Vector<String>();
        vector.addElement("Enterprise");
        this.diag.setInfo("Enterprise", vector, 0);
        this.repaint();
        this.validate();
    }

    public void showHost(String string) {
        String string2;
        int n;
        this.diagHost = new String(string);
        if (!this.comm.setConnect(string)) {
            System.err.println("Can't connect to " + string);
            this.errorExit(true, this.rb.getString("error3"));
            return;
        }
        if (!this.comm.getVersion(string)) {
            System.err.println("Wrong agent version on " + string);
            this.errorExit(true, this.rb.getString("error9"));
            return;
        }
        if (this.agentName == null) {
            this.agentName = string;
        }
        if ((n = (string2 = this.comm.getConfig(string, this.agentName)).indexOf("ERROR")) >= 0) {
            System.err.println(string2);
            int n2 = string2.indexOf("rpc error");
            if (n2 >= 0) {
                this.errorExit(true, this.rb.getString("error3"));
            } else {
                this.errorExit(true, this.rb.getString("error4"));
            }
            return;
        }
        this.errorVectors.clear();
        this.navigator.setTree(string2);
        this.createInfo(string);
        this.diag.setHost(string);
        this.control.setControl(true);
        TestDevice testDevice = (TestDevice)this.testDevs.get(this.agentName);
        this.diag.setInfo(this.agentName, testDevice.getInfo(), testDevice.getStatus());
        this.diag.setProgress(true);
        this.comm.handleMessages(this.syRawReq, string);
        this.validate();
    }

    public void showUI() {
        this.add("North", this.control.panel);
        Dimension dimension = new Dimension(100, 450);
        this.navigator.panel.setMinimumSize(dimension);
        dimension = new Dimension(200, 450);
        this.navigator.panel.setPreferredSize(dimension);
        this.diag.panel.setMinimumSize(dimension);
        dimension = new Dimension(400, 450);
        this.diag.panel.setPreferredSize(dimension);
        this.splitPane = new JSplitPane(1, true, this.navigator.panel, this.diag.panel);
        this.add("Center", this.splitPane);
        this.validate();
        this.splitPane.setDividerLocation(160);
    }

    private void startTesting() {
        this.navigator.showSelected();
        Vector vector = this.navigator.getTestList();
        if (vector.size() < 1) {
            PopUpWindow popUpWindow = new PopUpWindow(this.rb.getString("Warning"), this.getEDFrame(), this.rb);
            popUpWindow.setMessage(this.rb.getString("Popup1"), true);
            ((Component)popUpWindow).setSize(300, 200);
            popUpWindow.show();
            this.control.resetButtons();
            return;
        }
        String string = this.comm.startTesting(this.diagHost, vector);
        if (this.debug) {
            System.out.println("select result " + string);
        }
        if (string.equals("NOTOK")) {
            if (this.debug) {
                System.out.println("none");
            }
            this.control.resetButtons();
        } else if (string.startsWith("DESELECT")) {
            if (this.debug) {
                System.out.println("select " + vector.toString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = new String(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = new String(stringTokenizer.nextToken());
                if (this.debug) {
                    System.out.println("deselect " + string3);
                }
                string2 = this.comm.filter.getDevice(string3);
                if (this.debug) {
                    System.out.println("remove " + string2);
                }
                vector.removeElement(string2);
            }
            if (this.debug) {
                System.out.println("select " + vector.toString());
            }
            this.diag.setTests(vector);
            this.testingNow = true;
        } else {
            this.diag.setTests(vector);
            this.testingNow = true;
        }
    }

    private void stopTesting() {
        this.testingNow = false;
        this.control.resetButtons();
        this.diag.resetPanel(1);
        String string = this.navigator.getVisitedNode();
        if (string != null) {
            TestDevice testDevice = (TestDevice)this.testDevs.get(string);
            this.diag.setInfo(string, testDevice.getInfo(), testDevice.getStatus());
            this.diag.panel.validate();
        }
    }

    private void storeConnect(String string) {
        int n;
        if (string == null) {
            if (this.debug) {
                System.out.println("conn msg is NULL");
            }
            return;
        }
        if (this.debug) {
            System.out.println("conn msg" + string);
        }
        if ((n = string.indexOf("ERROR")) > 0) {
            String string2 = "==66666=" + string.substring(9);
            this.storeError(string2);
            return;
        }
        int n2 = string.indexOf("INFO");
        if (n2 < 0) {
            String string3 = string.substring(9);
            this.diag.updateConnect(null, null, string3);
            return;
        }
        int n3 = string.indexOf("Diagnostic.") + 11;
        int n4 = string.indexOf(".", n3);
        String string4 = string.substring(n3, n4);
        n4 = n2 - 1;
        n3 = string.lastIndexOf(" ", n4 - 1);
        String string5 = string.substring(n3, n4);
        String string6 = String.valueOf(string5) + "(" + string4 + ")";
        if (this.debug) {
            System.out.println("raw fru=" + string6);
        }
        String string7 = this.comm.filter.getDevice(string6.trim());
        if (this.debug) {
            System.out.println("device=" + string7);
        }
        if (string7.equals("null")) {
            return;
        }
        n3 = n2 + 5;
        n4 = string.indexOf("<", n3);
        if (n4 < 0) {
            n4 = string.indexOf("|", n3);
            if (n4 < 0) {
                String string8 = string.substring(n3);
                this.diag.updateConnect(string7, null, string8);
            } else {
                String string9 = string.substring(n3, n4);
                this.diag.updateConnect(string7, null, string9);
            }
            return;
        }
        String string10 = string.substring(n3, n4);
        string10 = string10.trim();
        n3 = n4 + 1;
        if ((n4 = string.indexOf(">", n3)) < 0) {
            n4 = string.length();
        }
        String string11 = string.substring(n3, n4);
        this.diag.updateConnect(string7, string10, string11);
    }

    private void storeError(String string) {
        String string2;
        String string3;
        int n;
        int n2;
        Vector<String> vector;
        block32: {
            int n3;
            vector = new Vector<String>();
            if (string == null) {
                return;
            }
            if (this.debug) {
                System.out.println("err msg" + string);
            }
            if (string.indexOf("ERROREDA") > 0) {
                this.errorExit(true, this.rb.getString("error3"));
                return;
            }
            n2 = string.indexOf("==66666=") + 9;
            if (n2 > 8 && (n = string.indexOf("Connection test complete")) > -1) {
                return;
            }
            n = string.indexOf("|", n2);
            if (n < n2) {
                if (this.debug) {
                    System.err.println("Invalid error message");
                }
                return;
            }
            string3 = string.substring(n2, n);
            string3 = string3.trim();
            vector.addElement(string3);
            String string4 = this.rb.processMsg(string);
            if (this.debug) {
                System.out.println("translated error=" + string4);
            }
            if ((n3 = string4.indexOf("<")) > 0) {
                n2 = string4.lastIndexOf(" ", n3 - 2);
                if (n2 < n3) {
                    vector.addElement(string4.substring(0, n2));
                    vector.addElement(string4.substring(n2, n3 - 1));
                }
                n = string4.indexOf(">", n3);
                vector.addElement(string4.substring(n3, n + 1));
                n2 = n + 1;
                while (true) {
                    if ((n3 = string4.indexOf("<", n2)) - n2 > 3) {
                        vector.addElement(string4.substring(n2, n3 - 1));
                    } else if (n3 < 0) break block32;
                    n = string4.indexOf(">", n3) + 1;
                    vector.addElement(string4.substring(n3, n));
                    n2 = n;
                }
            }
            vector.addElement(string4);
        }
        int n4 = string3.indexOf(" AM");
        int n5 = string3.indexOf(" PM");
        int n6 = 1;
        int n7 = 6;
        if (n4 > 0 || n5 > 0) {
            n7 = 7;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " .");
        int n8 = stringTokenizer.countTokens();
        String string5 = new String(" ");
        String string6 = new String(" ");
        String string7 = new String(" ");
        int n9 = 0;
        while (n9 < n8) {
            string2 = new String(stringTokenizer.nextToken());
            if (n9 == n6) {
                string5 = string2;
            } else if (n9 == n7) {
                string6 = string2;
                break;
            }
            ++n9;
        }
        if (this.debug) {
            System.out.println("test " + string5);
        }
        if (this.debug) {
            System.out.println("raw fru " + string6);
        }
        n2 = string6.indexOf("/");
        n = string6.indexOf("(");
        if (n2 < 0) {
            string7 = n < 0 ? String.valueOf(string6) + "(" + string5 + ")" : String.valueOf(string6.substring(0, n)) + "(" + string5 + ")";
        } else if (n < n2) {
            string7 = String.valueOf(string6.substring(0, n)) + "(" + string5 + ")";
        } else if (n2 < n) {
            string7 = String.valueOf(string6.substring(n2 + 1, n)) + "(" + string5 + ")";
        } else if (n > 0) {
            string7 = String.valueOf(string6.substring(0, n)) + "(" + string5 + ")";
        } else if (n2 > 0) {
            n = string6.indexOf("s0");
            string7 = n < 0 ? String.valueOf(string6.substring(n2 + 1)) + "(" + string5 + ")" : String.valueOf(string6.substring(n2 + 1, n)) + "(" + string5 + ")";
        }
        if (this.debug) {
            System.out.println("fru=" + string7);
        }
        if ((string2 = this.comm.filter.getDevice(string7)).equals("null")) {
            return;
        }
        if (this.debug) {
            System.out.println("device=" + string2);
        }
        this.errorVectors.put(string2, vector);
        this.diag.updateFailure(string2, (String)vector.elementAt(1));
    }

    private void suspendTesting() {
        this.comm.suspendTesting(this.diagHost);
        this.diag.resetPanel(0);
    }

    public String translate(String string, String string2, Object[] objectArray) {
        if (this.debug) {
            System.out.println("file " + string + ", key " + string2);
        }
        String string3 = UcInternationalizer.translateKey((String)("com.sun.entdiag.ui.msg." + string + ":" + string2));
        if (this.debug) {
            System.out.println("msg text " + string3);
        }
        if (objectArray.length > 0) {
            String string4 = MessageFormat.format(string3, objectArray);
            if (this.debug) {
                System.out.println("msg final " + string4);
            }
            return string4;
        }
        return string3;
    }

    public void updateEDTree() {
        int n = this.comm.getStatus(this.diagHost, null);
        if (this.debug) {
            System.out.println("status " + n);
        }
        if (n != 2) {
            Vector vector = this.navigator.getAllNames();
            int n2 = 1;
            while (n2 < vector.size()) {
                String string = (String)vector.elementAt(n2);
                int n3 = this.comm.getStatus(this.diagHost, string);
                n3 = (n3 + 1) % 3;
                if (this.debug) {
                    System.out.println(String.valueOf(string) + " status " + n3);
                }
                this.updateNode(string, n3, null);
                ++n2;
            }
        }
    }

    private void updateNode(String string, int n, String string2) {
        if (string == null) {
            return;
        }
        treeDev = string;
        treeStat = n;
        Runnable runnable = new Runnable(){

            public void run() {
                if (EDPanel.this.debug) {
                    System.out.println("Dev " + treeDev + " stat " + treeStat);
                }
                EDPanel.this.navigator.updateTree(treeDev, treeStat);
                if (EDPanel.this.debug) {
                    System.out.println("back from tree update");
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
        TestDevice testDevice = (TestDevice)this.testDevs.get(string);
        if (testDevice == null) {
            return;
        }
        testDevice.setStatus(n);
        this.testDevs.remove(string);
        this.testDevs.put(string, testDevice);
    }

    private void visitNode(String string) {
        this.navigator.visitTree(string);
    }

    class Waiting
    extends Thread {
        private String text;
        private int action;

        public Waiting(int n) {
            this.action = n;
        }

        public void run() {
            if (EDPanel.this.debug) {
                System.out.println("I'm in thread");
            }
            switch (this.action) {
                case 0: {
                    EDPanel.this.fillUI();
                    break;
                }
                case 1: {
                    int n = 0;
                    while (true) {
                        ++n;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.out.println(interruptedException.toString());
                        }
                        if (n != 3 && n == 4) {
                            n = 0;
                        }
                        if (!EDPanel.this.debug) continue;
                        System.out.println("count " + n);
                    }
                }
                case 2: {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException.toString());
                    }
                    break;
                }
            }
            if (EDPanel.this.debug) {
                System.out.println("I'm out of thread");
            }
        }

        public void setMessage(String string) {
            this.text = new String(string);
        }
    }
}

