/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.dataview;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.view.SMDataView;
import com.sun.symon.base.client.view.SMViewData;
import com.sun.symon.base.client.view.SMViewInfo;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.views.dataview.CvDataviewEditor;
import com.sun.symon.base.console.views.dataview.util.DataviewUtil;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcConfirmDialog;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcThreadWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CvDataviewManager
extends JDialog
implements SMDBChangeListener,
ActionListener {
    private static CvDataviewManager dvManager = null;
    private int[] usedNo = new int[100];
    private Vector editorsVec = new Vector();
    private JButton createBtn;
    private JButton openBtn;
    private JButton deleteBtn;
    private JButton closeBtn;
    private JButton helpBtn;
    private JLabel statusLbl;
    private JList dvLst;
    private JTextArea descArea;
    private Image image;
    public SMRawDataRequest dataHandle;
    public SMDataView dataviewHandle;
    private SMViewInfo[] dataviews;

    public CvDataviewManager(Frame frame) throws SMAPIException {
        super(frame);
        int n = 0;
        while (n < 100) {
            this.usedNo[n] = 0;
            ++n;
        }
        this.setTitle(DataviewUtil.getI18nMsg("manager.title"));
        try {
            this.dataHandle = SMConsoleContext.getInstance().getAPIHandle();
            this.dataviewHandle = new SMDataView(this.dataHandle);
        }
        catch (SMAPIException sMAPIException) {
            throw new SMAPIException(sMAPIException.getReasonCode(), "DataviewMgr.ServiceErrorDialog.Message");
        }
        UcCommon.isServiceLicenseAvailable((String)"View_ViewService", (Component)frame);
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.dataHandle);
        this.image = sMResourceAccess.getImage("stdimages/symon-small.gif");
        this.createGUI();
        this.installListeners();
        final Frame frame2 = frame;
        Runnable runnable = new Runnable(){

            public void run() {
                this.addDBListener(frame2);
            }
        };
        new Thread(runnable).start();
        UcThreadWorker ucThreadWorker = new UcThreadWorker(){

            public void doWork() {
                CvDataviewManager.this.changed(null);
            }
        };
        ucThreadWorker.start();
        dvManager = this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createBtn) {
            this.showEditor(null, true);
        } else if (object == this.openBtn) {
            int n = this.dvLst.getSelectedIndex();
            this.showEditor(this.dataviews[n], false);
        } else if (object == this.closeBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-dataview-manager-help");
        } else if (object == this.deleteBtn) {
            String[] stringArray = new String[]{DataviewUtil.getI18nMsg("manager.delete"), DataviewUtil.getI18nMsg("manager.cancel")};
            UcConfirmDialog ucConfirmDialog = new UcConfirmDialog((Dialog)this, DataviewUtil.getI18nMsg("standard.warn"), DataviewUtil.getI18nMsg("manager.deleteBoldMsg"), DataviewUtil.getI18nMsg("manager.deletePlainMsg"), stringArray);
            ucConfirmDialog.pack();
            ucConfirmDialog.setLocationRelativeTo(this);
            ucConfirmDialog.setVisible(true);
            if (ucConfirmDialog.getClicked() == 1) {
                return;
            }
            UcThreadWorker ucThreadWorker = new UcThreadWorker(){

                public void doWork() {
                    CvDataviewManager.this.deleteDataview();
                }
            };
            ucThreadWorker.start();
        }
    }

    void addDBListener(Frame frame) {
        try {
            this.dataviewHandle.addViewChangeListener((SMDBChangeListener)this);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)frame, (Object)sMAPIException.getMessage());
        }
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) {
        this.statusLbl.setText(DataviewUtil.getI18nMsg("manager.loadDataview"));
        try {
            this.dataviews = this.dataviewHandle.getAll();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            this.statusLbl.setText(" ");
            return;
        }
        int n = 0;
        if (this.dataviews != null) {
            n = this.dataviews.length;
        }
        final String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(this.dataviews[n2].getName()) + "[" + UcInternationalizer.translateKey((String)this.dataviews[n2].getDomain()) + "]";
            ++n2;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                int n = dvLst.getSelectedIndex();
                dvLst.clearSelection();
                dvLst.setListData(stringArray);
                if (stringArray.length > n && n != -1) {
                    dvLst.setSelectedIndex(n);
                }
                statusLbl.setText(" ");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    void close() {
        ((Component)this).setVisible(false);
        this.closeInstance();
    }

    public void closeChild(CvDataviewEditor cvDataviewEditor) {
        this.editorsVec.remove(cvDataviewEditor);
        this.closeInstance();
    }

    private void closeInstance() {
        if (this.editorsVec.isEmpty() && !this.isVisible()) {
            try {
                this.dataviewHandle.close();
            }
            catch (SMAPIException sMAPIException) {
                UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
            }
            this.dispose();
            dvManager = null;
        }
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(DataviewUtil.getI18nMsg("manager.dvLbl"));
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.dvLst = new JList();
        this.dvLst.setSelectionMode(0);
        this.dvLst.setBackground(jPanel2.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.dvLst);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jLabel = new JLabel(DataviewUtil.getI18nMsg("manager.descLbl"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.2;
        this.descArea = new JTextArea(2, 10);
        this.descArea.setEditable(false);
        this.descArea.setBackground(jPanel2.getBackground());
        this.descArea.setMinimumSize(this.descArea.getPreferredSize());
        jScrollPane = new JScrollPane(this.descArea);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.createBtn = new JButton(DataviewUtil.getI18nMsg("manager.creatBtn"));
        gridBagLayout.setConstraints(this.createBtn, gridBagConstraints);
        jPanel2.add(this.createBtn);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.openBtn = new JButton(DataviewUtil.getI18nMsg("manager.openBtn"));
        this.openBtn.setEnabled(false);
        gridBagLayout.setConstraints(this.openBtn, gridBagConstraints);
        jPanel2.add(this.openBtn);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        this.deleteBtn = new JButton(DataviewUtil.getI18nMsg("manager.deleteBtn"));
        this.deleteBtn.setEnabled(false);
        gridBagLayout.setConstraints(this.deleteBtn, gridBagConstraints);
        jPanel2.add(this.deleteBtn);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel3, "South");
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, "North");
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 2, 0));
        jPanel4.setBorder(new EmptyBorder(10, 0, 10, 10));
        this.closeBtn = new JButton(DataviewUtil.getI18nMsg("manager.closeBtn"));
        jPanel4.add(this.closeBtn);
        this.helpBtn = new JButton(DataviewUtil.getI18nMsg("manager.helpBtn"));
        jPanel4.add(this.helpBtn);
        jPanel3.add((Component)jPanel4, "East");
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setForeground(Color.black);
        this.statusLbl.setBorder(new EmptyBorder(0, 10, 0, 0));
        jPanel3.add((Component)this.statusLbl, "South");
        this.openBtn.addActionListener(this);
        this.createBtn.addActionListener(this);
        this.deleteBtn.addActionListener(this);
        this.closeBtn.addActionListener(this);
        this.helpBtn.addActionListener(this);
    }

    public void delete(String string) {
        int n = 0;
        while (n < this.dataviews.length) {
            if (this.dataviews[n].getName().equals(string)) {
                try {
                    this.dataviewHandle.delete(this.dataviews[n]);
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
                }
                break;
            }
            ++n;
        }
    }

    void deleteDataview() {
        int n = this.dvLst.getSelectedIndex();
        try {
            this.dataviewHandle.delete(this.dataviews[n]);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
        }
    }

    CvDataviewEditor getChildEditor(SMViewInfo sMViewInfo) {
        int n = this.editorsVec.size();
        int n2 = 0;
        while (n2 < n) {
            CvDataviewEditor cvDataviewEditor = (CvDataviewEditor)this.editorsVec.elementAt(n2);
            if (cvDataviewEditor.getDataviewName().equals(sMViewInfo.getName()) && cvDataviewEditor.getDomain() != null && cvDataviewEditor.getDomain().equals(sMViewInfo.getDomain())) {
                return cvDataviewEditor;
            }
            ++n2;
        }
        return null;
    }

    public static CvDataviewManager getInstance() {
        return dvManager;
    }

    synchronized String getNewDataviewName() {
        String string = null;
        String string2 = DataviewUtil.getI18nMsg("editor.untitle");
        try {
            int n = 1;
            while (true) {
                string = String.valueOf(string2) + "_" + n;
                SMViewInfo sMViewInfo = new SMViewInfo();
                sMViewInfo.setName(string);
                SMConsoleContext sMConsoleContext = SMConsoleContext.getInstance();
                String string3 = sMConsoleContext.getCurrentDomain();
                sMViewInfo.setDomain(string3);
                if (this.getChildEditor(sMViewInfo) != null) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    void installListeners() {
        this.dvLst.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    CvDataviewManager.this.openBtn.setEnabled(false);
                    CvDataviewManager.this.deleteBtn.setEnabled(false);
                } else {
                    CvDataviewManager.this.openBtn.setEnabled(true);
                    CvDataviewManager.this.deleteBtn.setEnabled(true);
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        int n = CvDataviewManager.this.dvLst.getSelectedIndex();
                        String string = CvDataviewManager.this.dataviews[n].getDescription();
                        CvDataviewManager.this.descArea.setText(string);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CvDataviewManager.this.close();
            }
        });
    }

    public void showEditor(final SMViewInfo sMViewInfo, final boolean bl) {
        Object object;
        CvDataviewManager cvDataviewManager = this;
        if (sMViewInfo != null && (object = this.getChildEditor(sMViewInfo)) != null) {
            if (((Frame)object).getState() == 1) {
                ((Frame)object).setState(0);
            }
            ((Component)object).setVisible(true);
            return;
        }
        object = new UcThreadWorker(){

            public void doWork() {
                Object object;
                SMViewData sMViewData = null;
                int n = 0;
                if (sMViewInfo != null) {
                    try {
                        sMViewData = dataviewHandle.load(sMViewInfo);
                    }
                    catch (SMAPIException sMAPIException) {
                        UcDialog.showError((Component)this, (Object)sMAPIException.getMessage());
                        return;
                    }
                }
                sMViewData = new SMViewData();
                try {
                    sMViewData.setName(this.getNewDataviewName());
                    sMViewData.setDescription("");
                    object = SMConsoleContext.getInstance();
                    sMViewData.setDomain(object.getCurrentDomain());
                }
                catch (SMAPIException sMAPIException) {}
                n = bl ? 1 : 2;
                object = new CvDataviewEditor(this, sMViewData, n);
                ((Frame)object).setIconImage(image);
                editorsVec.addElement(object);
                ((Component)object).setVisible(true);
            }
        };
        ((Thread)object).start();
    }
}

