rem $Header: utlfile.sql 09-mar-99.14:21:01 surman Exp $
rem
rem  Copyright (c) 1995, 1996, 1997, 1998, 1999 by Oracle Corporation
rem    NAME
rem      utlfile.sql - PL/SQL Package of File I/O routines
rem                    Package spec of UTL_FILE
rem
rem    DESCRIPTION
rem      Routines to perform File I/O
rem
rem    NOTES
rem      The procedural option is needed to use this facility.
rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      03/09/99 - Merge 786946 to 8.1
Rem    surman      02/18/99 - 786946: Add pragma RESTRICT_REFERENCES
Rem    surman      09/22/98 - 651602: Increase max number of open files        
Rem    surman      10/29/97 - Merge 458336 to 8.1.0
Rem    surman      09/16/97 - 458336: Add max_linesize to FOPEN
Rem    rdasarat    10/04/96 - Forward merge 377621
Rem    dposner     03/13/95 - Changing integer to binary
Rem    dposner     03/10/95 - UTL_FILE package, icds
Rem    dposner     03/10/95 - Created

REM ********************************************************************
REM THE FUNCTIONS SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL INTERFACE
REM ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE RELEASES.
REM ********************************************************************

REM ********************************************************************
REM THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
REM THIS PACKAGE MUST NOT BE    dposner    03/13/95 - Changing integer to binar
REM THIS PACKAGE MUST NOT BE    dposner    03/10/95 - UTL_FILE package, icds
REM COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE
REM RDBMS.  SPECIFICALLY, THE PSD* ROUTINES MUST NOT BE CALLED
REM DIRECTLY BY ANY CLIENT AND MUST REMAIN PRIVATE TO THE PACKAGE BODY.
REM ********************************************************************

CREATE OR REPLACE PACKAGE utl_file AS

  /*
  ** FILE_TYPE - File handle
  */
  TYPE file_type IS RECORD (id BINARY_INTEGER);

  /*
  ** Exceptions
  */
  invalid_path       EXCEPTION;
  invalid_mode       EXCEPTION;
  invalid_filehandle EXCEPTION;
  invalid_operation  EXCEPTION;
  read_error         EXCEPTION;
  write_error        EXCEPTION;
  internal_error     EXCEPTION;


  /* FOPEN - open file (no maximum line size)
  **
  ** This version of FOPEN does not take a parameter for the maximum line
  ** size.  Thus, the default (which is 1023 on most systems) will be used.
  ** To specify a different max line size, use the version of FOPEN found at
  ** the end of this package (located there for compatibility reasons).
  ** 
  ** As of 8.0.6, you can have a maximum of 50 files open simultaneously.
  **
  ** IN
  **   location     - directory location of file
  **   filename     - file name (including extention)
  **   open_mode    - open mode ('r', 'w', 'a')
  ** RETURN
  **   file_type handle to open file
  ** EXCEPTIONS
  **   invalid_path        - file location or name was invalid
  **   invalid_mode        - the open_mode string was invalid
  **   invalid_operation   - file could not be opened as requested
  */
  FUNCTION fopen(location  IN VARCHAR2,
                 filename  IN VARCHAR2,
                 open_mode IN VARCHAR2) RETURN file_type;
  PRAGMA RESTRICT_REFERENCES(fopen, WNDS, RNDS);

  /*
  ** IS_OPEN - Test if file handle is open
  **
  ** IN
  **   file - File handle
  ** RETURN
  **   BOOLEAN - Is file handle open/valid?
  */
  FUNCTION is_open(file IN file_type) RETURN BOOLEAN;
  PRAGMA RESTRICT_REFERENCES(is_open, WNDS, RNDS, WNPS, RNPS);

  /*
  ** FCLOSE - close an open file
  **
  ** IN
  **   file - File handle (open)
  ** EXCEPTIONS
  **   invalid_filehandle - not a valid file handle
  **   write_error        - OS error occured during write operation
  */
  PROCEDURE fclose(file IN OUT file_type);
  PRAGMA RESTRICT_REFERENCES(fclose, WNDS, RNDS);

  /*
  ** FCLOSE_ALL - close all open files for this session
  **
  ** For Emergency/Cleanup use only.  FILE_TYPE handles will not be
  ** cleared (IS_OPEN will still indicate they are valid)
  **
  ** IN
  **   file - File handle (open)
  ** EXCEPTIONS
  **   write_error        - OS error occured during write operation
  */
  PROCEDURE fclose_all;
  PRAGMA RESTRICT_REFERENCES(fclose_all, WNDS, RNDS);

  /*
  ** GET_LINE - Get (read) a line of text from the file
  **
  ** IN
  **   file - File handle (open in read mode)
  ** OUT
  **   buffer - next line of text in file
  ** EXCEPTIONS
  **   no_data_found      - reached the end of file
  **   value_error        - line to long to store in buffer
  **   invalid_filehandle - not a valid file handle
  **   invalid_operation  - file is not open for reading
  **   read_error         - OS error occurred during read
  */
  PROCEDURE get_line(file   IN file_type,
                     buffer OUT VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(get_line, WNDS, RNDS, WNPS, RNPS);

  /*
  ** PUT - Put (write) text to file
  **
  ** IN
  **   file   - File handle (open in write/append mode)
  **   buffer - Text to write
  ** EXCEPTIONS
  **   invalid_filehandle - not a valid file handle
  **   invalid_operation  - file is not open for writing/appending
  **   write_error        - OS error occured during write operation
  */
  PROCEDURE put(file   IN file_type,
                buffer IN VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(put, WNDS, RNDS);

  /*
  ** NEW_LINE - Write line terminators to file
  **
  ** IN
  **   file - File handle (open in write/append mode)
  **   lines - Number of newlines to write (default 1)
  ** EXCEPTIONS
  **   invalid_filehandle - not a valid file handle
  **   invalid_operation  - file is not open for writing/appending
  **   write_error        - OS error occured during write operation
  */
  PROCEDURE new_line(file  IN file_type,
                     lines IN NATURAL := 1);
  PRAGMA RESTRICT_REFERENCES(new_line, WNDS, RNDS);

  /*
  ** PUT_LINE - Put (write) line to file
  **
  ** IN
  **   file   - File handle (open in write/append mode)
  **   buffer - Text to write
  ** EXCEPTIONS
  **   invalid_filehandle - not a valid file handle
  **   invalid_operation  - file is not open for writing/appending
  **   write_error        - OS error occured during write operation
  */
  PROCEDURE put_line(file   IN file_type,
                     buffer IN VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(put_line, WNDS, RNDS);

  /*
  ** PUTF - Put (write) formatted text to file
  **
  ** Format string special characters
  **     '%s' - substitute with next argument
  **     '\n' - newline (line terminator)
  **
  ** IN
  **   file - File handle (open in write/append mode)
  **   format - Formatting string
  **   arg1 - Substitution argument #1
  **   ...
  ** EXCEPTIONS
  **   invalid_filehandle - not a valid file handle
  **   invalid_operation  - file is not open for writing/appending
  **   write_error        - OS error occured during write operation
  */
  procedure putf(file   IN file_type,
                 format IN VARCHAR2,
                 arg1   IN VARCHAR2 DEFAULT NULL,
                 arg2   IN VARCHAR2 DEFAULT NULL,
                 arg3   IN VARCHAR2 DEFAULT NULL,
                 arg4   IN VARCHAR2 DEFAULT NULL,
                 arg5   IN VARCHAR2 DEFAULT NULL);
  PRAGMA RESTRICT_REFERENCES(putf, WNDS, RNDS);

  /*
  ** FFLUSH - Force physical write of buffered output
  **
  ** IN
  **   file - File handle (open in write/append mode)
  ** EXCEPTIONS
  **   invalid_filehandle - not a valid file handle
  **   invalid_operation  - file is not open for writing/appending
  **   write_error        - OS error occured during write operation
  */
  PROCEDURE fflush(file IN file_type);
  PRAGMA RESTRICT_REFERENCES(fflush, WNDS, RNDS);

  invalid_maxlinesize  EXCEPTION;

  /*
  ** FOPEN - open file (user-specified maximum line size)
  **
  ** This version of FOPEN allows the user to specify the desired maximum
  ** line size.  The version with the default line size is earlier in this
  ** package, for compatibility reasons.
  ** 
  ** As of 8.0.6, you can have a maximum of 50 files open simultaneously.
  **
  ** IN
  **   location     - directory location of file
  **   filename     - file name (including extention)
  **   open_mode    - open mode ('r', 'w', 'a')
  **   max_linesize - maximum number of characters per line, including the
  **                  newline character, for this file.
  **                  (minimum value 1, maximum value 32767)
  ** RETURN
  **   file_type handle to open file
  ** EXCEPTIONS
  **   invalid_path        - file location or name was invalid
  **   invalid_mode        - the open_mode string was invalid
  **   invalid_operation   - file could not be opened as requested
  **   invalid_maxlinesize - specified max_linesize is too large or too small
  */
  FUNCTION fopen(location     IN VARCHAR2,
                 filename     IN VARCHAR2,
                 open_mode    IN VARCHAR2,
                 max_linesize IN BINARY_INTEGER) RETURN file_type;
  PRAGMA RESTRICT_REFERENCES(fopen, WNDS, RNDS);


END utl_file;
/
show errors
 
