#!/bin/sh

#
# This script used to remove a5x00 patch 
#
get_patch_name() {
        patch_required=""

        os_version=`/usr/bin/uname -r`

        if [ "$os_version" = "5.6" ] ; then
            patch_required="Q995601-02"
        elif [ "$os_version" = "5.7" ] ; then
            patch_required="Q995701-02"
        elif [ "$os_version" = "5.8" ] ; then
            patch_required="Q995801-01"
        else
            echo "No patch removal is required on this platform"
            return 1
        fi
        return 0
}

patches_available=`/usr/sbin/patchadd -p | /usr/bin/nawk '{ print $2 }'`
get_patch_name
if [ $? -ne 0 ]; then
  exit 1
fi
patch_number_found=`echo $patches_available | /usr/bin/grep -c $patch_required`
if [ $patch_number_found -eq 0 ] ; then
  echo "$patch_required not installed"
  exit 0
fi
/usr/sbin/patchrm $patch_required > /dev/null 2>&1
if [ $? -ne 0 ]; then
  echo "Patch removal has failed."
  echo "Please remove the patch $patch_required manually"
  exit 0
fi
echo "$patch_required has been successfully removed from the system"
exit 1

