#
#   File:    agent-stats-models-d.x
#   Author:  Andrew Hillier
#   Version: 1.15 02/06/27 13:35:45     
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#
#   OpenAgent Agent Statistics Managed Object and Property Model
#
   
    type = reference

    _rules = { [ use PROC ]
        [ source agent-stats-d.rul ]
    }

    objects = { [ use MANAGED-OBJECT ]
	mediumDesc	= Object Statistics

	consoleHint:mediumDesc = base.modules.agentStats:objects

	toeCount = { [ use INTHI MANAGED-PROPERTY ]
            shortDesc   	= Toe Count
            mediumDesc  	= Total Toe Objects
            fullDesc    	= The number of toe objects

	    consoleHint:mediumDesc = base.modules.agentStats:objects.toeCount

        }

	bobCount = { [ use INTHI MANAGED-PROPERTY ]
            shortDesc   	= Bob Count
            mediumDesc  	= Total Bobs
            fullDesc    	= The number of binary object buffers

	    consoleHint:mediumDesc = base.modules.agentStats:objects.bobCount

        }
    }

    commands = { [ use MANAGED-OBJECT ]

	mediumDesc		= Commands Executed
        mibTextPrefix		= cmd

	consoleHint:mediumDesc = base.modules.agentStats:commands
	
	total = { [ use COUNTERHI MANAGED-PROPERTY ]
            shortDesc   	= Command Count
            mediumDesc  	= Total Commands 
            fullDesc    	= The number of commands that have been executed

	    consoleHint:mediumDesc = base.modules.agentStats:commands.total

	}
	rate = { [ use FLOATHI MANAGED-PROPERTY ]
            shortDesc   	= Commands/sec 
            mediumDesc  	= Rate 
            fullDesc    	= The number of commands executed per second
	    units		= /sec

	    consoleHint:mediumDesc = base.modules.agentStats:commands.rate
            consoleHint:i18nunits = base.modules.agentStats:units.persecond

	}
    }

    transactions = { [ use MANAGED-OBJECT ]

	mediumDesc		= Transactions Performed
        mibTextPrefix		= trans

	consoleHint:mediumDesc = base.modules.agentStats:transactions

        total = { [ use COUNTERHI MANAGED-PROPERTY ]
            shortDesc   	= Transaction Count
            mediumDesc  	= Transaction Count
            fullDesc    	= The number of transactions performed by the agent 

	    consoleHint:mediumDesc = base.modules.agentStats:transactions.total

        }
        rate = { [ use FLOATHI MANAGED-PROPERTY ]
            shortDesc   	= Transactions/sec 
            mediumDesc  	= Transaction Rate
            fullDesc    	= The number of transactions performed by the agent per second 
	    units		= /sec

	    consoleHint:mediumDesc = base.modules.agentStats:transactions.rate
            consoleHint:i18nunits = base.modules.agentStats:units.persecond

	}
    }

    procstats = { [ use MANAGED-OBJECT ]

	mediumDesc		= PA Process Statistics

	consoleHint:mediumDesc = base.modules.agentStats:procstats

	pid = { [ use INT MANAGED-PROPERTY ] 
	    shortDesc           = PID
            mediumDesc          = Process ID
            fullDesc            = Process ID

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.pid
            consoleHint:exclusions = "!graph !mark"

        }

        id = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = Id
            mediumDesc          = Process Unique Id
            fullDesc            = The name of the process
 
            consoleHint:mediumDesc = base.modules.agentStats:procstats.id
            consoleHint:hidden = true
 
        }

	name = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = Name
            mediumDesc          = Process Name
            fullDesc            = The name of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.name

        }
 
        info = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = Status
            mediumDesc          = Process Status
            fullDesc            = The status of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.info
            consoleHint:hidden = true

        }
 
        state = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = State
            mediumDesc          = Process State
            fullDesc            = The state of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.state

        }
 
        uid = { [ use INT MANAGED-PROPERTY ]
            shortDesc           = UID
            mediumDesc          = User ID
            fullDesc            = The user id of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.uid
            consoleHint:exclusions = "!graph !mark"
 
        }
 
        size = { [ use INTRULE MANAGED-PROPERTY _rules ]
            shortDesc           = Proc Sz
            mediumDesc          = Virtual Size
            fullDesc            = The total size of the process
            units               = " KB"

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.size
            consoleHint:i18nunits = base.modules.agentStats:units.kb

        }
 
        rss = { [ use INTRULE MANAGED-PROPERTY _rules ]
            shortDesc           = Res Sz
            mediumDesc          = Resident Set Size
            fullDesc            = The resident size of the process
            units               = " KB"

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.rss
            consoleHint:i18nunits = base.modules.agentStats:units.kb

        }
 
        starttime = { [ use INT MANAGED-PROPERTY ]
            shortDesc           = Start Sec
            mediumDesc          = Start Time Seconds
            fullDesc            = The startup time of the process in seconds since January  1, 1970
            units               = sec

	    consoleHint:hidden = true

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.starttime
            consoleHint:i18nunits = base.modules.agentStats:units.sec

        }
 
        startdatestring = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = Start
            mediumDesc          = Start Date 
            fullDesc            = The startup date of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.startdatestring

        }

        starttimestring = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = Start
            mediumDesc          = Start Time 
            fullDesc            = The startup time of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.starttimestring

        }

        cputime = { [ use INT MANAGED-PROPERTY ]
            shortDesc           = CPUtime
            mediumDesc          = CPU Time
            fullDesc            = The CPU time used by the process
            units               = sec

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.cputime
            consoleHint:i18nunits = base.modules.agentStats:units.sec

        }
 
        pctcputime = { [ use PERCENTHI MANAGED-PROPERTY ]
            shortDesc           = PctCPUtime
            mediumDesc          = Percent CPU Time
            fullDesc            = The percentage of CPU time used by the process
            units               = %

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.pctcputime
            consoleHint:i18nunits = base.modules.agentStats:units.percent

        }

        context = { [ use INT MANAGED-PROPERTY ]
            shortDesc           = CntxtSw
            mediumDesc          = Context Switches
            fullDesc            = The context switches of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.context

        }
        syscalls = { [ use INT MANAGED-PROPERTY ]
            shortDesc           = SysCalls
            mediumDesc          = System Calls
            fullDesc            = The system calls made by the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.syscalls

        }
        command = { [ use STRING MANAGED-PROPERTY ]
            shortDesc           = Cmd
            mediumDesc          = Command Line
            fullDesc            = The command line of the process

	    consoleHint:mediumDesc = base.modules.agentStats:procstats.command

        }
    }    

    totalstats = { [ use MANAGED-OBJECT ]
	mediumDesc		= PA Total Process Statistics
        mibTextPrefix		= total

	consoleHint:mediumDesc = base.modules.agentStats:totalstats

        count = { [ use INTHI MANAGED-PROPERTY ]
            shortDesc           = Count
            mediumDesc          = Number of Processes
            fullDesc            = The Number of Agent and Child Processes

	    consoleHint:mediumDesc = base.modules.agentStats:totalstats.count

        }
        size = { [ use INTRULE MANAGED-PROPERTY _rules ]
            shortDesc           = Size
            mediumDesc          = Total Virtual Size
            fullDesc            = The Total Virtual Size of Agent and Children
            units		= " KB"

	    consoleHint:mediumDesc = base.modules.agentStats:totalstats.size
            consoleHint:i18nunits = base.modules.agentStats:units.kb

        }
        rss = { [ use INTRULE MANAGED-PROPERTY _rules ]
            shortDesc           = Res Sz
            mediumDesc          = Total Res Size
            fullDesc            = The Total Res Size of Agent and Children
            units		= " KB"

	    consoleHint:mediumDesc = base.modules.agentStats:totalstats.rss
            consoleHint:i18nunits = base.modules.agentStats:units.kb

        }
    }

    [ load agent-stats-ruleinit-d.x ]
    [ load agent-stats-ruletext-d.x ]

