/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.table.SMTableColumnFormat;
import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.console.didgets.CdPropValueEditorPane;
import com.sun.symon.base.console.grouping.task.CgDrillDownEvent;
import com.sun.symon.base.console.grouping.task.CgDrillDownListener;
import com.sun.symon.base.console.grouping.task.CgHierarchyManager;
import com.sun.symon.base.console.grouping.task.CgPropTable;
import com.sun.symon.base.console.grouping.task.CgPropertyEvent;
import com.sun.symon.base.console.grouping.task.CgPropertyListener;
import com.sun.symon.base.console.grouping.task.CgTaskUtility;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;

public class CgPropChooser
extends JDialog
implements CgDrillDownListener {
    static final String TITLE_PROP = "pc.propTitle";
    static final String COLUMN_RADIO = "pc.colRadioBtn";
    static final String CELL_RADIO = "pc.cellRadioBtn";
    static final String COLUMN_ACT_CMD = "Column_Act";
    static final String CELL_ACT_CMD = "Cell_Act";
    static final String PROP_LABEL = "pc.propLabel";
    static final String SCOPE_LABEL = "pc.scopeLabel";
    static final String APPLY_BTN = "pc.applyBtn";
    static final String OK_BTN = "standard.ok";
    static final String CLOSE_BTN = "pc.closeBtn";
    static final String PROPERTY_NAME = "pc.propName";
    static final String PROPERTY_VALUE = "pc.propValue";
    static final String ADD_SPEC = "pc.addSpec";
    static final String MOD_INST = "pc.modInst";
    static final String ACTION_LABEL = "pc.actLabel";
    static final String SCOPE_ACT_CMD = "Scope_Act";
    static final String ROW_ACT_CMD = "Row_Act";
    static final String ADD_ROW = "pc.addRow";
    static final String MODIFY_ROW = "pc.modifyRow";
    static final String DELETE_ROW = "pc.deleteRow";
    static final String MSG_NO_SELECT = "pc.noSelMsg";
    static final String MSG_NO_VALUE = "pc.noValMsg";
    static final String MSG_NO_INST = "pc.noInstMsg";
    static final String MSG_WARNING = "pc.warningTitle";
    static final String MSG_REQUIRED = "pc.reqValue";
    private SMRawDataRequest rawReq = null;
    private SMTableRequest tabReq = null;
    private SMModuleRequest modReq = null;
    private CgHierarchyManager ch;
    private String baseUrl;
    private JLabel statusLabel;
    private JButton closeBtn;
    private JButton applyBtn;
    private JButton okBtn;
    private JTextField instFld;
    private JLabel instLabel;
    private JLabel reqLabel;
    private CgPropTable propTable;
    private JRadioButton[] radioBtns;
    private JRadioButton[] actionBtns;
    private JComboBox combo;
    private JSplitPane sPane;
    private ButtonGroup group;
    private ButtonGroup actionGroup;
    private boolean isTableScalar = false;
    private boolean isModMulti = false;
    private int tabInd = 0;
    private int propInd = 0;
    private final String[] operStr = new String[]{"add_row", "modify_row", "delete_row"};
    private SMTableFormat[] propData = null;
    private Vector propListeners = new Vector();

    public CgPropChooser(SMRawDataRequest sMRawDataRequest) {
        this.setTitle(this.translate(TITLE_PROP));
        this.rawReq = sMRawDataRequest;
        this.baseUrl = this.rawReq.getMDRBaseURL();
        this.tabReq = new SMTableRequest(sMRawDataRequest);
        this.modReq = new SMModuleRequest(sMRawDataRequest);
        this.start();
    }

    public void addNotify() {
        super.addNotify();
        this.sPane.setDividerLocation(250);
    }

    public synchronized void addPropertyListener(CgPropertyListener cgPropertyListener) {
        if (!this.propListeners.contains(cgPropertyListener)) {
            this.propListeners.addElement(cgPropertyListener);
        }
    }

    public String buildUrl(String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string2 = ucAgentURL.getModuleSpec();
        int n = string.indexOf(string2);
        String string3 = string.substring(n + string2.length());
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(ucAgentURL.getModuleId());
        if (this.isModMulti) {
            stringBuffer.append("+");
            stringBuffer.append(this.instFld.getText());
        }
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        return string4;
    }

    public void cleanUp() {
        this.ch.shutdown();
        this.ch = null;
    }

    public void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(17, 17, 17, 17));
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(this.translate(PROP_LABEL));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentX(0.0f);
        this.ch = new CgHierarchyManager(this.rawReq);
        jPanel2.add((Component)((Object)this.ch));
        this.propTable = new CgPropTable(null, this.rawReq);
        JScrollPane jScrollPane = new JScrollPane(this.propTable);
        jScrollPane.setAlignmentX(0.0f);
        TableColumnModel tableColumnModel = this.propTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(120);
        tableColumnModel.getColumn(1).setPreferredWidth(20);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "Center");
        this.reqLabel = new JLabel();
        this.reqLabel.setFont(this.reqLabel.getFont().deriveFont(0));
        this.reqLabel.setForeground(Color.red);
        jPanel3.add((Component)this.reqLabel, "South");
        this.sPane = new JSplitPane(1, jPanel2, jPanel3);
        this.sPane.setDividerLocation(250);
        Dimension dimension = new Dimension(100, 50);
        this.sPane.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setAlignmentX(0.0f);
        jPanel4.add(this.sPane);
        jScrollPane.setMinimumSize(dimension);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        jPanel.add(jPanel4);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        JLabel jLabel2 = new JLabel(this.translate(ADD_SPEC));
        jPanel.add(jLabel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setAlignmentX(0.0f);
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setAlignmentY(0.0f);
        this.instLabel = new JLabel(this.translate(MOD_INST));
        jPanel6.add(this.instLabel);
        jPanel6.add(Box.createRigidArea(new Dimension(12, 0)));
        this.instFld = new JTextField();
        this.instFld.setColumns(15);
        Dimension dimension2 = this.instFld.getPreferredSize();
        this.instFld.setMaximumSize(new Dimension(100, dimension2.height));
        jPanel6.add(this.instFld);
        jPanel6.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel6);
        this.actionGroup = new ButtonGroup();
        this.actionBtns = new JRadioButton[2];
        this.actionBtns[0] = new JRadioButton(this.translate(SCOPE_LABEL));
        this.actionBtns[1] = new JRadioButton(this.translate(ACTION_LABEL));
        this.actionBtns[0].setActionCommand(SCOPE_ACT_CMD);
        this.actionBtns[1].setActionCommand(ROW_ACT_CMD);
        this.actionBtns[0].setSelected(true);
        this.actionGroup.add(this.actionBtns[0]);
        this.actionGroup.add(this.actionBtns[1]);
        this.actionBtns[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgPropChooser.this.combo.setEnabled(false);
                CgPropChooser.this.radioBtns[1].setEnabled(true);
                CgPropChooser.this.radioBtns[1].setSelected(true);
                if (!CgPropChooser.this.isTableScalar) {
                    CgPropChooser.this.radioBtns[0].setEnabled(true);
                }
                CgPropChooser.this.applyBtn.setEnabled(true);
                CgPropChooser.this.okBtn.setEnabled(true);
                CgPropChooser.this.propTable.setEditStatus(0);
                CgPropChooser.this.reqLabel.setText(CgPropChooser.this.translate(CgPropChooser.MSG_REQUIRED));
            }
        });
        this.actionBtns[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgPropChooser.this.combo.setEnabled(true);
                CgPropChooser.this.combo.setSelectedIndex(0);
                CgPropChooser.this.radioBtns[0].setEnabled(false);
                CgPropChooser.this.radioBtns[1].setEnabled(false);
                CgPropChooser.this.applyBtn.setEnabled(true);
                CgPropChooser.this.okBtn.setEnabled(true);
                CgPropChooser.this.propTable.setEditStatus(2);
                CgPropChooser.this.reqLabel.setText(CgPropChooser.this.translate(CgPropChooser.MSG_REQUIRED));
            }
        });
        this.group = new ButtonGroup();
        this.radioBtns = new JRadioButton[2];
        this.radioBtns[0] = new JRadioButton(this.translate(COLUMN_RADIO));
        this.radioBtns[1] = new JRadioButton(this.translate(CELL_RADIO));
        this.radioBtns[0].setActionCommand(COLUMN_ACT_CMD);
        this.radioBtns[1].setActionCommand(CELL_ACT_CMD);
        this.radioBtns[1].setSelected(true);
        this.radioBtns[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgPropChooser.this.propTable.setEditStatus(1);
                CgPropChooser.this.reqLabel.setText("");
            }
        });
        this.radioBtns[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgPropChooser.this.propTable.setEditStatus(0);
                CgPropChooser.this.reqLabel.setText(CgPropChooser.this.translate(CgPropChooser.MSG_REQUIRED));
            }
        });
        this.group.add(this.radioBtns[0]);
        this.group.add(this.radioBtns[1]);
        JPanel jPanel7 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel7.setLayout(gridBagLayout);
        jPanel7.setAlignmentY(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.radioBtns[1], gridBagConstraints);
        jPanel7.add(this.radioBtns[1]);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.radioBtns[0], gridBagConstraints);
        jPanel7.add(this.radioBtns[0]);
        String[] stringArray = new String[]{this.translate(ADD_ROW), this.translate(MODIFY_ROW), this.translate(DELETE_ROW)};
        this.combo = new JComboBox<String>(stringArray);
        this.combo.setSelectedIndex(0);
        this.combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                int n = jComboBox.getSelectedIndex();
                if (n == 0) {
                    CgPropChooser.this.propTable.setEditStatus(2);
                    CgPropChooser.this.reqLabel.setText(CgPropChooser.this.translate(CgPropChooser.MSG_REQUIRED));
                } else {
                    CgPropChooser.this.propTable.setEditStatus(0);
                    CgPropChooser.this.reqLabel.setText(CgPropChooser.this.translate(CgPropChooser.MSG_REQUIRED));
                }
            }
        });
        JPanel jPanel8 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel8.setLayout(gridBagLayout2);
        jPanel8.setAlignmentY(0.0f);
        jPanel8.setBorder(new EmptyBorder(0, 0, 5, 10));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 100);
        gridBagLayout2.setConstraints(this.actionBtns[0], gridBagConstraints2);
        jPanel8.add(this.actionBtns[0]);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout2.setConstraints(this.actionBtns[1], gridBagConstraints2);
        jPanel8.add(this.actionBtns[1]);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagLayout2.setConstraints(jPanel7, gridBagConstraints2);
        jPanel8.add(jPanel7);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout2.setConstraints(this.combo, gridBagConstraints2);
        jPanel8.add(this.combo);
        jPanel5.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.setAlignmentX(0.0f);
        jPanel9.setBorder(new EmptyBorder(17, 17, 17, 17));
        jPanel9.add(Box.createHorizontalGlue());
        this.okBtn = new JButton(this.translate(OK_BTN));
        jPanel9.add(this.okBtn);
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgPropChooser.this.createTaskOper(true);
            }
        });
        this.okBtn.setEnabled(false);
        this.applyBtn = new JButton(this.translate(APPLY_BTN));
        jPanel9.add(this.applyBtn);
        this.applyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgPropChooser.this.createTaskOper(false);
            }
        });
        this.applyBtn.setEnabled(false);
        this.closeBtn = new JButton(this.translate(CLOSE_BTN));
        jPanel9.add(this.closeBtn);
        this.closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)CgPropChooser.this).setVisible(false);
            }
        });
        jPanel9.add(Box.createRigidArea(new Dimension(10, 0)));
        this.statusLabel = new JLabel("");
        this.statusLabel.setBorder(new EmptyBorder(0, 17, 17, 0));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel);
        container.add(new JSeparator());
        container.add(new JSeparator());
        container.add(jPanel9);
        container.add(this.statusLabel);
        this.setContentPane(container);
        this.actionBtns[0].setEnabled(false);
        this.actionBtns[1].setEnabled(false);
        this.radioBtns[0].setEnabled(false);
        this.radioBtns[1].setEnabled(false);
        this.combo.setEnabled(false);
        this.instLabel.setEnabled(false);
        this.instFld.setEnabled(false);
        String string = String.valueOf(this.baseUrl) + "sym/base/mibman/modules";
        this.ch.setFromMetadata(true);
        this.ch.setRootUrl(string);
        this.ch.addDrillDownListener(this);
        this.ch.activateBean();
        this.pack();
    }

    private void createTaskOper(boolean bl) {
        Object object;
        if (this.propTable.getSelectedRowCount() <= 0) {
            JOptionPane.showMessageDialog(null, this.translate(MSG_NO_SELECT), this.translate(MSG_WARNING), 2);
            return;
        }
        if (!this.propTable.isAllRequiredDataHaveValues()) {
            JOptionPane.showMessageDialog(null, this.translate(MSG_NO_VALUE), this.translate(MSG_WARNING), 2);
            return;
        }
        if (this.isModMulti && ((object = this.instFld.getText()) == null || ((String)object).length() == 0)) {
            JOptionPane.showMessageDialog(null, this.translate(MSG_NO_INST), this.translate(MSG_WARNING), 2);
            return;
        }
        object = this.propTable.getSelectedRows();
        SMTableFormat sMTableFormat = this.propTable.getTableFormat();
        Vector vector = this.propTable.getIndexRows();
        String string = this.actionGroup.getSelection().getActionCommand();
        if (string == SCOPE_ACT_CMD) {
            String[][] stringArray = new String[((Object)object).length][3];
            int n = 0;
            while (n < ((Object)object).length) {
                SMTableColumnFormat sMTableColumnFormat = sMTableFormat.getColumn((int)object[n]);
                stringArray[n][0] = this.getPropUrl(this.buildUrl(sMTableColumnFormat.getDataURL()));
                stringArray[n][1] = vector.indexOf(new Integer((int)object[n])) >= 0 ? "" : (String)this.propTable.getCurrentValueAt((int)object[n], 1);
                stringArray[n][2] = sMTableColumnFormat.getRawDataType();
                ++n;
            }
            this.firePropEvents(0, stringArray);
        } else {
            Vector<Integer> vector2 = new Vector<Integer>();
            int n = 0;
            while (n < this.propTable.getRowCount()) {
                if (this.propTable.isCellEditable(n, 1) && vector.indexOf(new Integer(n)) == -1) {
                    vector2.add(new Integer(n));
                }
                ++n;
            }
            int[] nArray = new int[vector2.size()];
            int n2 = 0;
            while (n2 < vector2.size()) {
                nArray[n2] = (Integer)vector2.elementAt(n2);
                ++n2;
            }
            vector2 = null;
            this.firePropEvents(1, this.getTaskData(sMTableFormat, nArray));
        }
        if (bl) {
            ((Component)this).setVisible(false);
        }
    }

    public void drillDownOccurred(CgDrillDownEvent cgDrillDownEvent) {
        SMTableFormat sMTableFormat = cgDrillDownEvent.getTableFormat();
        this.isTableScalar = sMTableFormat.getIsScalar();
        if (this.isTableScalar) {
            this.actionBtns[0].setEnabled(true);
            this.actionBtns[1].setEnabled(false);
            this.combo.setEnabled(false);
            this.radioBtns[0].setEnabled(false);
            this.radioBtns[1].setEnabled(true);
            this.actionBtns[0].setSelected(true);
            this.radioBtns[1].setSelected(true);
        } else {
            this.actionBtns[0].setEnabled(true);
            if (CgTaskUtility.hasRowAction(sMTableFormat)) {
                this.actionBtns[1].setEnabled(true);
            } else {
                this.actionBtns[1].setEnabled(false);
            }
            this.combo.setEnabled(false);
            this.radioBtns[0].setEnabled(true);
            this.radioBtns[1].setEnabled(true);
            this.actionBtns[0].setSelected(true);
            this.radioBtns[1].setSelected(true);
        }
        this.applyBtn.setEnabled(true);
        this.okBtn.setEnabled(true);
        UcAgentURL ucAgentURL = new UcAgentURL(cgDrillDownEvent.getTargetUrl());
        try {
            this.isModMulti = this.modReq.isModuleMultiInstances(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), ucAgentURL.getModuleId());
            if (this.isModMulti) {
                this.instFld.setEnabled(true);
                this.instLabel.setEnabled(true);
                this.instFld.setText("");
            } else {
                this.instFld.setEnabled(false);
                this.instLabel.setEnabled(false);
                this.instFld.setText("");
            }
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CgPropChooser.drillDownOccurredFailed to request module multi-instance info:" + (Object)((Object)sMAPIException)));
        }
        this.propTable.setNewData(sMTableFormat);
        this.propTable.setEditStatus(0);
        this.reqLabel.setText(this.translate(MSG_REQUIRED));
    }

    private void firePropEvents(int n, Object object) {
        Vector vector;
        CgPropertyEvent cgPropertyEvent = n == 0 ? new CgPropertyEvent((Object)this, (String[][])object) : new CgPropertyEvent((Object)this, (SMTaskOperationData[])object);
        CgPropChooser cgPropChooser = this;
        synchronized (cgPropChooser) {
            vector = (Vector)this.propListeners.clone();
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            CgPropertyListener cgPropertyListener = (CgPropertyListener)vector.elementAt(n2);
            try {
                cgPropertyListener.propertyChanged(cgPropertyEvent);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("firePropertyChangedEvents() - client error in property changed Occurred: " + exception));
            }
            ++n2;
        }
    }

    public String getEditAccess() {
        SMTableColumnFormat sMTableColumnFormat = this.propData[this.tabInd].getColumn(this.propInd);
        return sMTableColumnFormat.getEditAccess();
    }

    public String getPropUrl(String string) {
        String string2 = null;
        String string3 = this.group.getSelection().getActionCommand();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string);
        if (string3 == CELL_ACT_CMD) {
            String string4 = this.propTable.getIndexValues();
            if (string4 != null) {
                stringBuffer.append("#");
                stringBuffer.append(string4);
            }
            UcURL ucURL = new UcURL(stringBuffer.toString());
            string2 = ucURL.getPath();
        } else {
            String string5 = SMRawDataRequest.buildShadowURL((String)stringBuffer.toString(), null, null, (String)"ALL");
            UcURL ucURL = new UcURL(string5);
            string2 = ucURL.getPath();
        }
        string2 = "/" + string2;
        return string2;
    }

    public SMTaskOperationData[] getTaskData(SMTableFormat sMTableFormat, int[] nArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.combo.getSelectedIndex();
        SMTaskOperationData[] sMTaskOperationDataArray = n != 2 ? new SMTaskOperationData[nArray.length + 2] : new SMTaskOperationData[1];
        String[] stringArray = sMTableFormat.getIndexURLs();
        if (stringArray != null && stringArray.length >= 1) {
            string = stringArray[0].substring(0, stringArray[0].lastIndexOf(47));
            string = this.buildUrl(string);
            UcURL ucURL = new UcURL(string);
            stringBuffer.append("/");
            stringBuffer.append(ucURL.getPath());
            string = stringBuffer.toString();
        }
        try {
            sMTaskOperationDataArray[0] = new SMTaskOperationData();
            sMTaskOperationDataArray[0].setOperation(this.operStr[n]);
            sMTaskOperationDataArray[0].setOperand(string);
            sMTaskOperationDataArray[0].setUserData(this.propTable.getIndexValues());
            if (n != 2) {
                int n2 = 1;
                while (n2 <= nArray.length) {
                    SMTableColumnFormat sMTableColumnFormat = sMTableFormat.getColumn(nArray[n2 - 1]);
                    sMTaskOperationDataArray[n2] = new SMTaskOperationData();
                    string2 = sMTableColumnFormat.getDataURL();
                    string2 = string2.substring(string2.lastIndexOf(47) + 1);
                    sMTaskOperationDataArray[n2].setOperand(string2);
                    string3 = (String)this.propTable.getCurrentValueAt(nArray[n2 - 1], 1);
                    if (string3 == null || string3.length() == 0) {
                        sMTaskOperationDataArray[n2].setValue("");
                    } else {
                        sMTaskOperationDataArray[n2].setValue(string3);
                    }
                    sMTaskOperationDataArray[n2].setValueType(CdPropValueEditorPane.mapType((String)sMTableColumnFormat.getRawDataType()));
                    ++n2;
                }
                sMTaskOperationDataArray[nArray.length + 1] = SMTaskOperationData.getEndOperation();
            }
        }
        catch (SMLengthException sMLengthException) {
            UcDDL.logErrorMessage((String)("CgPropChooser.getTaskDataFailed to create SMTaskOperationData:" + (Object)((Object)sMLengthException)));
        }
        return sMTaskOperationDataArray;
    }

    public void start() {
        this.createGUI();
    }

    private String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.grouping.Grouping:" + string));
    }
}

