/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SyCoderInterface;
import com.sun.symon.base.security.SyEndSecureInterface;
import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.server.lookup.SlRMIClientSocket;
import com.sun.symon.base.server.lookup.SlRMIServerSocket;
import com.sun.symon.base.server.receptors.rmi.RMIDataComposer;
import com.sun.symon.base.server.receptors.rmi.RMIDataDecomposer;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.receptors.rmi.RMISessionInterface;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public abstract class RMIServerSession
extends UnicastRemoteObject
implements RMISessionInterface {
    private RMISecurityException SecurityException;
    private SySecurity security;
    private SyEndSecureInterface endSecure;
    private String privateKey;

    public RMIServerSession(SySecurity sySecurity, String string) throws RemoteException {
        this.init(sySecurity, string);
    }

    public RMIServerSession(SySecurity sySecurity, String string, String string2) throws RemoteException {
        super(0, new SlRMIClientSocket(string2), new SlRMIServerSocket(string2));
        this.init(sySecurity, string);
    }

    public byte[] authenticate(byte[] byArray) throws RemoteException {
        RMILoginException rMILoginException;
        try {
            RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.endSecure, true);
            String string = (String)rMIDataDecomposer.readObject();
            String string2 = (String)rMIDataDecomposer.readObject();
            this.doAuthenticate(string, string2);
            this.setSecurityException(null);
            rMILoginException = null;
        }
        catch (RMILoginException rMILoginException2) {
            rMILoginException = rMILoginException2;
        }
        return this.buildException(rMILoginException);
    }

    private byte[] buildException(Exception exception) throws RemoteException {
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.endSecure, false);
        rMIDataComposer.writeObject(exception);
        return rMIDataComposer.getBytes();
    }

    protected synchronized void checkSecurity() throws RMISecurityException {
        if (this.SecurityException != null) {
            throw this.SecurityException;
        }
    }

    public byte[] deleteRequest(byte[] byArray) throws RemoteException {
        RMISecurityException rMISecurityException;
        try {
            this.checkSecurity();
            RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.endSecure, false);
            String string = (String)rMIDataDecomposer.readObject();
            this.doDeleteRequest(string);
            rMISecurityException = null;
        }
        catch (RMISecurityException rMISecurityException2) {
            rMISecurityException = rMISecurityException2;
        }
        return this.buildException(rMISecurityException);
    }

    protected abstract void doAuthenticate(String var1, String var2) throws RMILoginException;

    protected abstract void doDeleteRequest(String var1) throws RMISecurityException;

    protected abstract String doGetURL(int var1);

    protected abstract void doNewRequest(int var1, String[] var2, StObject[][] var3, String var4, String var5) throws RMISecurityException;

    public byte[] getURL(byte[] byArray) throws RemoteException {
        RMISecurityException rMISecurityException;
        String string;
        Object object;
        try {
            this.checkSecurity();
            object = new RMIDataDecomposer(byArray, (SyCoderInterface)this.endSecure, false);
            int n = ((RMIDataDecomposer)object).readInt();
            string = this.doGetURL(n);
            rMISecurityException = null;
        }
        catch (RMISecurityException rMISecurityException2) {
            string = null;
            rMISecurityException = rMISecurityException2;
        }
        object = new RMIDataComposer((SyCoderInterface)this.endSecure, false);
        ((RMIDataComposer)object).writeObject(rMISecurityException);
        ((RMIDataComposer)object).writeObject(string);
        return ((RMIDataComposer)object).getBytes();
    }

    public void init(SySecurity sySecurity, String string) {
        this.SecurityException = new RMISecurityException(2, "not logged in");
        this.endSecure = null;
        this.privateKey = string;
        this.security = sySecurity;
    }

    public byte[] negotiate(String string, boolean bl, byte[] byArray) throws RemoteException, SySecurityException {
        try {
            this.endSecure = this.security.endSecureLookup(this.privateKey, string);
            return this.endSecure.negotiate(bl, byArray);
        }
        catch (SySecurityException sySecurityException) {
            UcDDL.logWarningMessage((String)"security negotiation failed", (Throwable)sySecurityException);
            throw sySecurityException;
        }
    }

    public byte[] newRequest(byte[] byArray) throws RemoteException {
        RMISecurityException rMISecurityException;
        try {
            this.checkSecurity();
            RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.endSecure, false);
            int n = rMIDataDecomposer.readInt();
            String[] stringArray = (String[])rMIDataDecomposer.readObject();
            StObject[][] stObjectArray = (StObject[][])rMIDataDecomposer.readObject();
            String string = (String)rMIDataDecomposer.readObject();
            String string2 = (String)rMIDataDecomposer.readObject();
            this.doNewRequest(n, stringArray, stObjectArray, string, string2);
            rMISecurityException = null;
        }
        catch (RMISecurityException rMISecurityException2) {
            rMISecurityException = rMISecurityException2;
        }
        return this.buildException(rMISecurityException);
    }

    protected boolean respond(RMIResponseInterface rMIResponseInterface, String string, String string2, Exception exception) throws RemoteException {
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.endSecure, false);
        rMIDataComposer.writeObject(string);
        rMIDataComposer.writeObject(exception);
        rMIDataComposer.writeObject(string2);
        byte[] byArray = rMIDataComposer.getBytes();
        byte[] byArray2 = rMIResponseInterface.receiveException(byArray);
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray2, (SyCoderInterface)this.endSecure, false);
        boolean bl = rMIDataDecomposer.readBoolean();
        return bl;
    }

    protected boolean respond(RMIResponseInterface rMIResponseInterface, String string, StObject[][] stObjectArray) throws RemoteException {
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.endSecure, false);
        rMIDataComposer.writeObject(string);
        rMIDataComposer.writeObject(stObjectArray);
        byte[] byArray = rMIDataComposer.getBytes();
        byte[] byArray2 = rMIResponseInterface.receiveDataResult(byArray);
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray2, (SyCoderInterface)this.endSecure, false);
        boolean bl = rMIDataDecomposer.readBoolean();
        return bl;
    }

    public synchronized void setSecurityException(RMISecurityException rMISecurityException) {
        this.SecurityException = rMISecurityException;
    }
}

