/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.alarm.SMAlarmMessage;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.FixListener;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class FixListener
extends JDialog
implements ActionListener {
    AlarmPanel ap;
    AlarmData[] ad;
    JTextArea sunmcFixArea = new JTextArea(5, 30);
    JTextArea userFixArea = new JTextArea(5, 30);
    SMAlarmMessage[] fixes;
    SMAlarmPageAsyncRequest request;
    int offset = 0;

    public FixListener(AlarmPanel alarmPanel, Frame frame) {
        super(frame, true);
        this.ap = alarmPanel;
        this.request = this.ap.getRequestHandle();
        this.setTitle(this.ap.translate("fixTitle"));
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.sunmcFixArea.setLineWrap(true);
        this.sunmcFixArea.setWrapStyleWord(true);
        this.sunmcFixArea.setBackground(container.getBackground());
        this.sunmcFixArea.setText(this.ap.translate("sunmcFixText"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), this.ap.translate("sunmcFix")));
        jPanel.add(this.sunmcFixArea);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        container.add((Component)new JLabel(this.ap.translate("userFix")), gridBagConstraints);
        this.userFixArea.setMargin(new Insets(2, 5, 0, 0));
        this.userFixArea.setLineWrap(true);
        this.userFixArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.userFixArea, 20, 31);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 0, 12);
        container.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 6, 0));
        JButton jButton = new JButton(this.ap.translate("ok"));
        jButton.setActionCommand("OK");
        class FixOKListener
        implements ActionListener {
            private final /* synthetic */ FixListener this$0;

            FixOKListener(FixListener fixListener) {
                this.this$0 = fixListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.this$0.userFixArea.getText().substring(this.this$0.offset);
                try {
                    this.this$0.request.setSuggestedFixes(this.this$0.ad[0].getUrl(), UcListUtil.UnicodeToAscii((String)string));
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showSMAPIexception((String)this.this$0.ap.translate("setAlarmFixException"), (SMAPIException)sMAPIException);
                    return;
                }
                ((Component)this.this$0).setVisible(false);
            }
        }
        FixOKListener fixOKListener = new FixOKListener(this);
        jButton.addActionListener(fixOKListener);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(this.ap.translate("cancel"));
        class FixCancelListener
        implements ActionListener {
            private final /* synthetic */ FixListener this$0;

            FixCancelListener(FixListener fixListener) {
                this.this$0 = fixListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)this.this$0).setVisible(false);
            }
        }
        jButton2.addActionListener(new FixCancelListener(this));
        jPanel2.add(jButton2);
        gridBagConstraints.insets = new Insets(17, 0, 11, 5);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel2, gridBagConstraints);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.show();
            return;
        }
        this.ad = this.ap.getAlarmTable().getAlarmData();
        if (this.ad.length != 1) {
            UcDialog.showOk((String)"pleaseSelectOneAlarm");
            return;
        }
        try {
            this.fixes = this.request.getSuggestedFixes(this.ad[0].getUrl());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.ap.translate("getFixException"), (SMAPIException)sMAPIException);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        int n = 0;
        while (n < this.fixes.length) {
            long l = Long.parseLong(this.fixes[n].getTime().trim()) * 1000L;
            string = dateFormat.format(new Date(l));
            stringBuffer.append(String.valueOf(string) + " " + this.fixes[n].getUser() + "\n");
            stringBuffer.append(String.valueOf(UcListUtil.AsciiToUnicode((String)this.fixes[n].getMessage())) + "\n\n");
            ++n;
        }
        this.userFixArea.setText(stringBuffer.toString());
        this.offset = stringBuffer.length();
        ((Component)this).setVisible(true);
    }
}

