/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.client.alarm.SMAlarmPageResponse;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmList;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.AlarmTableModel;
import com.sun.symon.base.console.alarms.CellRenderer;
import com.sun.symon.base.console.alarms.HeaderRenderer;
import com.sun.symon.base.utility.UcDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class AlarmTable
extends JTable
implements SMAlarmPageResponse {
    private final int PAGE_SIZE = 50;
    private final int VISIBLE_ROWS = 10;
    private int columns;
    private boolean firstTime = true;
    private String[] selectedIDs = new String[0];
    private JLabel status;
    private AlarmPanel alarmPanel;
    private AlarmList alarmList = new AlarmList();
    private AlarmData[] selectedADs = new AlarmData[0];
    private AlarmTableModel tableModel;
    private SMRawDataRequest rawRequest;
    private SMAlarmPageAsyncRequest request;
    int sortColumn = 1;
    boolean[] descend;

    public AlarmTable(AlarmTableModel alarmTableModel) {
        boolean[] blArray = new boolean[5];
        blArray[1] = true;
        this.descend = blArray;
        this.tableModel = alarmTableModel;
    }

    AlarmData[] getAlarmData() {
        return this.selectedADs;
    }

    AlarmList getAlarmList() {
        return this.alarmList;
    }

    boolean getDescend() {
        return this.descend[this.sortColumn];
    }

    public void getExceptionResponse(SMRequestStatus sMRequestStatus, Object object) {
    }

    void getPageOfAlarms(int n) {
        try {
            this.request.pageHostAlarms(this.alarmPanel.getRequestId(), n, (SMAlarmPageResponse)this, new Object());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("pageReqException"), (SMAPIException)sMAPIException);
        }
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        Dimension dimension = this.getIntercellSpacing();
        if (n == 1) {
            return this.rowHeight + dimension.height;
        }
        return 1;
    }

    String[] getSelectedIDs() {
        return this.selectedIDs;
    }

    int getSortColumn() {
        return this.sortColumn;
    }

    public void init() {
        Object object;
        int n = 0;
        boolean bl = false;
        this.request = this.alarmPanel.getRequestHandle();
        this.status = this.alarmPanel.getWindowStatusField();
        if (this.status != null) {
            this.status.setText("");
        }
        this.setModel(this.tableModel);
        this.setAutoCreateColumnsFromModel(true);
        this.setRowHeight(20);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(3);
        this.columns = this.tableModel.getColumnCount();
        AlarmData alarmData = new AlarmData(this.alarmPanel, this.columns);
        int n2 = 0;
        while (n2 < this.columns) {
            object = this.getColumnName(n2);
            TableColumn tableColumn = this.getColumn(object);
            HeaderRenderer headerRenderer = new HeaderRenderer();
            CellRenderer cellRenderer = new CellRenderer();
            Component component = headerRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), true, false, 0, 0);
            int n3 = component.getPreferredSize().width;
            component = cellRenderer.getTableCellRendererComponent(this, alarmData.cell[n2], false, false, 0, n2);
            int n4 = component.getPreferredSize().width;
            int n5 = Math.max(n3, n4);
            if (this.getColumnName(n2).compareTo("Start Time") == 0) {
                n5 += 8;
            }
            tableColumn.setMinWidth(n5);
            if (n2 != 4) {
                tableColumn.setMaxWidth(n5);
            }
            tableColumn.setResizable(true);
            tableColumn.setHeaderRenderer(headerRenderer);
            tableColumn.setCellRenderer(cellRenderer);
            n += tableColumn.getPreferredWidth() + 1;
            ++n2;
        }
        this.sizeColumnsToFit(this.columns - 1);
        object = this.getTableHeader();
        ((Component)object).addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 2) {
                    return;
                }
                TableColumnModel tableColumnModel = AlarmTable.this.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = AlarmTable.this.convertColumnIndexToModel(n);
                AlarmTable.this.descend[n2] = !AlarmTable.this.descend[n2];
                AlarmTable.this.sortColumn = n2;
                AlarmTable.this.selectAlarms();
            }
        });
    }

    public void pageHostAlarmResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDialog.showSMAPIerror((String)this.alarmPanel.translate("pageResError"), (SMRequestStatus)sMRequestStatus);
            this.alarmPanel.setPagePanel(true);
            return;
        }
        if (vector == null) {
            UcDialog.showOk((String)this.alarmPanel.translate("noAlarmData"));
            this.alarmPanel.setPagePanel(true);
            return;
        }
        if (this.alarmPanel.getClear()) {
            this.clearSelection();
            this.alarmPanel.setClear(false);
        }
        this.alarmPanel.setRefreshTime();
        this.alarmList = new AlarmList(new ArrayList(vector));
        this.tableModel.setAlarmList(this.alarmList);
        this.tableChanged(new TableModelEvent(this.getModel()));
        this.repaint();
        if (this.status != null) {
            this.status.setText("");
        }
        this.alarmPanel.setPagePanel(true);
    }

    void selectAlarms() {
        if (this.status != null) {
            this.status.setText(this.alarmPanel.translate("loadingAlarms"));
        }
        this.alarmPanel.setPagePanel(false);
        try {
            this.request.selectHostAlarms(this.alarmPanel.getRequestId(), null, this.alarmPanel.getAlarmUrl(), this.alarmPanel.getView().getSeverity(), this.alarmPanel.getView().getState(), this.alarmPanel.getView().getAcknowledge(), null, null, null, AlarmTableModel.emAttribute[this.sortColumn], this.descend[this.sortColumn], (SMAlarmPageResponse)this, new Object());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("selectReqException"), (SMAPIException)sMAPIException);
        }
    }

    public void selectHostAlarmResponse(SMRequestStatus sMRequestStatus, int n, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDialog.showSMAPIerror((String)this.alarmPanel.translate("selectResError"), (SMRequestStatus)sMRequestStatus);
            this.alarmPanel.setPagePanel(true);
            return;
        }
        int n2 = n / 50;
        if (n % 50 != 0 || n == 0) {
            ++n2;
        }
        this.alarmPanel.setLastPage(n2);
        this.alarmPanel.setTotalAlarms(n);
        if (n <= 0) {
            if (this.status != null) {
                this.status.setText("");
            }
            this.alarmList.clear();
            this.tableChanged(new TableModelEvent(this.getModel()));
            this.repaint();
            this.alarmPanel.setRefreshTime();
        }
    }

    public void setAlarmPageSizeResponse(SMRequestStatus sMRequestStatus, Object object) {
    }

    void setAlarmPanel(AlarmPanel alarmPanel) {
        this.alarmPanel = alarmPanel;
    }

    void sortAlarms() {
        try {
            this.request.sortHostAlarms(this.alarmPanel.getRequestId(), AlarmTableModel.emAttribute[this.sortColumn], this.descend[this.sortColumn], (SMAlarmPageResponse)this, new Object());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("sortReqException"), (SMAPIException)sMAPIException);
        }
    }

    public void sortHostAlarmResponse(SMRequestStatus sMRequestStatus, Object object) {
    }

    public void updateHostAlarmResponse(SMRequestStatus sMRequestStatus, int n, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDialog.showSMAPIerror((String)this.alarmPanel.translate("updateResError"), (SMRequestStatus)sMRequestStatus);
            return;
        }
        this.getPageOfAlarms(this.alarmPanel.getCurrentPage());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.getSelectedRows();
        if (this.alarmList == null) {
            return;
        }
        this.selectedIDs = new String[nArray.length];
        this.selectedADs = new AlarmData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.selectedADs[n] = (AlarmData)this.alarmList.get(nArray[n]);
            this.selectedIDs[n] = (String)this.selectedADs[n].alarmId;
            ++n;
        }
        if (this.alarmList.size() > 0 && nArray.length == 1) {
            AlarmData alarmData = (AlarmData)this.alarmList.get(nArray[0]);
            this.alarmPanel.updateMore(alarmData);
        } else {
            this.alarmPanel.updateMore(new AlarmData());
        }
        super.valueChanged(listSelectionEvent);
    }
}

