/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security;

import com.sun.symon.base.security.SyEndInsecureInterface;
import com.sun.symon.base.security.SyEndSecureInterface;
import com.sun.symon.base.security.SyKeyExchange;
import com.sun.symon.base.security.SySchemeInterface;
import com.sun.symon.base.security.SySchemeList;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.utility.UcDDL;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SySecurity {
    private Hashtable schemeLookup = new Hashtable();
    private String[] schemes;

    public SySecurity() {
        String[] stringArray = new String[SySchemeList.schemes.length];
        int n = 0;
        int n2 = 0;
        while (n2 < SySchemeList.schemes.length) {
            Class<?> clazz;
            String string = SySchemeList.schemes[n2];
            String string2 = "com.sun.symon.base.security." + string + ".SyScheme";
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            if (clazz != null) {
                SySchemeInterface sySchemeInterface;
                try {
                    sySchemeInterface = (SySchemeInterface)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    sySchemeInterface = null;
                }
                catch (InstantiationException instantiationException) {
                    sySchemeInterface = null;
                }
                if (sySchemeInterface == null) {
                    UcDDL.logErrorMessage("Couldn't instantiate class '" + string2 + "'");
                } else {
                    UcDDL.logDebugMessage("Registering security scheme '" + string + "'" + (n == 0 ? " (default)" : ""));
                    this.schemeLookup.put(string, sySchemeInterface);
                    stringArray[n] = string;
                    ++n;
                }
            }
            ++n2;
        }
        if (n == 0) {
            UcDDL.logErrorMessage("Couldn't find any security schemes!");
            this.schemes = null;
        } else {
            this.schemes = new String[n];
            System.arraycopy(stringArray, 0, this.schemes, 0, n);
        }
    }

    public static String encryptUserPassword(String string, String string2) {
        BigInteger bigInteger = new BigInteger(string, 16);
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (2 * byArray.length != string.length()) {
            byArray2 = new byte[string.length() / 2];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray;
        }
        byte[] byArray3 = SyKeyExchange.create(byArray2, string2.getBytes());
        return SySecurity.toHexArray(byArray3);
    }

    public SyEndInsecureInterface endInsecureLookup(String string) throws SySecurityException {
        return this.endInsecureLookup(string, null);
    }

    public SyEndInsecureInterface endInsecureLookup(String string, String string2) throws SySecurityException {
        if (string2 == null) {
            string2 = this.getDefaultScheme();
        }
        SySchemeInterface sySchemeInterface = string2 == null ? null : (SySchemeInterface)this.schemeLookup.get(string2);
        return sySchemeInterface == null ? null : sySchemeInterface.getInsecureEnd(string);
    }

    public SyEndSecureInterface endSecureLookup(String string, String string2) throws SySecurityException {
        SySchemeInterface sySchemeInterface;
        if (string2 == null) {
            sySchemeInterface = null;
        } else {
            sySchemeInterface = (SySchemeInterface)this.schemeLookup.get(string2);
            if (sySchemeInterface == null) {
                throw new SySecurityException("Unsupported Security Scheme", 0);
            }
        }
        return sySchemeInterface == null ? null : sySchemeInterface.getSecureEnd(string);
    }

    public String getDefaultScheme() {
        return this.schemes == null ? null : this.schemes[0];
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void keepSchemes(String string) {
        Enumeration enumeration = this.schemeLookup.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                if (!string2.equals(stringTokenizer.nextToken())) continue;
                bl = true;
            }
            if (bl) continue;
            this.schemeLookup.remove(string2);
            UcDDL.logInfoMessage("Removing security scheme '" + string2 + "'");
        }
    }

    private static String toHex(byte by) {
        String string = "" + Character.forDigit((0xF0 & by) >> 4, 16) + Character.forDigit(0xF & by, 16);
        return string;
    }

    private static String toHexArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (n != 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(SySecurity.toHex(byArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }
}

