/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvBorderEditor;
import com.sun.symon.base.console.views.graph.CvFontEditor;
import com.sun.symon.base.console.views.graph.CvPlacementEditor;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CvLegendEditor
extends JPanel {
    private CvFontEditor fontEditor = new CvFontEditor(true);
    private CvBorderEditor borderEditor = new CvBorderEditor();
    private CvPlacementEditor placementEditor = new CvPlacementEditor();
    private boolean showLegend = false;

    public CvLegendEditor() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.fontEditor);
        this.add("South", this.makeSitePanel());
    }

    public JTextField getBorderWidthField() {
        return this.borderEditor.getBorderWidthField();
    }

    public String getConfiguration() {
        String string = this.fontEditor.getFontConfiguration();
        String string2 = this.placementEditor.getPlacement();
        String string3 = this.borderEditor.getBorderTypeString();
        String string4 = this.borderEditor.getBorderWidthString();
        String string5 = "^";
        return "Legend" + string5 + this.showLegend + string5 + string + string5 + string2 + string5 + string3 + string5 + string4;
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public int getSelectedIndex() {
        return this.fontEditor.getSelectedIndex();
    }

    public boolean getShowLegend() {
        return this.showLegend;
    }

    public String getText() {
        return this.fontEditor.getSampleText();
    }

    public JPanel makeSitePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 2, 2));
        jPanel.add(this.placementEditor);
        jPanel.add(this.borderEditor);
        return jPanel;
    }

    public void setBorderType(int n) {
        this.borderEditor.setBorderType(n);
    }

    public void setBorderWidth(int n) {
        this.borderEditor.setBorderWidth(n);
    }

    public void setLegendFont(Font font) {
        this.fontEditor.setSelectFont(font);
    }

    public void setLegendSite(int n) {
        this.placementEditor.setPlacement(n);
    }

    public void setLegendTexts(String[] stringArray) {
        this.fontEditor.setTextList(stringArray);
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }
}

