/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.alarms.AckListener;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.AlarmTable;
import com.sun.symon.base.console.alarms.AlarmTableModel;
import com.sun.symon.base.console.alarms.DeleteAllListener;
import com.sun.symon.base.console.alarms.DeleteListener;
import com.sun.symon.base.console.alarms.FixListener;
import com.sun.symon.base.console.alarms.ModifyListener;
import com.sun.symon.base.console.alarms.NoteListener;
import com.sun.symon.base.console.alarms.RunListener;
import com.sun.symon.base.console.alarms.View;
import com.sun.symon.base.console.alarms.ViewListener;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcButton;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AlarmPanel
extends JPanel
implements AwxServiceManager {
    static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private AlarmPanel alarmPanel;
    private AlarmTable alarmTable;
    private View view = new View();
    private Frame frame;
    private String alarmUrl;
    private String agentHost;
    private String agentPort;
    private String domainUrl = null;
    private String contextUrl = null;
    private String objectUrl = null;
    private String hostPort = null;
    private String alarmSeverity = null;
    private String exceptionMessage = null;
    private String exception1 = null;
    private String exception2 = null;
    private String requestId = "1";
    private String dateTime;
    private String rule;
    private String start;
    private String end;
    private String ack;
    private String by;
    private JButton ackButton;
    private JButton runButton;
    private JButton refreshButton;
    private JButton optionsButton;
    private JButton firstButton;
    private JButton previousButton;
    private JButton nextButton;
    private JButton lastButton;
    private JPanel startPanel;
    private JPanel endLabelPanel;
    private JPanel endPanel;
    private JPanel ackLabelPanel;
    private JPanel ackPanel;
    private JPanel ruleLabelPanel;
    private JPanel rulePanel;
    private JPanel createTimePanel = new JPanel();
    private JPanel tablePanel;
    private JPanel refreshPanel = null;
    private JPanel totalPanel = null;
    private JPanel morePanel;
    private JLabel refreshValue;
    private JLabel totalValue;
    private JLabel pageValue;
    private JLabel status = null;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel ackLabel;
    private JLabel ruleLabel;
    private JLabel ruleId;
    private JComboBox currentBox;
    private JPopupMenu optionMenu = new JPopupMenu();
    private JScrollPane scrollPane;
    private boolean active = true;
    private boolean firstTime = true;
    private boolean skipRetry = false;
    private boolean clear = false;
    private boolean oldAgent = false;
    private int currentPage = 1;
    private int lastPage = 1;
    private int totalAlarms = 0;
    private AlarmTableModel tableModel;
    private SMTopologyRequest topRequest = null;
    private SMRawDataRequest rawRequest = null;
    private SMAlarmPageAsyncRequest request = null;
    private CurrentPageListener currentPageListener = null;

    static /* synthetic */ int access$3(AlarmPanel alarmPanel) {
        return alarmPanel.lastPage;
    }

    public void cleanUp() {
        try {
            if (this.request != null) {
                this.request.closeConnection(this.requestId);
            }
        }
        catch (Exception exception) {}
        this.request = null;
        this.rawRequest = null;
        this.alarmPanel = null;
    }

    void createUrl() {
        UcAgentURL ucAgentURL;
        UcAgentURL ucAgentURL2 = new UcAgentURL(this.contextUrl);
        String string = "snmp://" + ucAgentURL2.getHost() + ":" + ucAgentURL2.getPort() + "/mod/" + ucAgentURL2.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus" + ucAgentURL2.getFragment() + "/";
        this.alarmUrl = this.objectUrl != null ? ((ucAgentURL = new UcAgentURL(this.objectUrl)).getModuleSpec().equals("") ? new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/}" + " {" + string + "}") : new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + ucAgentURL.getModuleSpec() + "/}" + " {" + string + "}")) : new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/}" + " {" + string + "}");
    }

    String getAgentHost() {
        return this.agentHost;
    }

    String getAgentPort() {
        return this.agentPort;
    }

    Frame getAlarmFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    AlarmTable getAlarmTable() {
        return this.alarmTable;
    }

    String getAlarmUrl() {
        return this.alarmUrl;
    }

    Window getAlarmWindow(Component component) {
        Window window = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Window)) continue;
            window = (Window)component;
            break;
        }
        return window;
    }

    boolean getClear() {
        return this.clear;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }

    int getCurrentPage() {
        return this.currentPage;
    }

    JLabel getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd  HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        JLabel jLabel = new JLabel(simpleDateFormat.format(new Date()));
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jLabel.setForeground(Color.black);
        return jLabel;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    int getLastPage() {
        return this.lastPage;
    }

    SMRawDataRequest getRawRequestHandle() {
        return this.rawRequest;
    }

    SMAlarmPageAsyncRequest getRequestHandle() {
        return this.request;
    }

    String getRequestId() {
        return this.requestId;
    }

    int getTotalAlarms() {
        return this.totalAlarms;
    }

    View getView() {
        return this.view;
    }

    public JLabel getWindowStatusField() {
        return this.status;
    }

    public void init() {
        try {
            this.hostPort = this.topRequest.getEventMngrFromContext(this.contextUrl);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("hostPortException"), (SMAPIException)sMAPIException);
        }
        if (this.hostPort == null || this.hostPort.length() == 0) {
            this.hostPort = null;
            this.skipRetry = true;
            UcDialog.showOk((String)this.translate("nullHostPortWarning"));
        }
        String string = "";
        int n = Integer.parseInt(this.agentPort);
        try {
            string = this.rawRequest.getAgentVersion(this.agentHost, n, "overall");
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("getRevisionException"), (SMAPIException)sMAPIException);
            return;
        }
        if (string.startsWith("2")) {
            this.oldAgent = true;
        }
        try {
            this.request = new SMAlarmPageAsyncRequest(this.rawRequest, this.hostPort);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("requestHandleException"), (SMAPIException)sMAPIException);
            this.request = null;
        }
        if (this.request == null) {
            return;
        }
        this.createUrl();
        this.alarmPanel = this;
        this.frame = this.getAlarmFrame(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.tableModel = new AlarmTableModel(this);
        Insets insets = new Insets(6, 6, 6, 6);
        this.ackButton = new UcButton((Icon)AlarmTableModel.ackImage, this.translate("acknowledgeTip"));
        this.ackButton.addActionListener(new AckListener(this));
        this.runButton = new UcButton((Icon)AlarmTableModel.runImage, this.translate("runTip"));
        this.runButton.addActionListener(new RunListener(this));
        this.refreshButton = new UcButton((Icon)AlarmTableModel.refreshOnImage, this.translate("refreshTip"));
        this.optionsButton = new UcButton((Icon)AlarmTableModel.optionsImage, this.translate("optionsTip"));
        JMenuItem jMenuItem = new JMenuItem(this.translate("view"));
        JMenuItem jMenuItem2 = new JMenuItem(this.translate("delete"));
        JMenuItem jMenuItem3 = new JMenuItem(this.translate("deleteAll"));
        JMenuItem jMenuItem4 = new JMenuItem(this.translate("modify"));
        JMenuItem jMenuItem5 = new JMenuItem(this.translate("note"));
        JMenuItem jMenuItem6 = new JMenuItem(this.translate("viewFix"));
        this.optionMenu.add(jMenuItem);
        this.optionMenu.add(jMenuItem2);
        this.optionMenu.add(jMenuItem3);
        this.optionMenu.add(jMenuItem4);
        this.optionMenu.add(jMenuItem5);
        this.optionMenu.add(jMenuItem6);
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                Dimension dimension = jButton.getSize();
                AlarmPanel.this.optionMenu.show(jButton, 0, (int)dimension.getHeight());
            }
        });
        if (this.oldAgent) {
            this.runButton.setEnabled(false);
            jMenuItem4.setEnabled(false);
        }
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.ackButton);
        jToolBar.add(this.runButton);
        jToolBar.add(this.refreshButton);
        jToolBar.addSeparator();
        jToolBar.add(this.optionsButton);
        gridBagConstraints.insets = new Insets(14, 11, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jToolBar, gridBagConstraints);
        this.refreshPanel = new JPanel(new FlowLayout(0, 3, 0));
        this.refreshPanel.add(new JLabel(this.translate("lastRefresh")));
        this.refreshValue = this.getCurrentTime();
        this.refreshPanel.add(this.refreshValue);
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.refreshPanel, gridBagConstraints);
        this.tablePanel = new JPanel(new GridBagLayout());
        this.tablePanel.setBackground(Color.white);
        JPanel jPanel = new JPanel(new FlowLayout(0, 6, 0));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel(this.translate("current")));
        this.currentBox = new JComboBox();
        this.currentBox.setPreferredSize(new Dimension(75, 25));
        this.currentBox.setEditable(true);
        jPanel.add(this.currentBox);
        jPanel.add(new JLabel(" "));
        this.firstButton = new UcButton((Icon)AlarmTableModel.firstImage, this.translate("firstToolTip"));
        this.firstButton.setActionCommand("first");
        this.firstButton.setMargin(new Insets(2, 3, 2, 3));
        class PageListener
        implements ActionListener {
            private final /* synthetic */ AlarmPanel this$0;

            PageListener(AlarmPanel alarmPanel) {
                this.this$0 = alarmPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.compareTo("first") == 0) {
                    AlarmPanel.access$2(this.this$0, 1);
                } else if (string.compareTo("previous") == 0) {
                    AlarmPanel alarmPanel = this.this$0;
                    AlarmPanel.access$2(alarmPanel, AlarmPanel.access$1(alarmPanel) - 1);
                } else if (string.compareTo("next") == 0) {
                    AlarmPanel alarmPanel = this.this$0;
                    AlarmPanel.access$2(alarmPanel, AlarmPanel.access$1(alarmPanel) + 1);
                } else {
                    AlarmPanel.access$2(this.this$0, AlarmPanel.access$3(this.this$0));
                }
                if (AlarmPanel.access$1(this.this$0) < 1) {
                    UcDialog.showOk((String)this.this$0.translate("thisIsFirst"));
                    AlarmPanel.access$2(this.this$0, 1);
                    return;
                }
                if (AlarmPanel.access$1(this.this$0) > AlarmPanel.access$3(this.this$0)) {
                    UcDialog.showOk((String)this.this$0.translate("thisIsLast"));
                    AlarmPanel.access$2(this.this$0, AlarmPanel.access$3(this.this$0));
                    return;
                }
                AlarmPanel.access$4(this.this$0).setSelectedIndex(AlarmPanel.access$1(this.this$0) - 1);
            }
        }
        this.firstButton.addActionListener(new PageListener(this));
        jPanel.add(this.firstButton);
        this.previousButton = new UcButton((Icon)AlarmTableModel.prevImage, this.translate("previousToolTip"));
        this.previousButton.setMargin(new Insets(2, 3, 2, 3));
        this.previousButton.addActionListener(new PageListener(this));
        this.previousButton.setActionCommand("previous");
        jPanel.add(this.previousButton);
        this.nextButton = new UcButton((Icon)AlarmTableModel.nextImage, this.translate("nextToolTip"));
        this.nextButton.setMargin(new Insets(2, 3, 2, 3));
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(new PageListener(this));
        jPanel.add(this.nextButton);
        this.lastButton = new UcButton((Icon)AlarmTableModel.lastImage, this.translate("lastToolTip"));
        this.lastButton.setMargin(new Insets(2, 3, 2, 3));
        this.lastButton.setToolTipText(this.translate("lastToolTip"));
        this.lastButton.setActionCommand("last");
        this.lastButton.addActionListener(new PageListener(this));
        jPanel.add(this.lastButton);
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.tablePanel.add((Component)jPanel, gridBagConstraints);
        this.totalPanel = new JPanel(new FlowLayout(0, 3, 0));
        this.totalPanel.setBackground(Color.white);
        this.totalPanel.add(new JLabel(this.translate("totalAlarms")));
        this.totalValue = new JLabel(Integer.toString(this.totalAlarms));
        this.totalValue.setFont(this.totalValue.getFont().deriveFont(0));
        this.totalValue.setForeground(Color.black);
        this.totalPanel.add(this.totalValue);
        gridBagConstraints.insets = new Insets(7, 8, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.tablePanel.add((Component)this.totalPanel, gridBagConstraints);
        this.alarmTable = new AlarmTable(this.tableModel);
        this.alarmTable.setAlarmPanel(this);
        this.alarmTable.init();
        this.alarmTable.selectAlarms();
        this.currentPageListener = new CurrentPageListener();
        this.currentBox.addActionListener(this.currentPageListener);
        jMenuItem2.addActionListener(new DeleteListener(this));
        jMenuItem3.addActionListener(new DeleteAllListener(this));
        jMenuItem4.addActionListener(new ModifyListener(this, this.frame));
        jMenuItem5.addActionListener(new NoteListener(this, this.frame));
        jMenuItem6.addActionListener(new FixListener(this, this.frame));
        this.scrollPane = new JScrollPane(this.alarmTable, 20, 30);
        this.scrollPane.setBorder(new EtchedBorder());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 11, 11, 11);
        this.tablePanel.add((Component)this.scrollPane, gridBagConstraints);
        this.tablePanel.setBorder(new EtchedBorder());
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.add((Component)this.tablePanel, gridBagConstraints);
        jMenuItem.addActionListener(new ViewListener(this, this.frame));
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmPanel.this.alarmTable.selectAlarms();
            }
        });
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.morePanel = new JPanel(new GridBagLayout());
        this.morePanel.setBorder(new TitledBorder(new EtchedBorder(), this.translate("alarmInfo")));
        this.endLabel = new JLabel(this.translate("alarmEnded"));
        this.ackLabel = new JLabel(this.translate("alarmAcked"));
        this.ruleLabel = new JLabel(this.translate("rule"));
        this.by = new String(" " + this.translate("by") + " ");
        this.endLabelPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.endLabelPanel.add(this.endLabel);
        this.endPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.ackLabelPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.ackLabelPanel.add(this.ackLabel);
        this.ackPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.ruleLabelPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.ruleLabelPanel.add(this.ruleLabel);
        this.rulePanel = new JPanel(new FlowLayout(0, 0, 0));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.morePanel.add((Component)this.endLabelPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.morePanel.add((Component)this.endPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 12, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.morePanel.add((Component)this.ackLabelPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.morePanel.add((Component)this.ackPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(7, 9, 8, 8);
        this.add((Component)this.morePanel, gridBagConstraints);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
            }
        });
    }

    boolean isActive() {
        return this.active;
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        AwxServiceProvider awxServiceProvider2 = null;
        awxServiceProvider2 = awxServiceProvider;
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
        if (this.agentHost.compareTo("") == 0 || this.agentHost == null) {
            UcDialog.showOk((String)this.translate("invalidHostAddress"));
        }
    }

    public void setAgentPort(String string) {
        this.agentPort = new String(string);
        if (this.agentPort.compareTo("") == 0 || this.agentPort == null) {
            UcDialog.showOk((String)this.translate("invalidAgentPort"));
        }
    }

    void setClear(boolean bl) {
        this.clear = bl;
    }

    public void setContextUrl(String string) {
        this.contextUrl = string;
    }

    void setCurrentPage(int n) {
        this.currentPage = n;
    }

    public void setDomainUrl(String string) {
        this.domainUrl = string;
    }

    void setLastPage(int n) {
        this.lastPage = n;
    }

    public void setObjectUrl(String string) {
        this.objectUrl = string;
    }

    void setPagePanel(boolean bl) {
        this.firstButton.setEnabled(bl);
        this.previousButton.setEnabled(bl);
        this.nextButton.setEnabled(bl);
        this.lastButton.setEnabled(bl);
        this.currentBox.setEnabled(bl);
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        if (this.skipRetry) {
            this.skipRetry = false;
            return;
        }
        this.rawRequest = sMRawDataRequest;
        this.topRequest = new SMTopologyRequest(sMRawDataRequest);
    }

    void setRefreshTime() {
        this.refreshPanel.remove(this.refreshValue);
        this.getParent().validate();
        this.refreshValue = this.getCurrentTime();
        this.refreshPanel.add(this.refreshValue);
        this.getParent().validate();
    }

    void setTotalAlarms(int n) {
        this.totalAlarms = n;
        if (this.totalPanel != null) {
            this.totalPanel.remove(this.totalValue);
            this.getParent().validate();
            this.totalValue = new JLabel(Integer.toString(this.totalAlarms));
            this.totalValue.setFont(this.totalValue.getFont().deriveFont(0));
            this.totalValue.setForeground(Color.black);
            this.totalPanel.add(this.totalValue);
            this.getParent().validate();
        }
        this.currentBox.removeAllItems();
        int n2 = 0;
        while (n2 < this.lastPage) {
            this.currentPageListener.setNewListener();
            this.currentBox.addItem(new String(" " + (n2 + 1)));
            ++n2;
        }
        this.currentPageListener.setNewListener(false);
        this.currentBox.setSelectedIndex(0);
    }

    void setView(View view) {
        this.view = view;
    }

    void setWait(boolean bl) {
        Window window = this.getAlarmWindow(this);
        Frame frame = this.getAlarmFrame(this);
        this.active = bl;
        Cursor cursor = bl ? waitCursor : defaultCursor;
        this.setCursor(cursor);
        frame.setCursor(cursor);
        window.setCursor(cursor);
    }

    public void setWindowStatusField(Object object) {
        this.status = (JLabel)object;
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.alarms.AlarmBundle:" + string));
    }

    void updateMore(AlarmData alarmData) {
        this.endPanel.removeAll();
        this.ackPanel.removeAll();
        this.rulePanel.removeAll();
        this.getParent().validate();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getDefault());
        if (alarmData.endTime != 0L) {
            this.endPanel.add(new JLabel(dateFormat.format(new Date(alarmData.endTime))));
            this.endLabel.setEnabled(true);
        }
        if (alarmData.getAckTime() != 0L) {
            String string = dateFormat.format(new Date(alarmData.getAckTime()));
            String string2 = this.by.concat(alarmData.getAckUser());
            this.ackPanel.add(new JLabel(string.concat(string2)));
            this.ackLabel.setEnabled(true);
        }
        if (alarmData.ruleId != null && alarmData.ruleId.length() > 0) {
            this.ruleId = new JLabel(alarmData.ruleId);
            this.rulePanel.add(this.ruleId);
            this.ruleLabel.setEnabled(true);
        }
        this.getParent().validate();
    }

    class CurrentPageListener
    implements ActionListener {
        boolean newCurrentPageListener = true;

        CurrentPageListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.newCurrentPageListener) {
                this.newCurrentPageListener = false;
                return;
            }
            int n = AlarmPanel.this.currentBox.getSelectedIndex();
            if (n == -1 || AlarmPanel.this.totalAlarms == 0) {
                return;
            }
            AlarmPanel.this.currentPage = n + 1;
            AlarmPanel.this.alarmTable.getPageOfAlarms(AlarmPanel.this.currentPage);
        }

        public void setNewListener() {
            this.newCurrentPageListener = true;
        }

        public void setNewListener(boolean bl) {
            this.newCurrentPageListener = bl;
        }
    }
}

