/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.sess_iiop;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import oracle.aurora.AuroraServices.PublishedObject;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.server.tools.sess_iiop.ToolImpl;
import oracle.aurora.server.tools.sess_iiop.ToolsException;
import org.omg.CORBA.NO_PERMISSION;

public class Chown
extends ToolImpl {
    private Name name;
    private String schema;

    public Chown() {
    }

    public Chown(String owner, String n) throws ToolsException {
        this.schema = owner;
        this.name = ToolImpl.wd.parse(n);
        this.invoke();
    }

    public String description() throws ToolsException {
        return this.msg("CHOWN_DESCRIPTION", null);
    }

    public String help() throws ToolsException {
        return this.msg("CHOWN_HELP", null);
    }

    protected void invoke() throws ToolsException {
        try {
            Context dir = ToolImpl.wd.lookupParent(this.name);
            Object o = dir.lookup(ToolImpl.wd.last(this.name));
            if (o instanceof SessionCtx) {
                ((SessionCtx)o).set_owner(this.schema);
            } else {
                String[] nullArray = new String[]{};
                ((PublishedObject)o).set_attributes(this.schema, nullArray, nullArray, nullArray);
            }
        }
        catch (NamingException e) {
            this.fail2("CANNOT_CHOWN", this.name.toString(), e.getMessage());
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            this.fail1("NO_PERMISSION", this.name.toString());
        }
    }

    public static void main(String[] args) {
        try {
            new Chown().invoke(args, System.in, System.out, System.err);
        }
        catch (ToolsException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    protected void parseArgs(String[] argv) throws ToolsException {
        if (argv.length != 2) {
            this.error(this.usage());
        }
        this.schema = argv[0].toUpperCase();
        this.name = ToolImpl.wd.parse(argv[1]);
    }

    public String usage() throws ToolsException {
        return this.msg("CHOWN_USAGE", null);
    }

    public String version() throws ToolsException {
        return this.msg("CHOWN_VERSION", null);
    }
}

