#
#   File:    topology-license-models-d.x
#   Author:  Tom Yuyitung
#   Version: 1.8 01/05/16 18:26:01
#
#   Copyright (c) 1997 Halcyon Inc.
#
#   Topology License model.  
#

type = reference
mediumDesc = Topology License Module

_rules = {
    [ use PROC ]
    [ source topology-license-d.rul ]
}

topoObjectStats = { [ use MANAGED-OBJECT ]
    mediumDesc = Object Statistics
    consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats

    topoDomainCount = { [ use MANAGED-PROPERTY INT ]
        mediumDesc = Domain Count
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoDomainCount
    }

    topoGroupCount = { [ use MANAGED-PROPERTY INT ]
        mediumDesc = Group Count
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoGroupCount
    }

    topoEntityCount = { [ use MANAGED-PROPERTY INT ]
        mediumDesc = Entity Count
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoEntityCount
    }

    topoTotalAgents  = { [ use MANAGED-PROPERTY INTHI ]
	mediumDesc = Total Agent Count
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoTotalAgents
    }

    topoMaxAgents  = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Maximum Agent Limit
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoMaxAgents
    }

    topoAvailAgents  = { [ use MANAGED-PROPERTY STRINGRULE _rules ]
	mediumDesc = Available Agents
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoAvailAgents
	alarmRules = rTopoLicense
    }

    topoValidUntil = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Valid Until
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoValidUntil
    }

    topoLicenseStatus  = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = License Status
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoLicenseStatus
    }

    topoMaxObjects = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Maximum Object Limit
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoMaxObjects
    }

    topoUsedLic = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Used License Units
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoUsedLic 
    }

    topoMaxLic = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Maximum License Units
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoMaxLic 
    }

    topoAvailLic = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Available License Units
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoAvailLic
    }

    topoAgentDemoValidUntil  = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Agent Demo Valid Until
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoAgentDemoValidUntil
    }

    topoAgentLicenseStatus  = { [ use MANAGED-PROPERTY STRING ]
	mediumDesc = Agent Licensing Status
	consoleHint:mediumDesc = base.modules.topologyLicense:topoObjectStats.topoAgentLicensingStatus
    }

    topoTable = { [ use MANAGED-OBJECT-TABLE ] 
	shortDesc = Topology Objects
	mediumDesc = Topology Objects
	fullDesc = Topology Objects
	consoleHint:mediumDesc = Topology Objects
	topoEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		shortDesc = Topology Objects
		mediumDesc = Topology Objects
		consoleHint:mediumDesc = Topology Objects
		fullDesc = Topology Objects
		index = name
		descColumn = name
		name = { [ use STRING MANAGED-PROPERTY ]
			shortDesc = Topology Object
			mediumDesc = Topology Object
			consoleHint:mediumDesc = Topology Object
			fullDesc = Topology Object
		}
		used = { [ use INTHILO MANAGED-PROPERTY ]
			shortDesc = Licenses Used
			mediumDesc = Licenses Used
			consoleHint:mediumDesc = Licenses Used 
			fullDesc = Licenses Used 
		}
	}
    }
    moduleTable = { [ use MANAGED-OBJECT-TABLE ]
	shortDesc = Modules Loaded
	mediumDesc = Modules Loaded
	consoleHint:mediumDesc = Modules Loaded 
	fullDesc = Modules Loaded
	moduleEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		shortDesc = Modules Loaded
		mediumDesc = Modules Loaded
		consoleHint:mediumDesc = Modules Loaded 
		fullDesc = Modules Loaded
		index = name
		descColumn = name
		name = { [ use STRING MANAGED-PROPERTY ]
			shortDesc = Modules Loaded
			consoleHint:mediumDesc = Modules Loaded 
			mediumDesc = Modules Loaded
			fullDesc = Modules Loaded
		}
		packname = { [ use STRING MANAGED-PROPERTY ]
			shortDesc = Pack Name
			consoleHint:mediumDesc = Pack Name 
			mediumDesc = Pack Name
			fullDesc = Pack Name
		}
		used = { [ use INTHILO MANAGED-PROPERTY ]
			shortDesc = Licenses Used
			mediumDesc = Licenses Used
			consoleHint:mediumDesc = Licenses Used 
			fullDesc = Licenses Used
		}
	}
    }
    packbyhostTable = { [ use MANAGED-OBJECT-TABLE ]
	shortDesc = Pack Information by Hostname
	mediumDesc = Pack Information by Hostname  
	consoleHint:mediumDesc = Pack Information by Hostname 
	fullDesc = Pack Information by Hostname 
	packbyhostEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		shortDesc = Pack Information by Hostname 
		mediumDesc = Pack Information by Hostname 
		consoleHint:mediumDesc = Pack Information by Hostname 
		fullDesc = Pack Information by Hostname 

		index = name
		descColumn = name

		name = { [ use STRING MANAGED-PROPERTY ]
			shortDesc = Hostname
			consoleHint:mediumDesc = Hostname 
			mediumDesc = Hostname
			fullDesc = Hostname
		}
		family = { [ use STRING MANAGED-PROPERTY ]
			shortDesc = Family
			consoleHint:mediumDesc = Family 
			mediumDesc = Family
			fullDesc = Family
		}
		basic = { [ use INTHILO MANAGED-PROPERTY ]
			shortDesc = Basic Modules
			consoleHint:mediumDesc = Basic Modules  
			mediumDesc = Basic Modules
			fullDesc = Basic Modules
		}
		advanced = { [ use INTHILO MANAGED-PROPERTY ]
			shortDesc = Advanced Modules
			consoleHint:mediumDesc = Advanced Modules  
			mediumDesc = Advanced Modules 
			fullDesc = Advanced Agent Functionality Modules 
		}
	}
    }
    packbyfamilyTable = { [ use MANAGED-OBJECT-TABLE ]
	shortDesc = Pack Information by Family 
	mediumDesc = Pack Information by Family  
	consoleHint:mediumDesc = Pack Information by Family 
	fullDesc = Pack Information by Family 
	packbyfamilyEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
		shortDesc = Pack Information by Family 
		mediumDesc = Pack Information by Family
		consoleHint:mediumDesc = Pack Information by Family 
		fullDesc = Pack Information by Family

		index = name
		descColumn = name

		name = { [ use STRING MANAGED-PROPERTY ]
			shortDesc = Family Name
			consoleHint:mediumDesc = Family Name 
			mediumDesc = Family Name
			fullDesc = Family Name
		}
		basic = { [ use INTHILO MANAGED-PROPERTY ]
			shortDesc = Basic Packs
			consoleHint:mediumDesc = Basic Packs 
			mediumDesc = Basic Packs  
			fullDesc = Basic Functionality Pack
		}
		advanced = { [ use INTHILO MANAGED-PROPERTY ]
			shortDesc = Advanced Packs
			consoleHint:mediumDesc = Advanced Packs  
			mediumDesc = Advanced Packs 
			fullDesc = Advanced Agent Functionality Pack
		}
	}
    }

    licByPackTable = { [ use MANAGED-OBJECT-TABLE ]
        shortDesc = Pack Information by Family
        mediumDesc = Pack Information by Family
        consoleHint:mediumDesc = Pack Information by Family
        fullDesc = Pack Information by Family
        licByPackEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
           shortDesc = Pack Information by Family
           mediumDesc = Pack Information by Family
           consoleHint:mediumDesc = Pack Information by Family
           fullDesc = Pack Information by Family

           index = keytype
           descColumn = keytype

           keytype = { [ use STRING MANAGED-PROPERTY ]
                    shortDesc = Key Type
                    consoleHint:mediumDesc = Key Type
                    mediumDesc = Key Type
                    fullDesc = Key Type
           }
           fullname = { [ use STRING MANAGED-PROPERTY ]
                    shortDesc = Pack Name
                    consoleHint:mediumDesc = Pack Name
                    mediumDesc = Pack Name
                    fullDesc = Pack Name
           }
           max = { [ use INT MANAGED-PROPERTY ]
                    shortDesc = Max Units
                    consoleHint:mediumDesc = Max Units
                    mediumDesc = Max Units
                    fullDesc = Max Units
           }
           used = { [ use INT MANAGED-PROPERTY ]
                    shortDesc = Used Units
                    consoleHint:mediumDesc = Used Units
                    mediumDesc = Used Units
                    fullDesc = Used Units
           }
           available = { [ use INT MANAGED-PROPERTY ]
                    shortDesc = Available Units
                    consoleHint:mediumDesc = Available Units
                    mediumDesc = Available Units
                    fullDesc = Available Units
           }
           validUntil = { [ use STRING MANAGED-PROPERTY ]
                    shortDesc = Expires
                    consoleHint:mediumDesc = Expires
                    mediumDesc = Expires
                    fullDesc = Expires
           }
           status = { [ use STRING MANAGED-PROPERTY ]
                    shortDesc = License Status
                    consoleHint:mediumDesc = License Status
                    mediumDesc = License Status
                    fullDesc = License Status
           }
        }
    }
}



[ load topology-license-ruleinit-d.x ]
