/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.jndi.sess_iiop;

import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.aurora.jndi.sess_iiop.SessionCtx;
import oracle.aurora.jndi.sess_iiop.SessionNameParser;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NamingContext;

public class SessionBindingEnumeration
implements NamingEnumeration {
    private BindingListHolder _bindingList;
    private int _numOfBindings;
    private BindingIteratorHolder _bindingIterH;
    private BindingIterator _bindingIter;
    private int counter;
    private NamingContext _nc;
    protected SessionCtx _ctx;
    private static int _getBindings = 10;

    public SessionBindingEnumeration(SessionCtx ctx) {
        this._ctx = ctx;
        this._bindingList = new BindingListHolder();
        this._bindingIterH = new BindingIteratorHolder();
        this._ctx.namingContext.list(_getBindings, this._bindingList, this._bindingIterH);
        this._numOfBindings = this._bindingList.value.length;
        this.counter = 0;
        this._bindingIter = this._bindingIterH.value;
    }

    private String classNameOf(int binding_type) {
        switch (binding_type) {
            case 0: {
                return "oracle.aurora.AuroraPublishing.PublishedObject";
            }
            case 1: {
                return "oracle.aurora.jndi.sess_iiop.SessionCtx";
            }
        }
        return null;
    }

    public void close() throws NamingException {
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    public boolean hasMoreElements() {
        if (this.counter < this._numOfBindings) {
            return true;
        }
        if (this._bindingIterH.value == null) {
            return false;
        }
        this._bindingList = new BindingListHolder();
        if (!this._bindingIterH.value.next_n(_getBindings, this._bindingList)) {
            return false;
        }
        this._numOfBindings = this._bindingList.value.length;
        this.counter = 0;
        return true;
    }

    protected NameClassPair mapBinding(Binding binding) throws NamingException {
        String name = SessionNameParser.cosNameToString(binding.binding_name);
        return new javax.naming.Binding(name, (Object)this.classNameOf(binding.binding_type.value()));
    }

    public Object next() throws NamingException {
        if (this.counter == this._numOfBindings) {
            throw new NoSuchElementException();
        }
        Binding binding = this._bindingList.value[this.counter];
        ++this.counter;
        return this.mapBinding(binding);
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }
}

