/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.deployment.server;

import java.lang.reflect.Method;
import oracle.aurora.ncomp.java.Environment;
import oracle.aurora.ncomp.java.FieldDefinition;
import oracle.aurora.ncomp.java.Identifier;
import oracle.aurora.ncomp.java.Type;
import oracle.aurora.ncomp.tree.Expression;
import oracle.aurora.ncomp.tree.IdentifierExpression;

class MethodInfo {
    private int hashCode;
    private Identifier name = null;
    private Type returnType = null;
    private Type[] argTypes = null;
    private Identifier[] argNames = null;
    private Expression[] argExprs = null;
    private Identifier[] exceptionNames = null;

    MethodInfo(Method m) {
        this.name = Identifier.lookup((String)m.getName());
        this.returnType = MethodInfo.classToType(m.getReturnType());
        Class<?>[] mParams = m.getParameterTypes();
        this.argTypes = new Type[mParams.length];
        int i = 0;
        while (i < mParams.length) {
            this.argTypes[i] = MethodInfo.classToType(mParams[i]);
            ++i;
        }
        this.argNames = new Identifier[mParams.length];
        this.argExprs = new Expression[mParams.length];
        int i2 = 0;
        while (i2 < mParams.length) {
            Identifier argName;
            this.argNames[i2] = argName = Identifier.lookup((String)("arg" + i2));
            this.argExprs[i2] = new IdentifierExpression(0, argName);
            ++i2;
        }
        Class<?>[] exTypes = m.getExceptionTypes();
        this.exceptionNames = new Identifier[exTypes.length];
        int i3 = 0;
        while (i3 < exTypes.length) {
            this.exceptionNames[i3] = Identifier.lookup((String)exTypes[i3].getName());
            ++i3;
        }
        this.setHashCode();
    }

    MethodInfo(FieldDefinition f, Environment env) {
        this.name = f.getName();
        this.returnType = f.getType().getReturnType();
        this.argTypes = f.getType().getArgumentTypes();
        int length = this.argTypes.length;
        this.argNames = new Identifier[length];
        this.argExprs = new Expression[length];
        this.exceptionNames = f.getExceptionNames(env);
        int i = 0;
        while (i < length) {
            Identifier argName;
            this.argNames[i] = argName = Identifier.lookup((String)("arg" + i));
            this.argExprs[i] = new IdentifierExpression(0, argName);
            ++i;
        }
        this.setHashCode();
    }

    static Type classToType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return Type.tVoid;
            }
            if (clazz == Boolean.TYPE) {
                return Type.tBoolean;
            }
            if (clazz == Byte.TYPE) {
                return Type.tByte;
            }
            if (clazz == Character.TYPE) {
                return Type.tChar;
            }
            if (clazz == Short.TYPE) {
                return Type.tShort;
            }
            if (clazz == Integer.TYPE) {
                return Type.tInt;
            }
            if (clazz == Float.TYPE) {
                return Type.tFloat;
            }
            if (clazz == Long.TYPE) {
                return Type.tLong;
            }
            if (clazz == Double.TYPE) {
                return Type.tDouble;
            }
        }
        if (clazz.isArray()) {
            return Type.tArray((Type)MethodInfo.classToType(clazz.getComponentType()));
        }
        return Type.tClass((Identifier)Identifier.lookup((String)clazz.getName()));
    }

    public boolean equals(Object o) {
        MethodInfo m = null;
        try {
            m = (MethodInfo)o;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!m.getName().equals(this.name)) {
            return false;
        }
        if (m.getReturnType() != this.returnType) {
            return false;
        }
        Type[] mParams = m.getArgTypes();
        if (mParams.length != this.argTypes.length) {
            return false;
        }
        int i = 0;
        while (i < mParams.length) {
            if (mParams[i] != this.argTypes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean equalsJavaMethod(Method m) {
        if (!m.getName().equals(this.name.toString())) {
            return false;
        }
        if (MethodInfo.classToType(m.getReturnType()) != this.returnType) {
            return false;
        }
        Class<?>[] mParams = m.getParameterTypes();
        if (mParams.length != this.argTypes.length) {
            return false;
        }
        int i = 0;
        while (i < mParams.length) {
            if (MethodInfo.classToType(mParams[i]) != this.argTypes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Expression[] getArgExprs() {
        return this.argExprs;
    }

    public Identifier[] getArgNames() {
        return this.argNames;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    public Identifier[] getExceptionNames() {
        return this.exceptionNames;
    }

    public Identifier getName() {
        return this.name;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setArgExprs(Expression[] argExprs_newValue) {
        this.argExprs = argExprs_newValue;
    }

    public void setArgNames(Identifier[] argNames_newValue) {
        this.argNames = argNames_newValue;
    }

    public void setArgTypes(Type[] argTypes_newValue) {
        this.argTypes = argTypes_newValue;
    }

    public void setExceptionNames(Identifier[] exceptionNames_newValue) {
        this.exceptionNames = exceptionNames_newValue;
    }

    private void setHashCode() {
        this.hashCode = this.name.hashCode() ^ this.returnType.hashCode();
        int i = 0;
        while (i < this.argTypes.length) {
            this.hashCode ^= this.argTypes[i].hashCode();
            ++i;
        }
    }

    public void setName(Identifier name_newValue) {
        this.name = name_newValue;
    }

    public void setReturnType(Type returnType_newValue) {
        this.returnType = returnType_newValue;
    }

    public String toString() {
        String method = "MethodInfo: " + this.returnType + " " + this.name + "(";
        int i = 0;
        while (i < this.argTypes.length) {
            method = String.valueOf(method) + " " + this.argTypes[i];
            ++i;
        }
        method = String.valueOf(method) + ")";
        return method;
    }
}

