/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.console.views.graph.CvGraphXAxisFormat;
import com.sun.symon.base.console.views.graph.CvGraphYAxisFormat;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class CvAxisEditor
extends JPanel {
    private String autoAdjust = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:auto");
    private String grid = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:grid");
    private String range = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:range");
    private String rangeMin = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:range.min");
    private String rangeMax = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:range.max");
    private String gridspacing = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:gridspacing");
    private String labelspacing = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:labelspacing");
    private String tickspacing = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:tickspacing");
    private String majortick = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:majortick");
    private String minortick = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:minortick");
    private String autoscale = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:autoscale");
    private String i18nMinutesToDisplay = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:minutesToDisplay");
    private String minutes = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:minutes");
    private JTabbedPane tabPane = new JTabbedPane();
    private JTextField gridSpacing = new JTextField("", 10);
    private JTextField minValueField = new JTextField("", 10);
    private JTextField maxValueField = new JTextField("", 10);
    private JTextField numSpacing = new JTextField("", 10);
    private JTextField tickSpacing = new JTextField("", 10);
    private JCheckBox autoScale = new JCheckBox();
    private JTextField gridSpacingX = new JTextField("", 10);
    private JTextField minutesToDisplay = new JTextField("60", 10);
    private JTextField tickSpacingX = new JTextField("", 10);
    private JCheckBox autoScaleX = new JCheckBox();

    public CvAxisEditor() {
        JPanel jPanel = this.makeXPanel();
        JPanel jPanel2 = this.makeYPanel();
        CtMarginPanel ctMarginPanel = new CtMarginPanel(new Insets(10, 4, 4, 4));
        ctMarginPanel.setLayout(new BorderLayout());
        ctMarginPanel.add("North", jPanel);
        CtMarginPanel ctMarginPanel2 = new CtMarginPanel(new Insets(10, 4, 4, 4));
        ctMarginPanel2.setLayout(new BorderLayout());
        ctMarginPanel2.add("North", jPanel2);
        this.tabPane.addTab(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:xaxis"), null, ctMarginPanel);
        this.tabPane.addTab(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:yaxis"), null, ctMarginPanel2);
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabPane);
    }

    private void addAnotherRow(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JLabel jLabel, JComponent jComponent) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
    }

    private void addSeparator(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JSeparator jSeparator) {
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
    }

    private boolean containsLetter(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Character.isLetter(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void disableXFields() {
        this.minutesToDisplay.setText(this.autoAdjust);
        this.tickSpacingX.setText(this.autoAdjust);
        this.gridSpacingX.setText(this.autoAdjust);
        this.minutesToDisplay.setEditable(false);
        this.tickSpacingX.setEditable(false);
        this.gridSpacingX.setEditable(false);
    }

    public void disableYFields() {
        this.minValueField.setText(this.autoAdjust);
        this.maxValueField.setText(this.autoAdjust);
        this.numSpacing.setText(this.autoAdjust);
        this.tickSpacing.setText(this.autoAdjust);
        this.gridSpacing.setText(this.autoAdjust);
        this.minValueField.setEditable(false);
        this.maxValueField.setEditable(false);
        this.numSpacing.setEditable(false);
        this.tickSpacing.setEditable(false);
        this.gridSpacing.setEditable(false);
    }

    public JCheckBox getAutoScale() {
        return this.autoScale;
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public JTextField getMaxField() {
        return this.maxValueField;
    }

    public JTextField getMinField() {
        return this.minValueField;
    }

    public JTextField getMinutesField() {
        return this.minutesToDisplay;
    }

    public JCheckBox getXAutoScale() {
        return this.autoScaleX;
    }

    public String getXConfiguration() {
        String string = "^";
        boolean bl = this.autoScaleX.isSelected();
        String string2 = this.minutesToDisplay.getText();
        String string3 = this.gridSpacingX.getText();
        String string4 = this.tickSpacingX.getText();
        return "XAxis" + string + bl + string + string2 + string + string4 + string + string3;
    }

    public JTextField getXGridField() {
        return this.gridSpacingX;
    }

    public boolean getXIsAutoScale() {
        return this.autoScaleX.isSelected();
    }

    public JTextField getXTickField() {
        return this.tickSpacingX;
    }

    public String getYConfiguration() {
        String string = "^";
        boolean bl = this.autoScale.isSelected();
        String string2 = this.minValueField.getText();
        String string3 = this.maxValueField.getText();
        String string4 = this.numSpacing.getText();
        String string5 = this.tickSpacing.getText();
        String string6 = this.gridSpacing.getText();
        return "YAxis" + string + bl + string + string2 + string + string3 + string + string4 + string + string5 + string + string6;
    }

    public JTextField getYGridField() {
        return this.gridSpacing;
    }

    public boolean getYIsAutoScale() {
        return this.autoScale.isSelected();
    }

    public JTextField getYLabelField() {
        return this.numSpacing;
    }

    public JTextField getYTickField() {
        return this.tickSpacing;
    }

    public JPanel makeXPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        JLabel jLabel = new JLabel(String.valueOf(this.i18nMinutesToDisplay) + ":", 4);
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, jLabel, this.minutesToDisplay);
        this.addSeparator(jPanel, gridBagLayout, gridBagConstraints, new JSeparator());
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.tickspacing) + ":", 4), this.tickSpacingX);
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.gridspacing) + ":", 4), this.gridSpacingX);
        this.addSeparator(jPanel, gridBagLayout, gridBagConstraints, new JSeparator());
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.autoscale) + ":", 4), this.autoScaleX);
        return jPanel;
    }

    public JPanel makeYPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.rangeMin) + ":", 4), this.minValueField);
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.rangeMax) + ":", 4), this.maxValueField);
        this.addSeparator(jPanel, gridBagLayout, gridBagConstraints, new JSeparator());
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.majortick) + ":", 4), this.numSpacing);
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.minortick) + ":", 4), this.tickSpacing);
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.gridspacing) + ":", 4), this.gridSpacing);
        this.addSeparator(jPanel, gridBagLayout, gridBagConstraints, new JSeparator());
        this.addAnotherRow(jPanel, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(this.autoscale) + ":", 4), this.autoScale);
        return jPanel;
    }

    public void setXConfiguration(String string) throws CvGraphInvalidInputException {
        CvGraphXAxisFormat cvGraphXAxisFormat = new CvGraphXAxisFormat();
        cvGraphXAxisFormat.setConfiguration(string);
        this.autoScaleX.setSelected(cvGraphXAxisFormat.getAutoScale());
        if (cvGraphXAxisFormat.getAutoScale()) {
            this.disableXFields();
        } else {
            this.updateXFields(cvGraphXAxisFormat.getMinutesToDisplay(), cvGraphXAxisFormat.getTickSpacing(), cvGraphXAxisFormat.getGridSpacing());
        }
    }

    public void setYConfiguration(String string) throws CvGraphInvalidInputException {
        CvGraphYAxisFormat cvGraphYAxisFormat = new CvGraphYAxisFormat();
        cvGraphYAxisFormat.setConfiguration(string);
        this.autoScale.setSelected(cvGraphYAxisFormat.getAutoScale());
        if (cvGraphYAxisFormat.getAutoScale()) {
            this.disableYFields();
        } else {
            this.updateYFields(cvGraphYAxisFormat.getMinValue(), cvGraphYAxisFormat.getMaxValue(), cvGraphYAxisFormat.getNumSpacing(), cvGraphYAxisFormat.getTickSpacing(), cvGraphYAxisFormat.getGridSpacing());
        }
    }

    private String truncateDouble(String string) {
        String string2 = string;
        if (this.containsLetter(string2)) {
            return string2;
        }
        int n = string.indexOf(".");
        if (n != -1) {
            String string3 = string.substring(0, n);
            int n2 = 0;
            if (string3 != null && string3.length() != 0) {
                n2 = new Double(string3).intValue();
            }
            if (n2 == 0) {
                int n3 = -1;
                if (n + 1 == string.length()) {
                    return string;
                }
                int n4 = n + 1;
                while (n4 < string.length()) {
                    if (string.charAt(n4) != '0') {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                if (string.length() > 6 && string.length() > n3 + 2) {
                    string2 = string.substring(0, n3 + 2);
                }
            } else if (string.length() > n + 3) {
                string2 = string.substring(0, n + 3);
            }
        }
        return string2;
    }

    public void updateXFields(int n, double d, double d2) {
        this.minutesToDisplay.setText(new Integer(n).toString());
        this.tickSpacingX.setText(new Double(d).toString());
        this.gridSpacingX.setText(new Double(d2).toString());
        this.minutesToDisplay.setEditable(true);
        this.tickSpacingX.setEditable(true);
        this.gridSpacingX.setEditable(true);
    }

    public void updateYFields(double d, double d2, double d3, double d4, double d5) {
        this.minValueField.setText(this.truncateDouble(new Double(d).toString()));
        this.maxValueField.setText(this.truncateDouble(new Double(d2).toString()));
        this.numSpacing.setText(this.truncateDouble(new Double(d3).toString()));
        this.tickSpacing.setText(this.truncateDouble(new Double(d4).toString()));
        this.gridSpacing.setText(this.truncateDouble(new Double(d5).toString()));
        this.minValueField.setEditable(true);
        this.maxValueField.setEditable(true);
        this.numSpacing.setEditable(true);
        this.tickSpacing.setEditable(true);
        this.gridSpacing.setEditable(true);
    }
}

