/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.ejb.persistence.bmp;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.EJBMetaData;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import oracle.aurora.ejb.persistence.PersistenceKey;
import oracle.aurora.ejb.persistence.PersistenceManagement;
import oracle.aurora.ejb.persistence.PmException;
import oracle.aurora.ejb.persistence.bmp.BmpHashtable;
import oracle.aurora.ejb.persistence.bmp.BmpKey;
import oracle.aurora.ejb.persistence.bmp.EntitySynchronization;
import oracle.aurora.ejb.server.AuroraEntityContext;
import oracle.aurora.jts.util.NoTransactionServiceException;
import oracle.aurora.jts.util.TS;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;

public abstract class BmpManager
implements PersistenceManagement {
    EntityBean fakeBean;
    protected BmpHashtable beanTable = new BmpHashtable();
    String previousTxn;

    protected void clearRegisteredSynchronization(PersistenceKey pk, String txName) {
        this.beanTable.remove(txName, pk);
    }

    public PersistenceKey create(EntityBean bean, Object primaryKey) throws PmException {
        return new BmpKey(primaryKey);
    }

    public EntityBean getBean(PersistenceKey persistenceKey, EntityContext ctx) throws RemoteException, PmException {
        this.previousTxn = this.getCurrentTransactionName();
        EntityBean b = this.beanTable.getBean(this.previousTxn, persistenceKey);
        if (b == null) {
            b = this.getNewBeanInstance();
            ((AuroraEntityContext)ctx).setPrimaryKey(persistenceKey.getPrimaryKey());
            b.setEntityContext(ctx);
            b.ejbLoad();
            this.registerSynchronization(b, persistenceKey, this.previousTxn);
            this.beanTable.put(this.previousTxn, persistenceKey, b);
        }
        return b;
    }

    protected String getCurrentTransactionName() throws IllegalStateException {
        try {
            return TS.getTS().getCurrent().get_transaction_name();
        }
        catch (NoTransactionServiceException noTransactionServiceException) {
            throw new IllegalStateException("No Transaction Service is available");
        }
    }

    protected EntityBean getFakeBean(EntityContext ctx) throws RemoteException, PmException {
        if (this.fakeBean == null) {
            this.fakeBean = this.getNewBeanInstance();
            this.fakeBean.setEntityContext(ctx);
        }
        return this.fakeBean;
    }

    public abstract EntityBean getNewBeanInstance() throws PmException;

    protected Enumeration makePkEnum(Enumeration pkList) {
        if (pkList == null) {
            return null;
        }
        Vector<BmpKey> v = new Vector<BmpKey>();
        while (pkList.hasMoreElements()) {
            v.addElement(new BmpKey(pkList.nextElement()));
        }
        return v.elements();
    }

    protected void registerSynchronization(EntityBean b, PersistenceKey pk, String txName) {
        try {
            Control current = TS.getTS().getCurrent().get_control();
            if (current == null) {
                return;
            }
            current.get_coordinator().register_synchronization(new EntitySynchronization(b, this, pk, txName));
        }
        catch (NoTransactionServiceException noTransactionServiceException) {
        }
        catch (SynchronizationUnavailable synchronizationUnavailable) {
        }
        catch (Unavailable unavailable) {
        }
        catch (Inactive inactive) {}
    }

    public void remove(PersistenceKey persistenceKey) throws PmException {
        this.beanTable.purge(persistenceKey);
    }

    public void shutdown() throws PmException {
    }

    public void startup(EJBMetaData ejbData) throws PmException {
    }
}

